/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.sqlite;

import com.android.pc.ioc.db.sqlite.Selector;
import com.android.pc.ioc.db.table.Foreign;
import com.android.pc.ioc.db.table.TableUtils;
import java.util.List;

public class ForeignLazyLoader<T> {
    private Foreign foreignColumn;
    private Object columnValue;

    public ForeignLazyLoader(Class<?> entityType, String columnName, Object columnValue) {
        this.foreignColumn = (Foreign)TableUtils.getColumnOrId(entityType, columnName);
        this.columnValue = columnValue;
    }

    public ForeignLazyLoader(Foreign foreignColumn, Object columnValue) {
        this.foreignColumn = foreignColumn;
        this.columnValue = columnValue;
    }

    public List<T> getAllFromDb() {
        List entities = null;
        if (this.foreignColumn != null && this.foreignColumn.db != null) {
            entities = this.foreignColumn.db.findAll(Selector.from(this.foreignColumn.getForeignEntityType()).where(this.foreignColumn.getForeignColumnName(), "=", this.columnValue));
        }
        return entities;
    }

    public T getFirstFromDb() {
        T entity = null;
        if (this.foreignColumn != null && this.foreignColumn.db != null) {
            entity = this.foreignColumn.db.findFirst(Selector.from(this.foreignColumn.getForeignEntityType()).where(this.foreignColumn.getForeignColumnName(), "=", this.columnValue));
        }
        return entity;
    }

    public Object getColumnValue() {
        return this.columnValue;
    }
}

