/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.sqlite;

import com.android.pc.ioc.db.sqlite.DbModelSelector;
import com.android.pc.ioc.db.sqlite.WhereBuilder;
import com.android.pc.ioc.db.table.Table;
import java.util.ArrayList;
import java.util.List;

public class Selector {
    protected Class<?> entityType;
    protected String tableName;
    protected WhereBuilder whereBuilder;
    protected List<OrderBy> orderByList;
    protected int limit = 0;
    protected int offset = 0;

    private Selector(Class<?> entityType) {
        this.entityType = entityType;
        this.tableName = Table.get(entityType).getTableName();
    }

    public static Selector from(Class<?> entityType) {
        return new Selector(entityType);
    }

    public Selector where(WhereBuilder whereBuilder) {
        this.whereBuilder = whereBuilder;
        return this;
    }

    public Selector where(String columnName, String op, Object value) {
        this.whereBuilder = WhereBuilder.b(columnName, op, value);
        return this;
    }

    public Selector and(String columnName, String op, Object value) {
        this.whereBuilder.append(columnName, op, value);
        return this;
    }

    public Selector or(String columnName, String op, Object value) {
        this.whereBuilder.appendOR(columnName, op, value);
        return this;
    }

    public DbModelSelector groupBy(String columnName) {
        return new DbModelSelector(this, columnName);
    }

    public DbModelSelector select(String ... columnExpressions) {
        return new DbModelSelector(this, columnExpressions);
    }

    public Selector orderBy(String columnName) {
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>(2);
        }
        this.orderByList.add(new OrderBy(columnName));
        return this;
    }

    public Selector orderBy(String columnName, boolean desc) {
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>(2);
        }
        this.orderByList.add(new OrderBy(columnName, desc));
        return this;
    }

    public Selector limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Selector offset(int offset) {
        this.offset = offset;
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        result.append("*");
        result.append(" FROM ").append(this.tableName);
        if (this.whereBuilder != null) {
            result.append(" WHERE ").append(this.whereBuilder.toString());
        }
        if (this.orderByList != null) {
            int i = 0;
            while (i < this.orderByList.size()) {
                result.append(" ORDER BY ").append(this.orderByList.get(i).toString());
                ++i;
            }
        }
        if (this.limit > 0) {
            result.append(" LIMIT ").append(this.limit);
            result.append(" OFFSET ").append(this.offset);
        }
        return result.toString();
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    protected class OrderBy {
        private String columnName;
        private boolean desc;

        public OrderBy(String columnName) {
            this.columnName = columnName;
        }

        public OrderBy(String columnName, boolean desc) {
            this.columnName = columnName;
            this.desc = desc;
        }

        public String toString() {
            return String.valueOf(this.columnName) + (this.desc ? " DESC" : " ASC");
        }
    }
}

