/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.sqlite;

import com.android.pc.ioc.db.sqlite.DbUtils;
import com.android.pc.ioc.db.sqlite.SqlInfo;
import com.android.pc.ioc.db.sqlite.WhereBuilder;
import com.android.pc.ioc.db.table.Column;
import com.android.pc.ioc.db.table.ColumnUtils;
import com.android.pc.ioc.db.table.Finder;
import com.android.pc.ioc.db.table.Foreign;
import com.android.pc.ioc.db.table.Id;
import com.android.pc.ioc.db.table.KeyValue;
import com.android.pc.ioc.db.table.Table;
import com.android.pc.ioc.db.table.TableUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqlInfoBuilder {
    private SqlInfoBuilder() {
    }

    public static SqlInfo buildInsertSqlInfo(DbUtils db, Object entity) {
        List<KeyValue> keyValueList = SqlInfoBuilder.entity2KeyValueList(db, entity);
        if (keyValueList.size() == 0) {
            return null;
        }
        SqlInfo result = new SqlInfo();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("INSERT INTO ");
        sqlBuffer.append(Table.get(entity.getClass()).getTableName());
        sqlBuffer.append(" (");
        for (KeyValue kv : keyValueList) {
            sqlBuffer.append(kv.getKey()).append(",");
            result.addBindArg(kv.getValue());
        }
        sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
        sqlBuffer.append(") VALUES (");
        int length = keyValueList.size();
        int i = 0;
        while (i < length) {
            sqlBuffer.append("?,");
            ++i;
        }
        sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
        sqlBuffer.append(")");
        result.setSql(sqlBuffer.toString());
        return result;
    }

    public static SqlInfo buildReplaceSqlInfo(DbUtils db, Object entity) {
        List<KeyValue> keyValueList = SqlInfoBuilder.entity2KeyValueList(db, entity);
        if (keyValueList.size() == 0) {
            return null;
        }
        SqlInfo result = new SqlInfo();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("REPLACE INTO ");
        sqlBuffer.append(Table.get(entity.getClass()).getTableName());
        sqlBuffer.append(" (");
        for (KeyValue kv : keyValueList) {
            sqlBuffer.append(kv.getKey()).append(",");
            result.addBindArg(kv.getValue());
        }
        sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
        sqlBuffer.append(") VALUES (");
        int length = keyValueList.size();
        int i = 0;
        while (i < length) {
            sqlBuffer.append("?,");
            ++i;
        }
        sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
        sqlBuffer.append(")");
        result.setSql(sqlBuffer.toString());
        return result;
    }

    private static String buildDeleteSqlByTableName(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public static SqlInfo buildDeleteSqlInfo(Object entity) throws Exception {
        SqlInfo result = new SqlInfo();
        Table table = Table.get(entity.getClass());
        Id id = table.getId();
        Object idValue = id.getColumnValue(entity);
        if (idValue == null) {
            throw new Exception("this entity[" + entity.getClass() + "]'s id value is null");
        }
        StringBuilder sb = new StringBuilder(SqlInfoBuilder.buildDeleteSqlByTableName(table.getTableName()));
        sb.append(" WHERE ").append(WhereBuilder.b(id.getColumnName(), "=", idValue));
        result.setSql(sb.toString());
        return result;
    }

    public static SqlInfo buildDeleteSqlInfo(Class<?> entityType, Object idValue) throws Exception {
        SqlInfo result = new SqlInfo();
        Table table = Table.get(entityType);
        Id id = table.getId();
        if (idValue == null) {
            throw new Exception("this entity[" + entityType + "]'s id value is null");
        }
        StringBuilder sb = new StringBuilder(SqlInfoBuilder.buildDeleteSqlByTableName(table.getTableName()));
        sb.append(" WHERE ").append(WhereBuilder.b(id.getColumnName(), "=", idValue));
        result.setSql(sb.toString());
        return result;
    }

    public static SqlInfo buildDeleteSqlInfo(Class<?> entityType, WhereBuilder whereBuilder) {
        Table table = Table.get(entityType);
        StringBuilder sb = new StringBuilder(SqlInfoBuilder.buildDeleteSqlByTableName(table.getTableName()));
        if (whereBuilder != null) {
            sb.append(" WHERE ").append(whereBuilder.toString());
        }
        return new SqlInfo(sb.toString());
    }

    public static SqlInfo buildUpdateSqlInfo(DbUtils db, Object entity) throws Exception {
        List<KeyValue> keyValueList = SqlInfoBuilder.entity2KeyValueList(db, entity);
        if (keyValueList.size() == 0) {
            return null;
        }
        Table table = Table.get(entity.getClass());
        Id id = table.getId();
        Object idValue = id.getColumnValue(entity);
        if (idValue == null) {
            throw new Exception("this entity[" + entity.getClass() + "]'s id value is null");
        }
        SqlInfo result = new SqlInfo();
        StringBuffer sqlBuffer = new StringBuffer("UPDATE ");
        sqlBuffer.append(table.getTableName());
        sqlBuffer.append(" SET ");
        for (KeyValue kv : keyValueList) {
            if (kv.getValue() == null) continue;
            sqlBuffer.append(kv.getKey()).append("=?,");
            result.addBindArg(kv.getValue());
        }
        sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
        sqlBuffer.append(" WHERE ").append(WhereBuilder.b(id.getColumnName(), "=", idValue));
        result.setSql(sqlBuffer.toString());
        return result;
    }

    public static SqlInfo buildUpdateSqlInfo(DbUtils db, Object entity, WhereBuilder whereBuilder) {
        List<KeyValue> keyValueList = SqlInfoBuilder.entity2KeyValueList(db, entity);
        if (keyValueList.size() == 0) {
            return null;
        }
        Table table = Table.get(entity.getClass());
        SqlInfo result = new SqlInfo();
        StringBuffer sqlBuffer = new StringBuffer("UPDATE ");
        sqlBuffer.append(table.getTableName());
        sqlBuffer.append(" SET ");
        for (KeyValue kv : keyValueList) {
            sqlBuffer.append(kv.getKey()).append("=?,");
            result.addBindArg(kv.getValue());
        }
        sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
        if (whereBuilder != null) {
            sqlBuffer.append(" WHERE ").append(whereBuilder.toString());
        }
        result.setSql(sqlBuffer.toString());
        return result;
    }

    public static SqlInfo buildCreateTableSqlInfo(Class<?> entityType) {
        Table table = Table.get(entityType);
        Id id = table.getId();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE IF NOT EXISTS ");
        sqlBuffer.append(table.getTableName());
        sqlBuffer.append(" ( ");
        if (id.isAutoIncrement()) {
            sqlBuffer.append("\"").append(id.getColumnName()).append("\"  ").append("INTEGER PRIMARY KEY AUTOINCREMENT,");
        } else {
            sqlBuffer.append("\"").append(id.getColumnName()).append("\"  ").append(id.getColumnDbType()).append(" PRIMARY KEY,");
        }
        Collection<Column> columns = table.columnMap.values();
        for (Column column : columns) {
            String check;
            if (column instanceof Finder) continue;
            sqlBuffer.append("\"").append(column.getColumnName()).append("\"  ");
            sqlBuffer.append(column.getColumnDbType());
            if (ColumnUtils.isUnique(column.getColumnField())) {
                sqlBuffer.append(" UNIQUE");
            }
            if (ColumnUtils.isNotNull(column.getColumnField())) {
                sqlBuffer.append(" NOT NULL");
            }
            if ((check = ColumnUtils.getCheck(column.getColumnField())) != null) {
                sqlBuffer.append(" CHECK(").append(check).append(")");
            }
            sqlBuffer.append(",");
        }
        sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
        sqlBuffer.append(" )");
        return new SqlInfo(sqlBuffer.toString());
    }

    private static KeyValue column2KeyValue(Object entity, Column column) {
        KeyValue kv = null;
        String key = column.getColumnName();
        Object value = column.getColumnValue(entity);
        Object object = value = value == null ? column.getDefaultValue() : value;
        if (key != null && value != null) {
            kv = new KeyValue(key, value);
        }
        return kv;
    }

    public static List<KeyValue> entity2KeyValueList(DbUtils db, Object entity) {
        ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>();
        Table table = Table.get(entity.getClass());
        Id id = table.getId();
        Object idValue = TableUtils.getIdValue(entity);
        if (id != null && idValue != null) {
            KeyValue kv = new KeyValue(id.getColumnName(), idValue);
            keyValueList.add(kv);
        }
        Collection<Column> columns = table.columnMap.values();
        for (Column column : columns) {
            if (column instanceof Finder) {
                ((Finder)column).db = db;
            } else if (column instanceof Foreign) {
                ((Foreign)column).db = db;
            }
            KeyValue kv = SqlInfoBuilder.column2KeyValue(entity, column);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        return keyValueList;
    }
}

