/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.table;

import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.db.table.ColumnUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Column {
    protected String columnName;
    private Object defaultValue;
    protected Method getMethod;
    protected Method setMethod;
    protected Field columnField;

    protected Column(Class entityType, Field field) {
        this.columnField = field;
        this.columnName = ColumnUtils.getColumnNameByField(field);
        this.defaultValue = ColumnUtils.getColumnDefaultValue(field);
        this.getMethod = ColumnUtils.getColumnGetMethod(entityType, field);
        this.setMethod = ColumnUtils.getColumnSetMethod(entityType, field);
    }

    public void setValue2Entity(Object entity, String valueStr) {
        Object value = null;
        if (valueStr != null) {
            Class<?> columnType = this.columnField.getType();
            value = ColumnUtils.valueStr2SimpleTypeFieldValue(columnType, valueStr);
        }
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(entity, value == null ? this.defaultValue : value);
            }
            catch (Exception e) {
                Ioc.getIoc().getLogger().e(e);
            }
        } else {
            try {
                this.columnField.setAccessible(true);
                this.columnField.set(entity, value == null ? this.defaultValue : value);
            }
            catch (Exception e) {
                Ioc.getIoc().getLogger().e(e);
            }
        }
    }

    public Object getColumnValue(Object entity) {
        Object resultObj = null;
        if (entity != null) {
            if (this.getMethod != null) {
                try {
                    resultObj = this.getMethod.invoke(entity, new Object[0]);
                }
                catch (Exception e) {
                    Ioc.getIoc().getLogger().e(e);
                }
            } else {
                try {
                    this.columnField.setAccessible(true);
                    resultObj = this.columnField.get(entity);
                }
                catch (Exception e) {
                    Ioc.getIoc().getLogger().e(e);
                }
            }
        }
        return ColumnUtils.convert2DbColumnValueIfNeeded(resultObj);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Field getColumnField() {
        return this.columnField;
    }

    public String getColumnDbType() {
        return ColumnUtils.fieldType2DbType(this.columnField.getType());
    }
}

