/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.event;

import com.android.pc.ioc.event.EventBus;
import com.android.pc.ioc.event.PendingPost;
import com.android.pc.ioc.event.PendingPostQueue;
import com.android.pc.ioc.event.Subscription;

class AsyncPoster
implements Runnable {
    private final PendingPostQueue queue;
    private final EventBus eventBus;

    AsyncPoster(EventBus eventBus) {
        this.eventBus = eventBus;
        this.queue = new PendingPostQueue();
    }

    public void enqueue(Subscription subscription, Object event) {
        PendingPost pendingPost = PendingPost.obtainPendingPost(subscription, event);
        this.queue.enqueue(pendingPost);
        EventBus.executorService.execute(this);
    }

    @Override
    public void run() {
        PendingPost pendingPost = this.queue.poll();
        if (pendingPost == null) {
            throw new IllegalStateException("No pending post available");
        }
        this.eventBus.invokeSubscriber(pendingPost);
    }
}

