/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.event;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.android.pc.ioc.event.EventBus;
import com.android.pc.ioc.event.EventBusException;
import com.android.pc.ioc.event.PendingPost;
import com.android.pc.ioc.event.PendingPostQueue;
import com.android.pc.ioc.event.Subscription;

final class HandlerPoster
extends Handler {
    private final PendingPostQueue queue;
    private final int maxMillisInsideHandleMessage;
    private final EventBus eventBus;
    private boolean handlerActive;

    HandlerPoster(EventBus eventBus, Looper looper, int maxMillisInsideHandleMessage) {
        super(looper);
        this.eventBus = eventBus;
        this.maxMillisInsideHandleMessage = maxMillisInsideHandleMessage;
        this.queue = new PendingPostQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Subscription subscription, Object event) {
        PendingPost pendingPost = PendingPost.obtainPendingPost(subscription, event);
        HandlerPoster handlerPoster = this;
        synchronized (handlerPoster) {
            this.queue.enqueue(pendingPost);
            if (!this.handlerActive) {
                this.handlerActive = true;
                if (!this.sendMessage(this.obtainMessage())) {
                    throw new EventBusException("Could not send handler message");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleMessage(Message msg) {
        boolean rescheduled = false;
        try {
            long timeInMethod;
            long started = SystemClock.uptimeMillis();
            do {
                PendingPost pendingPost;
                if ((pendingPost = this.queue.poll()) == null) {
                    HandlerPoster handlerPoster = this;
                    synchronized (handlerPoster) {
                        pendingPost = this.queue.poll();
                        if (pendingPost == null) {
                            this.handlerActive = false;
                            return;
                        }
                    }
                }
                this.eventBus.invokeSubscriber(pendingPost);
            } while ((timeInMethod = SystemClock.uptimeMillis() - started) < (long)this.maxMillisInsideHandleMessage);
            if (!this.sendMessage(this.obtainMessage())) {
                throw new EventBusException("Could not send handler message");
            }
            rescheduled = true;
            return;
        }
        finally {
            this.handlerActive = rescheduled;
        }
    }
}

