/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.image;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.widget.Toast;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.image.ImageWorker;
import com.android.pc.ioc.image.RecyclingBitmapDrawable;
import com.android.pc.ioc.image.Utils;
import com.android.pc.util.LruCache;
import java.io.File;
import java.lang.ref.SoftReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ImageCache {
    private static final int DEFAULT_MEM_CACHE_SIZE = 5120;
    private static final int HTTP_CACHE_SIZE = 0xA00000;
    private static final int DEFAULT_DISK_CACHE_SIZE = 0xA00000;
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final int DEFAULT_COMPRESS_QUALITY = 70;
    private static final boolean DEFAULT_MEM_CACHE_ENABLED = true;
    private static final boolean DEFAULT_DISK_CACHE_ENABLED = true;
    private static final boolean DEFAULT_INIT_DISK_CACHE_ON_CREATE = false;
    private LruCache<String, BitmapDrawable> mMemoryCache;
    private ImageCacheParams mCacheParams;
    private final Object mDiskCacheLock = new Object();
    private boolean mDiskCacheStarting = true;
    private Set<SoftReference<Bitmap>> mReusableBitmaps;
    private static ImageCache imageCache;

    private ImageCache(ImageCacheParams cacheParams) {
        this.init(cacheParams);
    }

    public static ImageCache getInstance(ImageCacheParams cacheParams) {
        if (imageCache == null) {
            imageCache = new ImageCache(cacheParams);
        }
        return imageCache;
    }

    private void init(ImageCacheParams cacheParams) {
        this.mCacheParams = cacheParams;
        if (this.mCacheParams.memoryCacheEnabled) {
            Ioc.getIoc().getLogger().d("Memory cache created (size = " + this.mCacheParams.memCacheSize + ")");
            if (Utils.hasHoneycomb()) {
                this.mReusableBitmaps = Collections.synchronizedSet(new HashSet());
            }
            this.mMemoryCache = new LruCache<String, BitmapDrawable>(this.mCacheParams.memCacheSize){

                @Override
                protected void entryRemoved(boolean evicted, String key, BitmapDrawable oldValue, BitmapDrawable newValue) {
                    if (RecyclingBitmapDrawable.class.isInstance(oldValue)) {
                        ((RecyclingBitmapDrawable)oldValue).setIsCached(false);
                    } else if (Utils.hasHoneycomb()) {
                        ImageCache.this.mReusableBitmaps.add(new SoftReference<Bitmap>(oldValue.getBitmap()));
                    }
                }

                @Override
                protected int sizeOf(String key, BitmapDrawable value) {
                    int bitmapSize = ImageCache.getBitmapSize(value) / 1024;
                    return bitmapSize == 0 ? 1 : bitmapSize;
                }
            };
        }
        if (cacheParams.initDiskCacheOnCreate) {
            this.initDiskCache();
        }
    }

    public ImageCacheParams getmCacheParams() {
        return this.mCacheParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            File file = this.mCacheParams.diskCacheDir;
            if (!file.exists()) {
                file.mkdirs();
            }
            if (ImageCache.getUsableSpace(this.mCacheParams.diskCacheDir) < 0xA00000L) {
                Looper.prepare();
                Toast.makeText((Context)Ioc.getIoc().getApplication(), (CharSequence)"\u5b58\u50a8\u7a7a\u95f4\u4e0d\u8db3,\u8bf7\u68c0\u67e5", (int)1).show();
                Looper.loop();
            }
            this.mDiskCacheStarting = false;
            this.mDiskCacheLock.notifyAll();
        }
    }

    public void addBitmapToCache(String data, BitmapDrawable value) {
        if (data == null || value == null) {
            return;
        }
        if (this.mMemoryCache != null) {
            if (RecyclingBitmapDrawable.class.isInstance(value)) {
                ((RecyclingBitmapDrawable)value).setIsCached(true);
            }
            this.mMemoryCache.put(data, value);
        }
    }

    public BitmapDrawable getBitmapFromMemCache(String data) {
        BitmapDrawable memValue = null;
        if (this.mMemoryCache != null) {
            memValue = this.mMemoryCache.get(data);
        }
        return memValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getBitmapFromDiskCache(String data, int w, int h, ImageWorker imWorker) {
        String key = ImageCache.hashKeyForDisk(data);
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (true) {
                if (!this.mDiskCacheStarting) {
                    File file = ImageCache.getFromFileCache(key);
                    Bitmap bitmap = null;
                    if (file == null) return bitmap;
                    if (!file.exists()) return bitmap;
                    return imWorker.decodeSampledBitmapFromFile(data, file.getPath(), w, h, this);
                }
                try {
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap getBitmapFromReusableSet(BitmapFactory.Options options) {
        Bitmap bitmap = null;
        if (this.mReusableBitmaps != null && !this.mReusableBitmaps.isEmpty()) {
            Set<SoftReference<Bitmap>> set = this.mReusableBitmaps;
            synchronized (set) {
                Iterator<SoftReference<Bitmap>> iterator = this.mReusableBitmaps.iterator();
                while (iterator.hasNext()) {
                    Bitmap item = iterator.next().get();
                    if (item != null && item.isMutable()) {
                        if (!ImageCache.canUseForInBitmap(item, options)) continue;
                        bitmap = item;
                        iterator.remove();
                        break;
                    }
                    iterator.remove();
                }
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
            Ioc.getIoc().getLogger().d("\u7f13\u5b58\u6e05\u7406\u6210\u529f");
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mDiskCacheStarting = true;
            File file = this.mCacheParams.diskCacheDir;
            if (file.exists()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    files[i].delete();
                    files[i].deleteOnExit();
                    ++i;
                }
            }
            Ioc.getIoc().getLogger().d("\u672c\u5730\u78c1\u76d8\u6e05\u7406\u6210\u529f");
            this.initDiskCache();
        }
    }

    @TargetApi(value=19)
    private static boolean canUseForInBitmap(Bitmap candidate, BitmapFactory.Options targetOptions) {
        if (!Utils.hasKitKat()) {
            return candidate.getWidth() == targetOptions.outWidth && candidate.getHeight() == targetOptions.outHeight && targetOptions.inSampleSize == 1;
        }
        int width = targetOptions.outWidth / targetOptions.inSampleSize;
        int height = targetOptions.outHeight / targetOptions.inSampleSize;
        int byteCount = width * height * ImageCache.getBytesPerPixel(candidate.getConfig());
        return byteCount <= candidate.getAllocationByteCount();
    }

    private static int getBytesPerPixel(Bitmap.Config config) {
        if (config == Bitmap.Config.ARGB_8888) {
            return 4;
        }
        if (config == Bitmap.Config.RGB_565) {
            return 2;
        }
        if (config == Bitmap.Config.ARGB_4444) {
            return 2;
        }
        if (config == Bitmap.Config.ALPHA_8) {
            return 1;
        }
        return 1;
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !ImageCache.isExternalStorageRemovable() ? ImageCache.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath();
        return new File(String.valueOf(cachePath) + File.separator + uniqueName);
    }

    public static String hashKeyForDisk(String key) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = ImageCache.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    @TargetApi(value=19)
    public static int getBitmapSize(BitmapDrawable value) {
        Bitmap bitmap = value.getBitmap();
        if (Utils.hasKitKat()) {
            return bitmap.getAllocationByteCount();
        }
        if (Utils.hasHoneycombMR1()) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    @TargetApi(value=9)
    public static boolean isExternalStorageRemovable() {
        if (Utils.hasGingerbread()) {
            return Environment.isExternalStorageRemovable();
        }
        return true;
    }

    @TargetApi(value=8)
    public static File getExternalCacheDir(Context context) {
        if (Utils.hasFroyo()) {
            return context.getExternalCacheDir();
        }
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/images";
        return new File(String.valueOf(Environment.getExternalStorageDirectory().getPath()) + cacheDir);
    }

    public static File getFromFileCache(String fileName) {
        File file = ImageCache.imageCache.getmCacheParams().diskCacheDir;
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, fileName);
    }

    @TargetApi(value=9)
    public static long getUsableSpace(File path) {
        if (Utils.hasGingerbread()) {
            return path.getUsableSpace();
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }

    static /* synthetic */ Bitmap.CompressFormat access$0() {
        return DEFAULT_COMPRESS_FORMAT;
    }

    public static class ImageCacheParams {
        public int memCacheSize = 5120;
        public int diskCacheSize = 0xA00000;
        public File diskCacheDir;
        public Bitmap.CompressFormat compressFormat = ImageCache.access$0();
        public int compressQuality = 70;
        public boolean memoryCacheEnabled = true;
        public boolean diskCacheEnabled = true;
        public boolean initDiskCacheOnCreate = false;

        public ImageCacheParams(Context context, String diskCacheDirectoryName) {
            this.diskCacheDir = ImageCache.getDiskCacheDir(context, diskCacheDirectoryName);
        }

        public void setMemCacheSizePercent(float percent) {
            if (percent < 0.01f || percent > 0.8f) {
                throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.01 and 0.8 (inclusive)");
            }
            this.memCacheSize = Math.round(percent * (float)Runtime.getRuntime().maxMemory() / 1024.0f);
        }
    }
}

