/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.image;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Handler;
import android.os.Message;
import android.widget.ImageView;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.image.AsyncTask;
import com.android.pc.ioc.image.DisplayerLister;
import com.android.pc.ioc.image.ImageCache;
import com.android.pc.ioc.image.ImageLoadManager;
import com.android.pc.ioc.image.RecyclingBitmapDrawable;
import com.android.pc.ioc.image.Utils;
import com.android.pc.util.Handler_System;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class ImageWorker {
    private static final int FADE_IN_TIME = 200;
    private static final int start = 0;
    private static final int process = 1;
    private static final int fail = 2;
    private static final int finish = 3;
    private ImageCache mImageCache;
    private Bitmap mLoadingBitmap;
    private boolean mFadeInBitmap = true;
    private boolean mExitTasksEarly = false;
    protected boolean mPauseWork = false;
    private final Object mPauseWorkLock = new Object();
    protected Resources mResources;
    protected DisplayerLister lister;
    private boolean isDecode = false;
    protected int mImageWidth;
    protected int mImageHeight;
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            Entity entity = (Entity)msg.obj;
            switch (msg.what) {
                case 0: {
                    entity.lister.startLoader(entity.imageView);
                    break;
                }
                case 1: {
                    entity.lister.progressLoader(entity.process, entity.imageView);
                    break;
                }
                case 2: {
                    entity.lister.failLoader(entity.imageView);
                    break;
                }
                case 3: {
                    entity.lister.finishLoader(entity.bitmap, entity.imageView);
                }
            }
        }
    };

    protected ImageWorker(Context context) {
        this.mResources = context.getResources();
    }

    public ImageWorker(Context context, int imageWidth, int imageHeight) {
        this.setImageSize(imageWidth, imageHeight);
        this.mResources = context.getResources();
    }

    public ImageWorker(Context context, int imageSize) {
        this.setImageSize(imageSize);
        this.mResources = context.getResources();
    }

    public void useDecode(boolean isDecode) {
        this.isDecode = isDecode;
    }

    public boolean isDecode() {
        return this.isDecode;
    }

    public void loadImage(Object data, ImageView imageView) {
        if (data == null) {
            return;
        }
        data = data.toString().indexOf("?") != -1 ? data + "&w=" + this.getW() + "&h=" + this.getH() : data + "?w=" + this.getW() + "&h=" + this.getH();
        BitmapDrawable value = null;
        this.mImageCache = ImageLoadManager.instance().getmImageCache();
        if (this.mImageCache != null) {
            value = this.mImageCache.getBitmapFromMemCache(String.valueOf(data));
        }
        if (value != null) {
            if (value.getBitmap() != null) {
                this.finish(value.getBitmap(), imageView, this.lister);
            }
            imageView.setImageDrawable((Drawable)value);
        } else if (ImageWorker.cancelPotentialWork(data, imageView)) {
            BitmapWorkerTask task = new BitmapWorkerTask(data, imageView, this.lister);
            AsyncDrawable asyncDrawable = new AsyncDrawable(this.mResources, this.mLoadingBitmap, task);
            imageView.setImageDrawable((Drawable)asyncDrawable);
            task.executeOnExecutor(AsyncTask.DUAL_THREAD_EXECUTOR, new Void[0]);
        }
    }

    public void loadImage(Object data, ImageView imageView, DisplayerLister lister) {
        this.lister = lister;
        this.loadImage(data, imageView);
    }

    public void setLoadingImage(Bitmap bitmap) {
        this.mLoadingBitmap = bitmap;
    }

    public void setLoadingImage(int resId) {
        this.mLoadingBitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)resId);
    }

    public void setImageFadeIn(boolean fadeIn) {
        this.mFadeInBitmap = fadeIn;
    }

    public void setExitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
        this.setPauseWork(false);
    }

    protected void process(int process, ImageView imageView, DisplayerLister lister) {
        if (lister == null) {
            return;
        }
        Message msg = this.handler.obtainMessage();
        Entity entity = new Entity();
        entity.process = process;
        entity.imageView = imageView;
        entity.lister = lister;
        msg.obj = entity;
        msg.what = process;
        msg.sendToTarget();
    }

    protected void finish(Bitmap bitmap, ImageView imageView, DisplayerLister lister) {
        if (lister == null) {
            return;
        }
        Message msg = this.handler.obtainMessage();
        Entity entity = new Entity();
        entity.bitmap = bitmap;
        entity.imageView = imageView;
        entity.lister = lister;
        msg.obj = entity;
        msg.what = 3;
        msg.sendToTarget();
    }

    protected void fail(ImageView imageView, DisplayerLister lister) {
        if (lister == null) {
            return;
        }
        Message msg = this.handler.obtainMessage();
        Entity entity = new Entity();
        entity.imageView = imageView;
        entity.lister = lister;
        msg.obj = entity;
        msg.what = 2;
        msg.sendToTarget();
    }

    protected void start(ImageView imageView, DisplayerLister lister) {
        if (lister == null) {
            return;
        }
        Message msg = this.handler.obtainMessage();
        Entity entity = new Entity();
        entity.imageView = imageView;
        entity.lister = lister;
        msg.obj = entity;
        msg.what = 0;
        msg.sendToTarget();
    }

    protected ImageCache getImageCache() {
        return this.mImageCache;
    }

    public static void cancelWork(ImageView imageView) {
        BitmapWorkerTask bitmapWorkerTask = ImageWorker.getBitmapWorkerTask(imageView);
        if (bitmapWorkerTask != null) {
            bitmapWorkerTask.cancel(true);
            Object bitmapData = bitmapWorkerTask.mData;
            Ioc.getIoc().getLogger().d("cancelWork - cancelled work for " + bitmapData);
        }
    }

    public static boolean cancelPotentialWork(Object data, ImageView imageView) {
        BitmapWorkerTask bitmapWorkerTask = ImageWorker.getBitmapWorkerTask(imageView);
        if (bitmapWorkerTask != null) {
            Object bitmapData = bitmapWorkerTask.mData;
            if (bitmapData == null || !bitmapData.equals(data)) {
                bitmapWorkerTask.cancel(true);
                Ioc.getIoc().getLogger().d("cancelPotentialWork - cancelled work for " + data);
            } else {
                return false;
            }
        }
        return true;
    }

    private static BitmapWorkerTask getBitmapWorkerTask(ImageView imageView) {
        Drawable drawable;
        if (imageView != null && (drawable = imageView.getDrawable()) instanceof AsyncDrawable) {
            AsyncDrawable asyncDrawable = (AsyncDrawable)drawable;
            return asyncDrawable.getBitmapWorkerTask();
        }
        return null;
    }

    private void setImageDrawable(ImageView imageView, Drawable drawable) {
        if (this.mFadeInBitmap) {
            TransitionDrawable td = new TransitionDrawable(new Drawable[]{new ColorDrawable(17170445), drawable});
            imageView.setImageDrawable((Drawable)td);
            td.startTransition(200);
        } else {
            imageView.setImageDrawable(drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPauseWork(boolean pauseWork) {
        Object object = this.mPauseWorkLock;
        synchronized (object) {
            this.mPauseWork = pauseWork;
            if (!this.mPauseWork) {
                this.mPauseWorkLock.notifyAll();
            }
        }
    }

    public void setImageSize(int width, int height) {
        HashMap<String, Integer> data = Handler_System.getDisplayMetrics();
        if (width == 0) {
            width = data.get("width");
        }
        if (height == 0) {
            height = data.get("height");
        }
        this.mImageWidth = width;
        this.mImageHeight = height;
    }

    public void setImageSize(int size) {
        this.setImageSize(size, size);
    }

    private Bitmap processBitmap(int resId) {
        Ioc.getIoc().getLogger().d("\u56fe\u7247\u4e0b\u8f7d\u5f00\u59cb - " + resId);
        return this.decodeSampledBitmapFromResource(this.mResources, resId, this.mImageWidth, this.mImageHeight, this.getImageCache());
    }

    protected Bitmap processBitmap(Object data, ImageView imageView) {
        return this.processBitmap(Integer.parseInt(String.valueOf(data)));
    }

    public Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight, ImageCache cache) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Utils.hasHoneycomb()) {
            this.addInBitmapOptions(options, cache);
        }
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    public Bitmap decodeSampledBitmapFromFile(String url, String filename, int reqWidth, int reqHeight, ImageCache cache) {
        byte[] buffer;
        FileInputStream in;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        ImageLoadManager.Coding coding = ImageLoadManager.instance().getCoding();
        if (coding == null || !this.isDecode) {
            BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
        } else if (this.isDecode && coding != null) {
            try {
                in = new FileInputStream(filename);
                buffer = url.toLowerCase().indexOf(".jpg") != -1 ? coding.decodeJPG(((InputStream)in).available(), in) : coding.decodePNG(((InputStream)in).available(), in);
                ((InputStream)in).close();
                BitmapFactory.decodeByteArray((byte[])buffer, (int)0, (int)buffer.length, (BitmapFactory.Options)options);
                buffer = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Utils.hasHoneycomb()) {
            this.addInBitmapOptions(options, cache);
        }
        options.inJustDecodeBounds = false;
        if (coding == null || !this.isDecode) {
            return BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
        }
        if (this.isDecode && coding != null) {
            try {
                in = new FileInputStream(filename);
                buffer = url.toLowerCase().indexOf(".jpg") != -1 ? coding.decodeJPG(((InputStream)in).available(), in) : coding.decodePNG(((InputStream)in).available(), in);
                ((InputStream)in).close();
                return BitmapFactory.decodeByteArray((byte[])buffer, (int)0, (int)buffer.length, (BitmapFactory.Options)options);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Bitmap decodeSampledBitmapFromDescriptor(FileDescriptor fileDescriptor, int reqWidth, int reqHeight, ImageCache cache) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        if (Utils.hasHoneycomb()) {
            this.addInBitmapOptions(options, cache);
        }
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
    }

    @TargetApi(value=11)
    private void addInBitmapOptions(BitmapFactory.Options options, ImageCache cache) {
        Bitmap inBitmap;
        options.inMutable = true;
        if (cache != null && (inBitmap = cache.getBitmapFromReusableSet(options)) != null) {
            options.inBitmap = inBitmap;
        }
    }

    public int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
            long totalPixels = width * height / inSampleSize;
            long totalReqPixelsCap = reqWidth * reqHeight * 2;
            while (totalPixels > totalReqPixelsCap) {
                inSampleSize *= 2;
                totalPixels /= 2L;
            }
        }
        return inSampleSize;
    }

    protected int getW() {
        return this.mImageWidth;
    }

    protected int getH() {
        return this.mImageHeight;
    }

    private static class AsyncDrawable
    extends BitmapDrawable {
        private final WeakReference<BitmapWorkerTask> bitmapWorkerTaskReference;

        public AsyncDrawable(Resources res, Bitmap bitmap, BitmapWorkerTask bitmapWorkerTask) {
            super(res, bitmap);
            this.bitmapWorkerTaskReference = new WeakReference<BitmapWorkerTask>(bitmapWorkerTask);
        }

        public BitmapWorkerTask getBitmapWorkerTask() {
            return (BitmapWorkerTask)this.bitmapWorkerTaskReference.get();
        }
    }

    private class BitmapWorkerTask
    extends AsyncTask<Void, Void, BitmapDrawable> {
        private Object mData;
        private final WeakReference<ImageView> imageViewReference;
        protected final DisplayerLister lister;

        public BitmapWorkerTask(Object data, ImageView imageView, DisplayerLister lister) {
            this.mData = data;
            this.imageViewReference = new WeakReference<ImageView>(imageView);
            this.lister = lister;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected BitmapDrawable doInBackground(Void ... params) {
            Ioc.getIoc().getLogger().d("doInBackground - starting work");
            String dataString = String.valueOf(this.mData);
            Bitmap bitmap = null;
            Object drawable = null;
            Object object = ImageWorker.this.mPauseWorkLock;
            synchronized (object) {
                while (ImageWorker.this.mPauseWork && !this.isCancelled()) {
                    try {
                        ImageWorker.this.mPauseWorkLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (ImageWorker.this.mImageCache != null && !this.isCancelled() && this.getAttachedImageView() != null && !ImageWorker.this.mExitTasksEarly) {
                bitmap = ImageWorker.this.mImageCache.getBitmapFromDiskCache(dataString, ImageWorker.this.getW(), ImageWorker.this.getH(), ImageWorker.this);
            }
            if (bitmap == null && !this.isCancelled() && this.getAttachedImageView() != null && !ImageWorker.this.mExitTasksEarly) {
                bitmap = ImageWorker.this.processBitmap(this.mData, (ImageView)this.imageViewReference.get());
            }
            if (bitmap != null) {
                drawable = Utils.hasHoneycomb() ? new BitmapDrawable(ImageWorker.this.mResources, bitmap) : new RecyclingBitmapDrawable(ImageWorker.this.mResources, bitmap);
                if (ImageWorker.this.mImageCache != null) {
                    ImageWorker.this.mImageCache.addBitmapToCache(dataString, (BitmapDrawable)drawable);
                }
            }
            Ioc.getIoc().getLogger().d("doInBackground - finished work");
            return drawable;
        }

        @Override
        protected void onPostExecute(BitmapDrawable value) {
            if (this.isCancelled() || ImageWorker.this.mExitTasksEarly) {
                value = null;
            }
            ImageView imageView = this.getAttachedImageView();
            if (value != null && imageView != null) {
                if (value.getBitmap() != null) {
                    ImageWorker.this.finish(value.getBitmap(), imageView, this.lister);
                }
                Ioc.getIoc().getLogger().d("onPostExecute - setting bitmap");
                ImageWorker.this.setImageDrawable(imageView, (Drawable)value);
            }
            if (value == null) {
                ImageWorker.this.fail(imageView, this.lister);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCancelled(BitmapDrawable value) {
            super.onCancelled(value);
            Object object = ImageWorker.this.mPauseWorkLock;
            synchronized (object) {
                ImageWorker.this.mPauseWorkLock.notifyAll();
            }
        }

        private ImageView getAttachedImageView() {
            ImageView imageView = (ImageView)this.imageViewReference.get();
            BitmapWorkerTask bitmapWorkerTask = ImageWorker.getBitmapWorkerTask(imageView);
            if (this == bitmapWorkerTask) {
                return imageView;
            }
            return null;
        }

        protected void onProgressUpdate(Void ... values) {
            super.onProgressUpdate(values);
        }
    }

    private class Entity {
        public int process;
        public ImageView imageView;
        public Bitmap bitmap;
        public DisplayerLister lister;

        private Entity() {
        }
    }
}

