/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.internet;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Xml;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.internet.AjaxCallBack;
import com.android.pc.ioc.internet.AjaxTimeCallBack;
import com.android.pc.ioc.internet.HttpCache;
import com.android.pc.ioc.internet.InternetConfig;
import com.android.pc.ioc.internet.ResponseEntity;
import com.android.pc.ioc.internet.SSLSocketFactoryEx;
import com.android.pc.ioc.internet.XMLtoJsonUtil;
import com.android.pc.util.Handler_Network;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.xmlpull.v1.XmlSerializer;

public class FastHttp {
    public static final int result_ok = 0;
    public static final int result_net_err = 1;
    private static final String METHOD = "method";
    public static final String BOUNDARY = UUID.randomUUID().toString();
    public static final String PREFIX = "--";
    public static final String LINEND = "\r\n";
    public static final String MULTIPART_FROM_DATA = "multipart/form-data";
    public static String cookies;
    private static MyHostnameVerifier hnv;

    static {
        hnv = new MyHostnameVerifier();
    }

    public static ResponseEntity get(String url) {
        return FastHttp.get(url, null, InternetConfig.defaultConfig());
    }

    public static ResponseEntity get(String url, InternetConfig config) {
        return FastHttp.get(url, null, config);
    }

    public static ResponseEntity get(String url, LinkedHashMap<String, String> params) {
        return FastHttp.get(url, params, InternetConfig.defaultConfig());
    }

    public static ResponseEntity get(String url, LinkedHashMap<String, String> params, InternetConfig config) {
        config.setRequest_type(1);
        if (params != null) {
            url = url.indexOf("\\?") != -1 ? String.valueOf(url) + "?" : String.valueOf(url) + "&";
            for (Map.Entry<String, String> entry : params.entrySet()) {
                url = String.valueOf(url) + entry.getKey() + "=" + entry.getValue() + "&";
            }
            url = url.substring(0, url.length() - 1);
        }
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setUrl(url);
        responseEntity.setParams(params);
        responseEntity.setKey(config.getKey());
        if (config.isSave() && !Handler_Network.isNetworkAvailable((Context)Ioc.getIoc().getApplication())) {
            Ioc.getIoc().getLogger().e("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc \u5c06\u83b7\u53d6\u79bb\u7ebf\u6570\u636e");
            String result = HttpCache.getUrlCache(url, params);
            if (result != null) {
                responseEntity.setContent(result, false);
                responseEntity.setStatus(0);
                return responseEntity;
            }
        }
        try {
            HttpURLConnection conn = FastHttp.getDefaultHttpClient(url, config);
            InputStream inStream = conn.getInputStream();
            FastHttp.getCookies(config, responseEntity, conn);
            responseEntity.setContent(FastHttp.inputStreamToString(inStream, config.getCharset()), config.isSave());
            conn.disconnect();
            responseEntity.setStatus(0);
            if (responseEntity.getContentAsString().length() == 0) {
                responseEntity.setStatus(1);
            }
            return responseEntity;
        }
        catch (Exception e) {
            responseEntity.setStatus(1);
            e.printStackTrace();
            return responseEntity;
        }
    }

    public static ResponseEntity post(String url) {
        return FastHttp.post(url, null, InternetConfig.defaultConfig());
    }

    public static ResponseEntity post(String url, LinkedHashMap<String, String> params) {
        return FastHttp.post(url, params, InternetConfig.defaultConfig());
    }

    public static ResponseEntity post(String url, LinkedHashMap<String, String> params, InternetConfig config) {
        config.setRequest_type(0);
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setUrl(url);
        responseEntity.setParams(params);
        responseEntity.setKey(config.getKey());
        if (config.isSave() && !Handler_Network.isNetworkAvailable((Context)Ioc.getIoc().getApplication())) {
            Ioc.getIoc().getLogger().e("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc \u5c06\u83b7\u53d6\u79bb\u7ebf\u6570\u636e");
            String result = HttpCache.getUrlCache(url, params);
            if (result != null) {
                responseEntity.setContent(result, false);
                responseEntity.setStatus(0);
                return responseEntity;
            }
        }
        try {
            HttpURLConnection conn = FastHttp.getDefaultHttpClient(url, config);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();
            OutputStream out = conn.getOutputStream();
            String values = "";
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    values = String.valueOf(values) + entry.getKey() + "=" + entry.getValue() + "&";
                }
                values = values.substring(0, values.length() - 1);
                out.write(values.getBytes(config.getCharset()));
            }
            out.flush();
            out.close();
            InputStream inStream = conn.getInputStream();
            FastHttp.getCookies(config, responseEntity, conn);
            responseEntity.setContent(FastHttp.inputStreamToString(inStream, config.getCharset()), config.isSave());
            conn.disconnect();
            responseEntity.setStatus(0);
            if (responseEntity.getContentAsString().length() == 0) {
                responseEntity.setStatus(1);
            }
            return responseEntity;
        }
        catch (Exception e) {
            responseEntity.setStatus(1);
            e.printStackTrace();
            return responseEntity;
        }
    }

    public static ResponseEntity postString(String url, String params, InternetConfig config) {
        config.setRequest_type(0);
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setUrl(url);
        try {
            HttpURLConnection conn = FastHttp.getDefaultHttpClient(url, config);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();
            OutputStream out = conn.getOutputStream();
            if (params != null && params.length() > 0) {
                out.write(params.getBytes(config.getCharset()));
            }
            out.flush();
            out.close();
            InputStream inStream = conn.getInputStream();
            cookies = conn.getHeaderField("set-cookie");
            if (config.isCookies() && cookies != null) {
                String[] cook;
                String[] stringArray = cook = cookies.split(";");
                int n = cook.length;
                int n2 = 0;
                while (n2 < n) {
                    String cook2 = stringArray[n2];
                    String[] cook3 = cook2.split("=");
                    if (cook3.length > 1) {
                        responseEntity.cookie(cook3[0], cook3[1]);
                    }
                    ++n2;
                }
            }
            responseEntity.setContent(FastHttp.inputStreamToString(inStream, config.getCharset()), config.isSave());
            conn.disconnect();
            responseEntity.setStatus(0);
            if (responseEntity.getContentAsString().length() == 0) {
                responseEntity.setStatus(1);
            }
            return responseEntity;
        }
        catch (Exception e) {
            responseEntity.setStatus(1);
            e.printStackTrace();
            return responseEntity;
        }
    }

    public static ResponseEntity form(String url) {
        return FastHttp.form(url, null, null, InternetConfig.defaultConfig());
    }

    public static ResponseEntity form(String url, LinkedHashMap<String, String> params) {
        return FastHttp.form(url, params, null, InternetConfig.defaultConfig());
    }

    public static ResponseEntity form(String url, LinkedHashMap<String, String> params, HashMap<String, File> files) {
        return FastHttp.form(url, params, files, InternetConfig.defaultConfig());
    }

    public static ResponseEntity form(String url, LinkedHashMap<String, String> params, HashMap<String, File> files, InternetConfig config) {
        params = params == null ? new LinkedHashMap<String, String>() : params;
        config.setRequest_type(4);
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setUrl(url);
        responseEntity.setParams(params);
        responseEntity.setKey(config.getKey());
        if (config.isSave() && !Handler_Network.isNetworkAvailable((Context)Ioc.getIoc().getApplication())) {
            Ioc.getIoc().getLogger().e("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc \u5c06\u83b7\u53d6\u79bb\u7ebf\u6570\u636e");
            String result = HttpCache.getUrlCache(url, params);
            if (result != null) {
                responseEntity.setContent(result, false);
                responseEntity.setStatus(0);
                return responseEntity;
            }
        }
        try {
            HttpURLConnection conn = FastHttp.getDefaultHttpClient(url, config);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                sb.append(PREFIX);
                sb.append(BOUNDARY);
                sb.append(LINEND);
                sb.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINEND);
                sb.append("Content-Type: text/plain; charset=" + config.getCharset() + LINEND);
                sb.append("Content-Transfer-Encoding: 8bit\r\n");
                sb.append(LINEND);
                sb.append(entry.getValue());
                sb.append(LINEND);
            }
            DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
            if (sb.length() > 0) {
                outStream.write(sb.toString().getBytes());
            }
            InputStream in = null;
            if (files != null) {
                for (Map.Entry<String, File> file : files.entrySet()) {
                    if (!file.getValue().exists()) continue;
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append(PREFIX);
                    sb1.append(BOUNDARY);
                    sb1.append(LINEND);
                    sb1.append("Content-Disposition: form-data; name=\"" + file.getKey() + "\"; filename=\"" + file.getValue().getName() + "\"" + LINEND);
                    sb1.append("Content-Type: image/pjpeg; \r\n");
                    sb1.append(LINEND);
                    outStream.write(sb1.toString().getBytes());
                    FileInputStream is = new FileInputStream(file.getValue());
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    int count = 0;
                    while ((len = ((InputStream)is).read(buffer)) != -1) {
                        outStream.write(buffer, 0, len);
                        count += len;
                    }
                    ((InputStream)is).close();
                    outStream.write(LINEND.getBytes());
                }
                byte[] end_data = (PREFIX + BOUNDARY + PREFIX + LINEND).getBytes();
                outStream.write(end_data);
                outStream.flush();
                in = conn.getInputStream();
                FastHttp.getCookies(config, responseEntity, conn);
                responseEntity.setContent(FastHttp.inputStreamToString(in, config.getCharset()), config.isSave());
                responseEntity.setKey(config.getKey());
                outStream.close();
                conn.disconnect();
                responseEntity.setStatus(0);
                if (responseEntity.getContentAsString().length() == 0) {
                    responseEntity.setStatus(1);
                }
            } else {
                InputStream inStream = conn.getInputStream();
                responseEntity.setContent(FastHttp.inputStreamToString(inStream, config.getCharset()), config.isSave());
                conn.disconnect();
                responseEntity.setStatus(0);
                if (responseEntity.getContentAsString().length() == 0) {
                    responseEntity.setStatus(1);
                }
            }
        }
        catch (Exception e) {
            responseEntity.setStatus(1);
            e.printStackTrace();
        }
        return responseEntity;
    }

    public static ResponseEntity formProgress(String url, LinkedHashMap<String, String> params, HashMap<String, File> files, InternetConfig config, Progress progress) {
        params = params == null ? new LinkedHashMap<String, String>() : params;
        config.setRequest_type(4);
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setUrl(url);
        responseEntity.setParams(params);
        responseEntity.setKey(config.getKey());
        if (config.isSave() && !Handler_Network.isNetworkAvailable((Context)Ioc.getIoc().getApplication())) {
            Ioc.getIoc().getLogger().e("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc \u5c06\u83b7\u53d6\u79bb\u7ebf\u6570\u636e");
            String result = HttpCache.getUrlCache(url, params);
            if (result != null) {
                responseEntity.setContent(result, false);
                responseEntity.setStatus(0);
                return responseEntity;
            }
        }
        try {
            long all_count = FastHttp.getOrtherLength(params, files, config);
            long read_count = 0L;
            config.setAll_length(all_count);
            HttpURLConnection conn = FastHttp.getDefaultHttpClient(url, config);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                sb.append(PREFIX);
                sb.append(BOUNDARY);
                sb.append(LINEND);
                sb.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINEND);
                sb.append("Content-Type: text/plain; charset=" + config.getCharset() + LINEND);
                sb.append("Content-Transfer-Encoding: 8bit\r\n");
                sb.append(LINEND);
                sb.append(entry.getValue());
                sb.append(LINEND);
            }
            BufferedOutputStream outStream = new BufferedOutputStream(conn.getOutputStream());
            if (sb.length() > 0) {
                outStream.write(sb.toString().getBytes());
                if (progress != null) {
                    progress.progress((int)((read_count += (long)sb.toString().getBytes().length) * 100L / all_count));
                }
            }
            InputStream in = null;
            if (files != null) {
                for (Map.Entry<String, File> file : files.entrySet()) {
                    if (!file.getValue().exists()) continue;
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append(PREFIX);
                    sb1.append(BOUNDARY);
                    sb1.append(LINEND);
                    sb1.append("Content-Disposition: form-data; name=\"" + file.getKey() + "\"; filename=\"" + file.getValue().getName() + "\"" + LINEND);
                    sb1.append("Content-Type: image/pjpeg; \r\n");
                    sb1.append(LINEND);
                    outStream.write(sb1.toString().getBytes());
                    if (progress != null) {
                        progress.progress((int)((read_count += (long)sb1.toString().getBytes().length) * 100L / all_count));
                    }
                    FileInputStream is = new FileInputStream(file.getValue());
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = ((InputStream)is).read(buffer)) != -1) {
                        outStream.write(buffer, 0, len);
                        read_count += (long)len;
                        if (progress == null) continue;
                        progress.progress((int)(read_count * 100L / all_count));
                    }
                    ((InputStream)is).close();
                    outStream.write(LINEND.getBytes());
                    if (progress == null) continue;
                    progress.progress((int)((read_count += (long)LINEND.getBytes().length) * 100L / all_count));
                }
                byte[] end_data = (PREFIX + BOUNDARY + PREFIX + LINEND).getBytes();
                outStream.write(end_data);
                outStream.flush();
                if (progress != null) {
                    progress.progress((int)((read_count += (long)end_data.length) * 100L / all_count));
                }
                in = conn.getInputStream();
                FastHttp.getCookies(config, responseEntity, conn);
                responseEntity.setContent(FastHttp.inputStreamToString(in, config.getCharset()), config.isSave());
                responseEntity.setKey(config.getKey());
                outStream.close();
                conn.disconnect();
                responseEntity.setStatus(0);
                if (responseEntity.getContentAsString().length() == 0) {
                    responseEntity.setStatus(1);
                }
            } else {
                InputStream inStream = conn.getInputStream();
                responseEntity.setContent(FastHttp.inputStreamToString(inStream, config.getCharset()), config.isSave());
                conn.disconnect();
                responseEntity.setStatus(0);
                if (responseEntity.getContentAsString().length() == 0) {
                    responseEntity.setStatus(1);
                }
            }
        }
        catch (Exception e) {
            responseEntity.setStatus(1);
            e.printStackTrace();
        }
        return responseEntity;
    }

    public static void ajaxForm(String url, AjaxCallBack callBack) {
        FastHttp.ajaxForm(url, null, null, InternetConfig.defaultConfig(), callBack);
    }

    public static void ajaxForm(String url, InternetConfig config, AjaxCallBack callBack) {
        FastHttp.ajaxForm(url, null, null, config, callBack);
    }

    public static void ajaxForm(String url, LinkedHashMap<String, String> params, AjaxCallBack callBack) {
        FastHttp.ajaxForm(url, params, null, InternetConfig.defaultConfig(), callBack);
    }

    public static void ajaxForm(String url, LinkedHashMap<String, String> params, HashMap<String, File> files, AjaxCallBack callBack) {
        FastHttp.ajaxForm(url, params, files, InternetConfig.defaultConfig(), callBack);
    }

    public static void ajaxForm(String url, LinkedHashMap<String, String> params, HashMap<String, File> files, InternetConfig config, AjaxCallBack callBack) {
        config.setRequest_type(4);
        config.setFiles(files);
        new Thread(new AjaxTask(url, params, config, callBack)).start();
    }

    public static void ajax(String url, AjaxCallBack callBack) {
        FastHttp.ajax(url, null, InternetConfig.defaultConfig(), callBack);
    }

    public static void ajax(String url, InternetConfig config, AjaxCallBack callBack) {
        FastHttp.ajax(url, null, config, callBack);
    }

    public static void ajax(String url, LinkedHashMap<String, String> params, AjaxCallBack callBack) {
        FastHttp.ajax(url, params, InternetConfig.defaultConfig(), callBack);
    }

    public static void ajax(String url, LinkedHashMap<String, String> params, InternetConfig config, AjaxCallBack callBack) {
        config.setRequest_type(0);
        new Thread(new AjaxTask(url, params, config, callBack)).start();
    }

    public static void ajax(String url, AjaxTimeCallBack callBack) {
        InternetConfig config = InternetConfig.defaultConfig();
        config.setRequest_type(0);
        FastHttp.ajax(url, null, config, callBack);
    }

    public static void ajax(String url, LinkedHashMap<String, String> params, AjaxTimeCallBack callBack) {
        InternetConfig config = InternetConfig.defaultConfig();
        config.setRequest_type(0);
        FastHttp.ajax(url, params, config, callBack);
    }

    public static void ajax(String url, LinkedHashMap<String, String> params, InternetConfig config, AjaxTimeCallBack callBack) {
        config.setRequest_type(0);
        new Thread(new TimeTask(url, params, config, callBack)).start();
    }

    public static ResponseEntity webServer(String url, String method) {
        return FastHttp.webServer(url, null, InternetConfig.defaultConfig(), method);
    }

    public static ResponseEntity webServer(String url, InternetConfig config, String method) {
        return FastHttp.webServer(url, null, config, method);
    }

    public static ResponseEntity webServer(String url, LinkedHashMap<String, String> params, String method) {
        return FastHttp.webServer(url, params, InternetConfig.defaultConfig(), method);
    }

    public static ResponseEntity webServer(String url, LinkedHashMap<String, String> params, InternetConfig config, String method) {
        config.setRequest_type(3);
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setUrl(url);
        responseEntity.setParams(params);
        responseEntity.setKey(config.getKey());
        if (config.isSave() && !Handler_Network.isNetworkAvailable((Context)Ioc.getIoc().getApplication())) {
            Ioc.getIoc().getLogger().e("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc \u5c06\u83b7\u53d6\u79bb\u7ebf\u6570\u636e");
            String result = HttpCache.getUrlCache(url, params);
            if (result != null) {
                responseEntity.setContent(result, false);
                responseEntity.setStatus(0);
                return responseEntity;
            }
        }
        try {
            config.setMethod(method);
            HttpURLConnection conn = FastHttp.getDefaultHttpClient(url, config);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();
            OutputStream out = conn.getOutputStream();
            String content = "";
            if (params == null) {
                params = new LinkedHashMap();
            }
            content = FastHttp.getXml(params, method, config.getName_space());
            content = content.replace(" standalone='yes' ", "");
            out.write(content.getBytes("UTF-8"));
            out.flush();
            out.close();
            InputStream inStream = conn.getInputStream();
            FastHttp.getCookies(config, responseEntity, conn);
            responseEntity.setContent(XMLtoJsonUtil.XMLtoJson(FastHttp.inputStreamToString(inStream, config.getCharset()), method, config.getCharset()), config.isSave());
            responseEntity.setKey(config.getKey());
            conn.disconnect();
            responseEntity.setStatus(0);
            if (responseEntity.getContentAsString().length() == 0) {
                responseEntity.setStatus(1);
            }
            return responseEntity;
        }
        catch (Exception e) {
            responseEntity.setStatus(1);
            e.printStackTrace();
            return responseEntity;
        }
    }

    public static void ajaxWebServer(String url, String method, AjaxCallBack callBack) {
        InternetConfig config = new InternetConfig();
        config.setMethod(method);
        config.setRequest_type(3);
        FastHttp.ajaxWebServer(url, method, null, config, callBack);
    }

    public static void ajaxWebServer(String url, String method, InternetConfig config, AjaxCallBack callBack) {
        FastHttp.ajaxWebServer(url, method, null, config, callBack);
    }

    public static void ajaxWebServer(String url, String method, LinkedHashMap<String, String> params, AjaxCallBack callBack) {
        InternetConfig config = InternetConfig.defaultConfig();
        config.setMethod(method);
        config.setRequest_type(3);
        FastHttp.ajaxWebServer(url, method, params, config, callBack);
    }

    public static void ajaxWebServer(String url, String method, LinkedHashMap<String, String> params, InternetConfig config, AjaxCallBack callBack) {
        if (config == null) {
            config = InternetConfig.defaultConfig();
        }
        config.setMethod(method);
        config.setRequest_type(3);
        new Thread(new AjaxTask(url, params, config, callBack)).start();
    }

    public static void ajaxWebServer(String url, String method, LinkedHashMap<String, String> params, AjaxTimeCallBack callBack) {
        InternetConfig config = InternetConfig.defaultConfig();
        config.setMethod(method);
        config.setRequest_type(3);
        new Thread(new TimeTask(url, params, config, callBack)).start();
    }

    public static void ajaxWebServer(String url, String method, LinkedHashMap<String, String> params, InternetConfig config, AjaxTimeCallBack callBack) {
        if (config == null) {
            config = InternetConfig.defaultConfig();
        }
        config.setMethod(method);
        config.setRequest_type(3);
        new Thread(new TimeTask(url, params, config, callBack)).start();
    }

    public static void ajaxGet(String url, AjaxCallBack callBack) {
        FastHttp.ajaxGet(url, null, InternetConfig.defaultConfig(), callBack);
    }

    public static void ajaxGet(String url, InternetConfig config, AjaxCallBack callBack) {
        FastHttp.ajaxGet(url, null, config, callBack);
    }

    public static void ajaxGet(String url, LinkedHashMap<String, String> params, AjaxCallBack callBack) {
        FastHttp.ajaxGet(url, params, InternetConfig.defaultConfig(), callBack);
    }

    public static void ajaxGet(String url, LinkedHashMap<String, String> params, InternetConfig config, AjaxCallBack callBack) {
        if (config == null) {
            config = InternetConfig.defaultConfig();
        }
        config.setRequest_type(1);
        new Thread(new AjaxTask(url, params, config, callBack)).start();
    }

    public static void ajaxGet(String url, LinkedHashMap<String, String> params, InternetConfig config, AjaxTimeCallBack callBack) {
        if (config == null) {
            config = InternetConfig.defaultConfig();
        }
        config.setRequest_type(1);
        new Thread(new TimeTask(url, params, config, callBack)).start();
    }

    private static HttpURLConnection getDefaultHttpClient(String urls, InternetConfig config) throws ProtocolException, MalformedURLException, IOException {
        if (config.isHttps()) {
            SSLContext sslContext = null;
            SSLSocketFactoryEx socketFactoryEx = null;
            try {
                socketFactoryEx = new SSLSocketFactoryEx(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sslContext = socketFactoryEx.sslContext;
            if (sslContext != null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            }
            HttpsURLConnection.setDefaultHostnameVerifier(hnv);
        }
        System.out.println(urls);
        URL url = new URL(urls);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (config.getFiles() != null) {
            conn.setFixedLengthStreamingMode((int)config.getAll_length());
        }
        conn.setConnectTimeout(config.getTimeout());
        String method = "POST";
        if (config.getRequest_type() == 1) {
            method = "GET";
            conn.setRequestMethod(method);
            conn.setRequestProperty("Charsert", config.getCharset());
            conn.setRequestProperty("Content-Type", config.getContent_type_web());
        } else if (config.getRequest_type() == 0) {
            method = "POST";
            conn.setRequestMethod(method);
            conn.setRequestProperty("Content-Type", config.getContent_type_web());
        } else if (config.getRequest_type() == 3) {
            method = "POST";
            conn.setRequestMethod(method);
            conn.setRequestProperty("Charsert", config.getCharset());
            conn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            conn.setRequestProperty("SOAPAction", String.valueOf(config.getName_space()) + config.getMethod());
            conn.setRequestProperty(METHOD, config.getMethod());
        } else if (config.getRequest_type() == 4) {
            method = "POST";
            conn.setRequestMethod(method);
            conn.setRequestProperty("connection", "keep-alive");
            conn.setRequestProperty("Charsert", config.getCharset());
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + BOUNDARY);
        }
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows XP; DigExt)");
        if (config.isCookies() && cookies != null) {
            conn.setRequestProperty("cookie", cookies);
        }
        if (config.getHead() != null) {
            HashMap<String, Object> head = config.getHead();
            for (String key : head.keySet()) {
                conn.setRequestProperty(key, head.get(key).toString());
            }
        }
        return conn;
    }

    public static String inputStreamToString(InputStream in, String charset) throws IOException {
        String s;
        StringBuffer out = new StringBuffer();
        BufferedReader input = new BufferedReader(new InputStreamReader(in, charset));
        while ((s = input.readLine()) != null) {
            out.append(s);
        }
        return out.toString();
    }

    private static String getXml(LinkedHashMap<String, String> data, String method, String name_space) {
        XmlSerializer serializer = Xml.newSerializer();
        StringWriter writer = new StringWriter();
        try {
            serializer.setOutput((Writer)writer);
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag("", "soap:Envelope");
            serializer.attribute("", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.attribute("", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            serializer.attribute("", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
            serializer.startTag("", "soap:Body");
            serializer.startTag("", method);
            serializer.attribute("", "xmlns", name_space);
            for (String key : data.keySet()) {
                serializer.startTag("", key);
                serializer.text(data.get(key).toString());
                serializer.endTag("", key);
            }
            serializer.endTag("", method);
            serializer.endTag("", "soap:Body");
            serializer.endTag("", "soap:Envelope");
            serializer.endDocument();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.getBuffer().toString();
    }

    private static void getCookies(InternetConfig config, ResponseEntity responseEntity, HttpURLConnection conn) {
        if (!config.isCookies()) {
            return;
        }
        Map<String, List<String>> resHeaders = conn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : resHeaders.entrySet()) {
            String name = entry.getKey();
            if (name == null || !name.equalsIgnoreCase("Set-Cookie")) continue;
            for (String cok : entry.getValue()) {
                String[] cook;
                String[] stringArray = cook = cok.split(";");
                int n = cook.length;
                int n2 = 0;
                while (n2 < n) {
                    String cook2 = stringArray[n2];
                    String[] cook3 = cook2.split("=");
                    if (cook3.length > 1) {
                        responseEntity.cookie(cook3[0], cook3[1]);
                    }
                    ++n2;
                }
            }
        }
    }

    private static int getOrtherLength(LinkedHashMap<String, String> params, HashMap<String, File> files, InternetConfig config) {
        long count = 0L;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(PREFIX);
            sb.append(BOUNDARY);
            sb.append(LINEND);
            sb.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINEND);
            sb.append("Content-Type: text/plain; charset=" + config.getCharset() + LINEND);
            sb.append("Content-Transfer-Encoding: 8bit\r\n");
            sb.append(LINEND);
            sb.append(entry.getValue());
            sb.append(LINEND);
        }
        count += (long)sb.toString().getBytes().length;
        if (files != null) {
            for (Map.Entry<String, Object> entry : files.entrySet()) {
                if (!((File)entry.getValue()).exists()) continue;
                count += ((File)entry.getValue()).length();
                StringBuilder sb1 = new StringBuilder();
                sb1.append(PREFIX);
                sb1.append(BOUNDARY);
                sb1.append(LINEND);
                sb1.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + ((File)entry.getValue()).getName() + "\"" + LINEND);
                sb1.append("Content-Type: image/pjpeg; \r\n");
                sb1.append(LINEND);
                count += (long)sb1.toString().getBytes().length;
                count += (long)LINEND.getBytes().length;
            }
            byte[] byArray = (PREFIX + BOUNDARY + PREFIX + LINEND).getBytes();
            count += (long)byArray.length;
        }
        return (int)count;
    }

    @SuppressLint(value={"HandlerLeak"})
    static class AjaxTask
    extends basicRunable
    implements Runnable {
        private AjaxCallBack mCallBack;
        private Handler mHandler = new Handler(){

            public void handleMessage(Message msg) {
                if (AjaxTask.this.mCallBack.stop()) {
                    return;
                }
                AjaxTask.this.mCallBack.callBack((ResponseEntity)msg.obj);
            }
        };

        public AjaxTask(String url, LinkedHashMap<String, String> params, InternetConfig internetConfig, AjaxCallBack callBack) {
            this.mCallBack = callBack;
            this.internetConfig = internetConfig;
            this.url = url;
            this.params = params;
        }

        @Override
        public void run() {
            Message msg = new Message();
            switch (this.internetConfig.getRequest_type()) {
                case 0: {
                    msg.obj = FastHttp.post(this.url, this.params, this.internetConfig);
                    break;
                }
                case 1: {
                    msg.obj = FastHttp.get(this.url, this.params, this.internetConfig);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    msg.obj = FastHttp.webServer(this.url, this.params, this.internetConfig, this.internetConfig.getMethod());
                    break;
                }
                case 4: {
                    msg.obj = FastHttp.formProgress(this.url, this.params, this.internetConfig.getFiles(), this.internetConfig, this.internetConfig.getProgress());
                    break;
                }
            }
            this.mHandler.sendMessage(msg);
        }
    }

    static class MyHostnameVerifier
    implements HostnameVerifier {
        MyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            Ioc.getIoc().getLogger().w("Warning: URL Host: " + hostname + " vs. " + session.getPeerHost());
            return true;
        }
    }

    public static interface Progress {
        public void progress(int var1);
    }

    @SuppressLint(value={"HandlerLeak"})
    static class TimeTask
    extends basicRunable
    implements Runnable {
        private AjaxTimeCallBack mCallBack;
        private Handler mHandler = new Handler(){

            public void handleMessage(Message msg) {
                TimeTask.this.mCallBack.callBack((ResponseEntity)msg.obj);
            }
        };

        public TimeTask(String url, LinkedHashMap<String, String> params, InternetConfig internetConfig, AjaxTimeCallBack callBack) {
            this.mCallBack = callBack;
            this.internetConfig = internetConfig;
            this.url = url;
            this.params = params;
        }

        @Override
        public void run() {
            while (this.mCallBack.getIsContinue()) {
                Message msg = new Message();
                switch (this.internetConfig.getRequest_type()) {
                    case 0: {
                        msg.obj = FastHttp.post(this.url, this.params, this.internetConfig);
                        break;
                    }
                    case 1: {
                        msg.obj = FastHttp.get(this.url, this.params, this.internetConfig);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        msg.obj = FastHttp.webServer(this.url, this.params, this.internetConfig, this.internetConfig.getMethod());
                        break;
                    }
                }
                this.mHandler.sendMessage(msg);
                try {
                    Thread.sleep(this.internetConfig.getTime());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static class basicRunable {
        InternetConfig internetConfig;
        String url;
        LinkedHashMap<String, String> params;

        basicRunable() {
        }
    }
}

