/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.internet;

import com.android.pc.ioc.internet.HttpCache;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResponseEntity
implements Serializable {
    private static final long serialVersionUID = 4691805279783501287L;
    private int status = -1;
    private String url;
    private String content;
    private Map<String, String> cookies;
    private Map<String, String> params;
    private int key;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public ResponseEntity setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getContentAsString() {
        return this.content;
    }

    public void setContent(String content, boolean isSave) {
        this.content = content;
        if (isSave) {
            for (String key : this.params.keySet()) {
                this.url = String.valueOf(this.url) + key + this.params.get(key);
            }
            HttpCache.setUrlCache(content, this.url);
        }
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public ResponseEntity setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
        return this;
    }

    public ResponseEntity cookie(String name, String value) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(name, value);
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String makeCookie() {
        if (this.cookies == null || this.cookies.size() == 0) {
            return null;
        }
        Iterator<String> iter = this.cookies.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = this.cookies.get(key);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            if (!iter.hasNext()) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    public String toString() {
        return "ResponseEntity [status=" + this.status + ", url=" + this.url + ", content=" + this.content + ", cookies=" + this.cookies + ", params=" + this.params + ", key=" + this.key + "]";
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }
}

