/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = ExceptionHandler.class.getSimpleName();
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private static ExceptionHandler INSTANCE;
    private Context context;
    private Map<String, String> infos = new HashMap<String, String>();
    private boolean isSave = false;
    private String filename;
    private String fileDirs;
    private Handler handler = null;
    private HashMap<String, String> exceptionBean;

    public static ExceptionHandler getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new ExceptionHandler(context);
        }
        return INSTANCE;
    }

    public void SetHandler(Handler handler) {
        this.handler = handler;
    }

    public void setSave(boolean isSave) {
        this.isSave = isSave;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFileDirs(String fileDirs) {
        this.fileDirs = fileDirs;
    }

    public ExceptionHandler(Context context) {
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.context = context;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        final String msg = this.collectDeviceInfo(this.context, ex);
        if (this.handler != null) {
            Message message = new Message();
            message.obj = msg;
            this.handler.sendMessage(message);
        }
        System.out.println("\u9519\u8bef\uff1a" + msg);
        if (this.isSave && this.filename != null && this.fileDirs != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.this.saveCrashInfoToFile(msg);
                }
            }).start();
        }
    }

    private String collectDeviceInfo(Context ctx, Throwable ex) {
        Field[] fields;
        this.exceptionBean = new HashMap();
        this.exceptionBean.put("projectName", ctx.getApplicationInfo().loadLabel(ctx.getPackageManager()).toString());
        try {
            PackageManager pm = ctx.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(ctx.getPackageName(), 1);
            if (pi != null) {
                String versionName = pi.versionName == null ? "null" : pi.versionName;
                String versionCode = String.valueOf(pi.versionCode);
                this.exceptionBean.put("versionName", versionName);
                this.exceptionBean.put("versionCode", versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException pm) {
            // empty catch block
        }
        Field[] fieldArray = fields = Build.class.getDeclaredFields();
        int versionCode = fields.length;
        int versionName = 0;
        while (versionName < versionCode) {
            Field field = fieldArray[versionName];
            try {
                field.setAccessible(true);
                this.infos.put(field.getName(), field.get(null).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++versionName;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.infos.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(String.valueOf(key) + "=" + value + "\n");
        }
        this.exceptionBean.put("devInfo", sb.toString());
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        Throwable cause = ex.getCause();
        while (cause != null) {
            cause.printStackTrace(printWriter);
            cause = cause.getCause();
        }
        printWriter.close();
        String result = ((Object)writer).toString();
        this.exceptionBean.put("exceptionMsg", result);
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String saveCrashInfoToFile(String msg) {
        String path;
        String fileName;
        block4: {
            try {
                long timestamp = System.currentTimeMillis();
                String time = this.formatter.format(new Date());
                fileName = String.valueOf(this.filename) + "-" + time + "-" + timestamp + ".log";
                if (!Environment.getExternalStorageState().equals("mounted")) return fileName;
                path = this.fileDirs;
                if (path.startsWith("/") && path.endsWith("/")) break block4;
                Log.e((String)TAG, (String)"the file path is err");
                return null;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"an error occured while writing file...", (Throwable)e);
                return null;
            }
        }
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(String.valueOf(path) + fileName);
        fos.write(msg.getBytes());
        fos.close();
        return fileName;
    }
}

