/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Handler_String {
    public static final int TYPE_NUMBER = 0;
    public static final int TYPE_ENGLISH = 1;
    public static final int TYPE_FUHAO = 2;
    public static final int TYPE_CHINA = 3;

    public static String addPrefix(int num, String prefix) {
        return num < 10 ? String.valueOf(prefix) + num : String.valueOf(num);
    }

    public static String addPrefix(String numStr, String prefix) {
        int num = Integer.parseInt(numStr);
        return Handler_String.addPrefix(num, prefix);
    }

    public static String addPrefixZero(int num) {
        return Handler_String.addPrefix(num, "0");
    }

    public static String addPrefixZero(String numStr) {
        return Handler_String.addPrefix(numStr, "0");
    }

    public static String addPrefixHtmlSpace(int num) {
        return Handler_String.addPrefix(num, "&nbsp;");
    }

    public static String addPrefixHtmlSpace(String numStr) {
        return Handler_String.addPrefix(numStr, "&nbsp;");
    }

    public static String commaInt(Object[] data, String symbol) {
        StringBuffer sbf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            sbf.append(data[i]);
            if (i < data.length - 1) {
                sbf.append(symbol);
            }
            ++i;
        }
        return sbf.toString();
    }

    public static String commaInt(Object[] data) {
        return Handler_String.commaInt(data, ",");
    }

    public static boolean isNull(String text) {
        return text == null || text.length() == 0;
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public static String prettyBytes(long value) {
        int i;
        String[] args = new String[]{"B", "KB", "MB", "GB", "TB"};
        StringBuilder sb = new StringBuilder();
        if (value < 1024L) {
            sb.append(String.valueOf(value));
            i = 0;
        } else if (value < 0x100000L) {
            sb.append(String.format("%.1f", (double)value / 1024.0));
            i = 1;
        } else if (value < 0x40000000L) {
            sb.append(String.format("%.2f", (double)value / 1048576.0));
            i = 2;
        } else if (value < 0x10000000000L) {
            sb.append(String.format("%.3f", (double)value / 1.073741824E9));
            i = 3;
        } else {
            sb.append(String.format("%.4f", (double)value / 1.099511627776E12));
            i = 4;
        }
        sb.append(' ');
        sb.append(args[i]);
        return sb.toString();
    }

    public static String repeat(String str, int times) {
        StringBuffer sbf = new StringBuffer();
        int i = 0;
        while (i < times) {
            sbf.append(str);
            ++i;
        }
        return sbf.toString();
    }

    public static int getLargestLengthInArray(String[] keys) {
        int length = 0;
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (key.length() > length) {
                length = key.length();
            }
            ++i;
        }
        return length;
    }

    public static String replaceAllByStringBuffer(String strSearch, String replacement, String body) {
        StringBuffer sbf = new StringBuffer(body);
        int index = 0;
        int offset = 0;
        do {
            if ((index = sbf.indexOf(strSearch, offset)) <= -1) continue;
            sbf.replace(index, index + strSearch.length(), replacement);
            offset = index + replacement.length();
        } while (index > -1);
        return sbf.toString();
    }

    public static int sepMarkNot(char c) {
        if (c > '/' && c < ':') {
            return 0;
        }
        if (c > '@' && c < '[') {
            return 1;
        }
        if (c > '`' && c < 'z') {
            return 1;
        }
        if (c >= '\u4e00' && c <= '\u9fbb') {
            return 3;
        }
        return 2;
    }

    public static int getLengths(String content) {
        int count = 0;
        int i = 0;
        while (i < content.length()) {
            count = Handler_String.sepMarkNot(content.charAt(i)) == 3 ? (count += 2) : ++count;
            ++i;
        }
        return count;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String nullStrToEmpty(String str) {
        return str == null ? "" : str;
    }

    public static String capitalizeFirstLetter(String str) {
        if (Handler_String.isEmpty(str)) {
            return str;
        }
        char c = str.charAt(0);
        return !Character.isLetter(c) || Character.isUpperCase(c) ? str : new StringBuilder(str.length()).append(Character.toUpperCase(c)).append(str.substring(1)).toString();
    }

    public static String utf8Encode(String str) {
        if (!Handler_String.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UnsupportedEncodingException occurred. ", e);
            }
        }
        return str;
    }

    public static String utf8Encode(String str, String defultReturn) {
        if (!Handler_String.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return defultReturn;
            }
        }
        return str;
    }

    public static String getHrefInnerHtml(String href) {
        if (Handler_String.isEmpty(href)) {
            return "";
        }
        String hrefReg = ".*<[\\s]*a[\\s]*.*>(.+?)<[\\s]*/a[\\s]*>.*";
        Pattern hrefPattern = Pattern.compile(hrefReg, 2);
        Matcher hrefMatcher = hrefPattern.matcher(href);
        if (hrefMatcher.matches()) {
            return hrefMatcher.group(1);
        }
        return href;
    }

    public static String htmlEscapeCharsToString(String source) {
        return Handler_String.isEmpty(source) ? source : source.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"");
    }

    public static String fullWidthToHalfWidth(String s) {
        if (Handler_String.isEmpty(s)) {
            return s;
        }
        char[] source = s.toCharArray();
        int i = 0;
        while (i < source.length) {
            source[i] = source[i] == '\u3000' ? 32 : (source[i] >= '\uff01' && source[i] <= '\uff5e' ? (char)(source[i] - 65248) : source[i]);
            ++i;
        }
        return new String(source);
    }

    public static String halfWidthToFullWidth(String s) {
        if (Handler_String.isEmpty(s)) {
            return s;
        }
        char[] source = s.toCharArray();
        int i = 0;
        while (i < source.length) {
            source[i] = source[i] == ' ' ? 12288 : (source[i] >= '!' && source[i] <= '~' ? (char)(source[i] + 65248) : source[i]);
            ++i;
        }
        return new String(source);
    }
}

