/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Vibrator;
import android.provider.Settings;
import android.telephony.NeighboringCellInfo;
import android.telephony.TelephonyManager;
import android.view.Display;
import android.view.WindowManager;
import com.android.pc.ioc.app.Ioc;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;

public class Handler_System {
    public static String UA = Build.MODEL;
    private static String mIMEI;
    private static String mSIM;
    private static String mMobileVersion;
    private static String mNetwrokIso;
    private static String mNetType;
    private static String mDeviceID;
    private static List<NeighboringCellInfo> mCellinfos;
    public static final String systemWidth = "width";
    public static final String systemHeight = "height";
    private static HashMap<String, Integer> map;
    public static final int DEFAULT_THREAD_POOL_SIZE;
    static TelephonyManager mTm;

    static {
        Handler_System.init();
        DEFAULT_THREAD_POOL_SIZE = Handler_System.getDefaultThreadPoolSize();
        mTm = null;
    }

    public static String getAppName() {
        return Handler_System.getAppName(null);
    }

    public static String getAppName(String packageName) {
        String applicationName;
        if (packageName == null) {
            packageName = Ioc.getIoc().getApplication().getPackageName();
        }
        try {
            PackageManager packageManager = Ioc.getIoc().getApplication().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            applicationName = Ioc.getIoc().getApplication().getString(packageInfo.applicationInfo.labelRes);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
            applicationName = "";
        }
        return applicationName;
    }

    public static String getAppVersionNumber() {
        return Handler_System.getAppVersionNumber(null);
    }

    public static String getAppVersionNumber(String packageName) {
        String versionName;
        if (packageName == null) {
            packageName = Ioc.getIoc().getApplication().getPackageName();
        }
        try {
            PackageManager packageManager = Ioc.getIoc().getApplication().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            versionName = packageInfo.versionName;
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
            versionName = "";
        }
        return versionName;
    }

    public static String getAppVersionCode() {
        return Handler_System.getAppVersionCode(null);
    }

    public static String getAppVersionCode(String packageName) {
        String versionCode;
        if (packageName == null) {
            packageName = Ioc.getIoc().getApplication().getPackageName();
        }
        try {
            PackageManager packageManager = Ioc.getIoc().getApplication().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            versionCode = Integer.toString(packageInfo.versionCode);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
            versionCode = "";
        }
        return versionCode;
    }

    public static int getSdkVersion() {
        try {
            return Build.VERSION.class.getField("SDK_INT").getInt(null);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
            return 3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRelease(String signatureString) {
        String releaseSignatureString = signatureString;
        if (releaseSignatureString == null) throw new RuntimeException("Release signature string is null or missing.");
        if (releaseSignatureString.length() == 0) {
            throw new RuntimeException("Release signature string is null or missing.");
        }
        Signature releaseSignature = new Signature(releaseSignatureString);
        try {
            PackageManager pm = Ioc.getIoc().getApplication().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(Ioc.getIoc().getApplication().getPackageName(), 64);
            Signature[] signatureArray = pi.signatures;
            int n = pi.signatures.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Signature sig = signatureArray[n2];
                if (sig.equals((Object)releaseSignature)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
            return true;
        }
    }

    public static boolean isEmulator() {
        return Build.MODEL.equals("sdk") || Build.MODEL.equals("google_sdk");
    }

    public static String getMobileInfo() {
        StringBuffer sb = new StringBuffer();
        try {
            Field[] fields;
            Field[] fieldArray = fields = Build.class.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.setAccessible(true);
                String name = field.getName();
                String value = field.get(null).toString();
                sb.append(String.valueOf(name) + "=" + value);
                sb.append("\n");
                ++n2;
            }
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
        }
        return sb.toString();
    }

    public static HashMap<String, Integer> getDisplayMetrics() {
        if (map == null) {
            map = new HashMap();
            Display display = ((WindowManager)Ioc.getIoc().getApplication().getSystemService("window")).getDefaultDisplay();
            int screenWidth = display.getWidth();
            int screenHeight = display.getHeight();
            map.put(systemWidth, screenWidth);
            map.put(systemHeight, screenHeight);
        }
        return map;
    }

    public static float getWidthRoate() {
        if (map == null) {
            map = new HashMap();
            Display display = ((WindowManager)Ioc.getIoc().getApplication().getSystemService("window")).getDefaultDisplay();
            int screenWidth = display.getWidth();
            int screenHeight = display.getHeight();
            map.put(systemWidth, screenWidth);
            map.put(systemHeight, screenHeight);
        }
        return (float)map.get(systemWidth).intValue() * 1.0f / (float)Ioc.getIoc().getMode_w();
    }

    public static float getRoate() {
        float h;
        float w;
        if (map == null) {
            map = new HashMap();
            Display display = ((WindowManager)Ioc.getIoc().getApplication().getSystemService("window")).getDefaultDisplay();
            int screenWidth = display.getWidth();
            int screenHeight = display.getHeight();
            map.put(systemWidth, screenWidth);
            map.put(systemHeight, screenHeight);
        }
        return (w = (float)map.get(systemWidth).intValue() * 1.0f / (float)Ioc.getIoc().getMode_w()) > (h = (float)map.get(systemHeight).intValue() * 1.0f / (float)Ioc.getIoc().getMode_h()) ? w : h;
    }

    public static float getPadRoate() {
        float h;
        float w;
        if (map == null) {
            map = new HashMap();
            Display display = ((WindowManager)Ioc.getIoc().getApplication().getSystemService("window")).getDefaultDisplay();
            int screenWidth = display.getWidth();
            int screenHeight = display.getHeight();
            map.put(systemWidth, screenWidth);
            map.put(systemHeight, screenHeight);
        }
        return (w = (float)map.get(systemWidth).intValue() * 1.0f / (float)Ioc.getIoc().getMode_w()) < (h = (float)map.get(systemHeight).intValue() * 1.0f / (float)Ioc.getIoc().getMode_h()) ? w : h;
    }

    public static float getHeightRoate() {
        if (map == null) {
            map = new HashMap();
            Display display = ((WindowManager)Ioc.getIoc().getApplication().getSystemService("window")).getDefaultDisplay();
            int screenWidth = display.getWidth();
            int screenHeight = display.getHeight();
            map.put(systemWidth, screenWidth);
            map.put(systemHeight, screenHeight);
        }
        return (float)map.get(systemHeight).intValue() * 1.0f / (float)Ioc.getIoc().getMode_h();
    }

    public static int dip2px(float dipValue) {
        float scale = Ioc.getIoc().getApplication().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int px2dip(float pxValue) {
        float scale = Ioc.getIoc().getApplication().getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int getBarHeight() {
        Class<?> c = null;
        Object obj = null;
        Field field = null;
        int x = 0;
        int sbar = 0;
        try {
            c = Class.forName("com.android.internal.R$dimen");
            obj = c.newInstance();
            field = c.getField("status_bar_height");
            x = Integer.parseInt(field.get(obj).toString());
            sbar = Ioc.getIoc().getApplication().getResources().getDimensionPixelSize(x);
        }
        catch (Exception e1) {
            Ioc.getIoc().getLogger().e(e1);
        }
        return sbar;
    }

    public static boolean hasFroyo() {
        return Build.VERSION.SDK_INT >= 8;
    }

    public static boolean hasGingerbread() {
        return Build.VERSION.SDK_INT >= 9;
    }

    public static boolean hasGingerbreadMR1() {
        return Build.VERSION.SDK_INT >= 10;
    }

    public static boolean hasHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static boolean hasHoneycombMR1() {
        return Build.VERSION.SDK_INT >= 12;
    }

    public static boolean hasICS() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static boolean hasJellyBean() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean hasJellyBeanMR1() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean isHoneycombTablet(Context context) {
        return Handler_System.hasHoneycomb() && Handler_System.isTablet(context);
    }

    public static boolean isGingerbread() {
        return Build.VERSION.SDK_INT >= 9 && Build.VERSION.SDK_INT <= 10;
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    public static int getDefaultThreadPoolSize() {
        return Handler_System.getDefaultThreadPoolSize(8);
    }

    public static int getDefaultThreadPoolSize(int max) {
        int availableProcessors = 2 * Runtime.getRuntime().availableProcessors() + 1;
        return availableProcessors > max ? max : availableProcessors;
    }

    public static void Vibrate(long milliseconds) {
        Vibrator vib = (Vibrator)Ioc.getIoc().getApplication().getSystemService("vibrator");
        vib.vibrate(milliseconds);
    }

    public static void init() {
        mTm = (TelephonyManager)Ioc.getIoc().getApplication().getSystemService("phone");
        mIMEI = mTm.getDeviceId();
        mMobileVersion = mTm.getDeviceSoftwareVersion();
        mCellinfos = mTm.getNeighboringCellInfo();
        mNetwrokIso = mTm.getNetworkCountryIso();
        mSIM = mTm.getSimSerialNumber();
        mDeviceID = Handler_System.getDeviceId();
        try {
            ConnectivityManager cm = (ConnectivityManager)Ioc.getIoc().getApplication().getSystemService("connectivity");
            NetworkInfo info = cm.getActiveNetworkInfo();
            if (info != null) {
                mNetType = info.getTypeName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getDeviceId(Context mCm) {
        return Settings.Secure.getString((ContentResolver)mCm.getContentResolver(), (String)"android_id");
    }

    private static String getDeviceId() {
        return Settings.Secure.getString((ContentResolver)Ioc.getIoc().getApplication().getContentResolver(), (String)"android_id");
    }

    public static String getImei() {
        return mIMEI;
    }

    public static String getSIM() {
        return mSIM;
    }

    public static String getUA() {
        return UA;
    }

    public static String getDeviceInfo() {
        StringBuffer info = new StringBuffer();
        info.append("IMEI:").append(Handler_System.getImei());
        info.append("\n");
        info.append("SIM:").append(Handler_System.getSIM());
        info.append("\n");
        info.append("UA:").append(Handler_System.getUA());
        info.append("\n");
        info.append("MobileVersion:").append(mMobileVersion);
        info.append("\n");
        info.append("SDK: ").append(Build.VERSION.SDK);
        info.append("\n");
        info.append(Handler_System.getCallState());
        info.append("\n");
        info.append("SIM_STATE: ").append(Handler_System.getSimState());
        info.append("\n");
        info.append("SIM: ").append(Handler_System.getSIM());
        info.append("\n");
        info.append(Handler_System.getSimOpertorName());
        info.append("\n");
        info.append(Handler_System.getPhoneType());
        info.append("\n");
        info.append(Handler_System.getPhoneSettings());
        info.append("\n");
        return info.toString();
    }

    public static String getSimState() {
        switch (mTm.getSimState()) {
            case 0: {
                return "\u672a\u77e5SIM\u72b6\u6001_0";
            }
            case 1: {
                return "\u6ca1\u63d2SIM\u5361_1";
            }
            case 2: {
                return "\u9501\u5b9aSIM\u72b6\u6001_\u9700\u8981\u7528\u6237\u7684PIN\u7801\u89e3\u9501_2";
            }
            case 3: {
                return "\u9501\u5b9aSIM\u72b6\u6001_\u9700\u8981\u7528\u6237\u7684PUK\u7801\u89e3\u9501_3";
            }
            case 4: {
                return "\u9501\u5b9aSIM\u72b6\u6001_\u9700\u8981\u7f51\u7edc\u7684PIN\u7801\u89e3\u9501_4";
            }
            case 5: {
                return "\u5c31\u7eeaSIM\u72b6\u6001_5";
            }
        }
        return "\u672a\u77e5SIM\u72b6\u6001_0";
    }

    public static String getPhoneType() {
        switch (mTm.getPhoneType()) {
            case 0: {
                return "PhoneType: \u65e0\u4fe1\u53f7_0";
            }
            case 1: {
                return "PhoneType: GSM\u4fe1\u53f7_1";
            }
            case 2: {
                return "PhoneType: CDMA\u4fe1\u53f7_2";
            }
        }
        return "PhoneType: \u65e0\u4fe1\u53f7_0";
    }

    public static String getSimOpertorName() {
        if (mTm.getSimState() == 5) {
            StringBuffer sb = new StringBuffer();
            sb.append("SimOperatorName: ").append(mTm.getSimOperatorName());
            sb.append("\n");
            sb.append("SimOperator: ").append(mTm.getSimOperator());
            sb.append("\n");
            sb.append("Phone:").append(mTm.getLine1Number());
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SimOperatorName: ").append("\u672a\u77e5");
        sb.append("\n");
        sb.append("SimOperator: ").append("\u672a\u77e5");
        return sb.toString();
    }

    public static String getPhoneSettings() {
        StringBuffer buf = new StringBuffer();
        String str = Settings.Secure.getString((ContentResolver)Ioc.getIoc().getApplication().getContentResolver(), (String)"bluetooth_on");
        buf.append("\u84dd\u7259:");
        if (str.equals("0")) {
            buf.append("\u7981\u7528");
        } else {
            buf.append("\u5f00\u542f");
        }
        str = Settings.Secure.getString((ContentResolver)Ioc.getIoc().getApplication().getContentResolver(), (String)"bluetooth_on");
        buf.append("WIFI:");
        buf.append(str);
        str = Settings.Secure.getString((ContentResolver)Ioc.getIoc().getApplication().getContentResolver(), (String)"install_non_market_apps");
        buf.append("APP\u4f4d\u7f6e\u6765\u6e90:");
        buf.append(str);
        return buf.toString();
    }

    public static String getCallState() {
        switch (mTm.getCallState()) {
            case 0: {
                return "\u7535\u8bdd\u72b6\u6001[CallState]: \u65e0\u6d3b\u52a8";
            }
            case 2: {
                return "\u7535\u8bdd\u72b6\u6001[CallState]: \u65e0\u6d3b\u52a8";
            }
            case 1: {
                return "\u7535\u8bdd\u72b6\u6001[CallState]: \u65e0\u6d3b\u52a8";
            }
        }
        return "\u7535\u8bdd\u72b6\u6001[CallState]: \u672a\u77e5";
    }

    public static String getNetwrokIso() {
        return mNetwrokIso;
    }

    public String getmDeviceID() {
        return mDeviceID;
    }

    public String getNetType() {
        return mNetType;
    }
}

