/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import com.android.pc.util.Handler_String;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class Handler_Time {
    private Calendar cal = Calendar.getInstance();

    private Handler_Time() {
    }

    public static Handler_Time getInstance() {
        return new Handler_Time();
    }

    public static Handler_Time getInstance(String year, String month) {
        Handler_Time th = new Handler_Time();
        if (!(year == null || year.equals("") || year.equals("null") || month == null || month.equals("") || month.equals("null"))) {
            th.cal.set(1, Integer.parseInt(year));
            th.cal.set(2, Integer.parseInt(month) - 1);
        }
        return th;
    }

    public static Handler_Time getInstance(String year, String month, String day) {
        Handler_Time th = new Handler_Time();
        if (!(year == null || year.equals("") || year.equals("null") || month == null || month.equals("") || month.equals("null") || day == null || day.equals("") || day.equals("null"))) {
            th.cal.set(1, Integer.parseInt(year));
            th.cal.set(2, Integer.parseInt(month) - 1);
            th.cal.set(5, Integer.parseInt(day));
        }
        return th;
    }

    public static Handler_Time getInstance(int year, int month, int day) {
        Handler_Time th = new Handler_Time();
        th.cal.set(1, year);
        th.cal.set(2, month - 1);
        th.cal.set(5, day);
        return th;
    }

    public static Handler_Time getInstance(String date_time) {
        int stringLength = date_time.length();
        if (stringLength < 4) {
            return null;
        }
        Handler_Time th = new Handler_Time();
        int year = Integer.parseInt(date_time.substring(0, 4));
        int month = 0;
        int day = 1;
        if (stringLength >= 7) {
            month = Integer.parseInt(date_time.substring(5, 7)) - 1;
        }
        if (stringLength >= 10) {
            day = Integer.parseInt(date_time.substring(8, 10));
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (stringLength >= 13) {
            hour = Integer.parseInt(date_time.substring(11, 13));
        }
        if (stringLength >= 16) {
            minute = Integer.parseInt(date_time.substring(14, 16));
        }
        if (stringLength == 19) {
            second = Integer.parseInt(date_time.substring(17, 19));
        }
        th.set(year, month, day, hour, minute, second);
        return th;
    }

    public static Handler_Time getInstance(long timeInMillis) {
        Handler_Time th = new Handler_Time();
        th.set(timeInMillis);
        return th;
    }

    public Timestamp getTimestamp() {
        return new Timestamp(this.cal.getTimeInMillis());
    }

    public String getTimestampStr() {
        String str = new Timestamp(this.cal.getTimeInMillis()).toString();
        while (str.length() < 23) {
            str = String.valueOf(str) + 0;
        }
        return str;
    }

    public String getTimestampSecond() {
        String str = new Timestamp(this.cal.getTimeInMillis()).toString();
        return str.substring(0, 19);
    }

    public Timestamp getTimestampPlus(long timeInMillis) {
        return new Timestamp(this.cal.getTimeInMillis() + timeInMillis);
    }

    public Timestamp getTimestamp(int year, int month, int day, int hour, int minute) {
        this.cal.set(year, month, day, hour, minute, 0);
        return new Timestamp(this.cal.getTimeInMillis());
    }

    public int getYear() {
        return this.cal.get(1);
    }

    public int getYearSimple() {
        int year = this.cal.get(1);
        int yearSimple = year > 2000 ? year - 2000 : (year > 1900 ? year - 1900 : (year > 1800 ? year - 1800 : year - 1700));
        return yearSimple;
    }

    public String getYearSimpleStr() {
        int year = this.getYearSimple();
        return Handler_String.addPrefixZero(year);
    }

    public int getYearPrev() {
        if (this.getMonth() == 1) {
            return this.getYear() - 1;
        }
        return this.getYear();
    }

    public int getYearNext() {
        if (this.getMonth() == 12) {
            return this.getYear() + 1;
        }
        return this.getYear();
    }

    public String getYearStr() {
        return String.valueOf(this.getYear());
    }

    public int getMonth() {
        return this.cal.get(2) + 1;
    }

    public int getMonthPrev() {
        if (this.getMonth() == 1) {
            return 12;
        }
        return this.getMonth() - 1;
    }

    public int getMonthNext() {
        if (this.getMonth() == 12) {
            return 1;
        }
        return this.getMonth() + 1;
    }

    public String getMonthStr() {
        return Handler_String.addPrefixZero(this.getMonth());
    }

    public int getDay() {
        return this.cal.get(5);
    }

    public String getDayStr() {
        return Handler_String.addPrefixZero(this.getDay());
    }

    public int getHour() {
        return this.cal.get(11);
    }

    public String getHourStr() {
        return Handler_String.addPrefixZero(this.getHour());
    }

    public int getMinute() {
        return this.cal.get(12);
    }

    public String getMinuteStr() {
        return Handler_String.addPrefixZero(this.getMinute());
    }

    public int getSecond() {
        return this.cal.get(13);
    }

    public String getSecondStr() {
        return Handler_String.addPrefixZero(this.getSecond());
    }

    public String getYYYYMMDD() {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.getYearStr());
        sbf.append("-");
        sbf.append(this.getMonthStr());
        sbf.append("-");
        sbf.append(this.getDayStr());
        return sbf.toString();
    }

    public String getYYYYMMDDLabel() {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.getYearStr()).append("\u5e74");
        sbf.append(this.getMonthStr()).append("\u6708");
        sbf.append(this.getDayStr()).append("\u65e5");
        return sbf.toString();
    }

    public String getYYYYMMDDPrevious() {
        Handler_Time previousDay = this.getTimeHandlerPrevious();
        return previousDay.getYYYYMMDD();
    }

    public String getYYYYMMDDNext() {
        Handler_Time nextDay = this.getTimeHandlerNext();
        return nextDay.getYYYYMMDD();
    }

    public Handler_Time getTimeHandlerPrevious() {
        long todayTimeInMillis = this.getTimeInMillis();
        Handler_Time previousDay = Handler_Time.getInstance(todayTimeInMillis - 86400000L);
        return previousDay;
    }

    public Handler_Time getTimeHandlerNext() {
        long todayTimeInMillis = this.getTimeInMillis();
        Handler_Time nextDay = Handler_Time.getInstance(todayTimeInMillis + 86400000L);
        return nextDay;
    }

    public String getYYYYMM() {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.getYearStr());
        sbf.append("-");
        sbf.append(this.getMonthStr());
        return sbf.toString();
    }

    public String getYYYYMMLabel() {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.getYearStr()).append("\u5e74");
        sbf.append(this.getMonthStr()).append("\u6708");
        return sbf.toString();
    }

    public String getYYYYMMPrevious() {
        int year = this.getYear();
        int previousMonth = this.getMonthPrev();
        if (previousMonth == 12) {
            --year;
        }
        StringBuffer sbf = new StringBuffer();
        sbf.append(year).append("-").append(Handler_String.addPrefixZero(previousMonth));
        return sbf.toString();
    }

    public String getYYYYMMNext() {
        int year = this.getYear();
        int nextMonth = this.getMonthNext();
        if (nextMonth == 1) {
            ++year;
        }
        StringBuffer sbf = new StringBuffer();
        sbf.append(year).append("-").append(Handler_String.addPrefixZero(nextMonth));
        return sbf.toString();
    }

    public String getYyyyMmKanji() {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.getYearStr());
        sbf.append(" \u5e74 ");
        sbf.append(this.getMonth());
        sbf.append(" \u6708 ");
        return sbf.toString();
    }

    public void set(int year, int month, int day, int hour, int minute, int second) {
        this.cal.set(year, month, day, hour, minute, second);
    }

    public void set(int year, int month, int day, int hour, int minute) {
        this.cal.set(year, month, day, hour, minute, 0);
    }

    public void set(int field, int value) {
        this.cal.set(field, value);
    }

    public void set(long timeInMillis) {
        this.cal.setTimeInMillis(timeInMillis);
    }

    public long getTimeInMillis() {
        return this.cal.getTimeInMillis();
    }

    public int getTimeInSeconds() {
        return (int)(this.getTimeInMillis() / 1000L);
    }

    public boolean checkDate(int year, int month, int day) {
        this.cal.set(year, month, 1);
        return day > this.cal.getActualMaximum(5);
    }

    public int getMaxDayOfTheMonth() {
        return this.cal.getActualMaximum(5);
    }

    public int getDayOfTheWeek() {
        return this.cal.get(7);
    }

    public Date getDate() {
        return new Date(this.getTimeInMillis());
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public static String now() {
        return Handler_Time.getInstance().getTimestamp().toString().substring(0, 19);
    }

    public String getPeriodStr(long timeInMillis) {
        long result = 0L;
        StringBuffer sbf = new StringBuffer();
        result = timeInMillis / 1000L / 3600L;
        if (result > 0L) {
            sbf.append(Handler_String.addPrefixZero((int)result)).append(":");
            timeInMillis -= result * 3600L * 1000L;
        } else {
            sbf.append("00:");
        }
        result = timeInMillis / 1000L / 60L;
        if (result > 0L) {
            sbf.append(Handler_String.addPrefixZero((int)result)).append(":");
            timeInMillis -= result * 60L * 1000L;
        } else {
            sbf.append("00:");
        }
        result = timeInMillis / 1000L;
        sbf.append(Handler_String.addPrefixZero((int)result));
        return sbf.toString();
    }

    public static Handler_Time linuxTimeToWinTime(Handler_Time timeHandler) {
        int year = timeHandler.getYear();
        int month = timeHandler.getMonth();
        int day = timeHandler.getDay();
        int hour = timeHandler.getHour();
        int minute = timeHandler.getMinute();
        int second = timeHandler.getSecond();
        timeHandler.set(year, month - 1, day, hour += 8, minute, second);
        return timeHandler;
    }

    public String toString() {
        return this.getTimestampStr();
    }

    public static String formatDate(int year, int month, int day) {
        StringBuffer sbf = new StringBuffer();
        sbf.append(year);
        sbf.append("-");
        sbf.append(Handler_String.addPrefixZero(month + 1));
        sbf.append("-");
        sbf.append(Handler_String.addPrefixZero(day));
        return sbf.toString();
    }

    public static String formatDuring(long mss) {
        long days = mss / 86400000L;
        long hours = mss % 86400000L / 3600000L;
        long minutes = mss % 3600000L / 60000L;
        long seconds = mss % 60000L / 1000L;
        return String.valueOf(days) + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206" + seconds + "\u79d2";
    }
}

