/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import android.util.Log;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.core.kernel.KernelClass;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class Logger {
    private static boolean debug = false;
    public static String tag = "Inject_android";
    private static final int logLevel = 2;
    private static Hashtable<String, Logger> logger = new Hashtable();
    private String name;

    private Logger(String name) {
        this.name = name;
        Class clazz = KernelClass.forName(String.valueOf(Ioc.getIoc().getApplication().getPackageName()) + "." + "BuildConfig");
        if (clazz == null) {
            debug = false;
            return;
        }
        try {
            Field filed = clazz.getDeclaredField("DEBUG");
            debug = Boolean.valueOf(filed.get(null).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Logger getLogger(String name) {
        Logger classLogger = logger.get(name);
        if (classLogger == null) {
            classLogger = new Logger(name);
            logger.put(name, classLogger);
        }
        return classLogger;
    }

    private String getFunctionName() {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts == null) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray = sts;
        int n = sts.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement st = stackTraceElementArray[n2];
            if (!(st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(this.getClass().getName()))) {
                return String.valueOf(this.name) + "[ " + Thread.currentThread().getName() + ": " + st.getFileName() + ":" + st.getLineNumber() + " " + st.getMethodName() + " ]";
            }
            ++n2;
        }
        return null;
    }

    public static boolean isDebug() {
        return debug;
    }

    public void i(Object str) {
        if (debug) {
            String name = this.getFunctionName();
            if (name != null) {
                Log.i((String)tag, (String)(String.valueOf(name) + "\n" + str + "\n------------------------------------------------------------------------------"));
            } else {
                Log.i((String)tag, (String)str.toString());
            }
        }
    }

    public void s(Object str) {
        if (debug) {
            String name = this.getFunctionName();
            if (name != null) {
                System.out.println(String.valueOf(name) + "\n" + str + "\n------------------------------------------------------------------------------");
            } else {
                System.out.println(str.toString());
            }
        }
    }

    public void d(Object str) {
        if (debug) {
            String name = this.getFunctionName();
            if (name != null) {
                Log.d((String)tag, (String)(String.valueOf(name) + "\n" + str + "\n------------------------------------------------------------------------------"));
            } else {
                Log.d((String)tag, (String)str.toString());
            }
        }
    }

    public void v(Object str) {
        if (debug) {
            String name = this.getFunctionName();
            if (name != null) {
                Log.v((String)tag, (String)(String.valueOf(name) + "\n" + str + "\n------------------------------------------------------------------------------"));
            } else {
                Log.v((String)tag, (String)str.toString());
            }
        }
    }

    public void w(Object str) {
        if (debug) {
            String name = this.getFunctionName();
            if (name != null) {
                Log.w((String)tag, (String)(String.valueOf(name) + "\n" + str + "\n------------------------------------------------------------------------------"));
            } else {
                Log.w((String)tag, (String)str.toString());
            }
        }
    }

    public void e(Object str) {
        if (debug) {
            String name = this.getFunctionName();
            if (name != null) {
                Log.e((String)tag, (String)(String.valueOf(name) + "\n" + str + "\n------------------------------------------------------------------------------"));
            } else {
                Log.e((String)tag, (String)str.toString());
            }
        }
    }

    public void e(Exception ex) {
        if (debug) {
            Log.e((String)tag, (String)"error", (Throwable)ex);
        }
    }

    public void e(String log, Throwable tr) {
        if (debug) {
            String line = this.getFunctionName();
            Log.e((String)tag, (String)("{Thread:" + Thread.currentThread().getName() + "}" + "[" + this.name + line + ":] " + log + "\n"), (Throwable)tr);
        }
    }
}

