/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.ksoap2.HeaderProperty;
import org.ksoap2.transport.ServiceConnection;

public class HttpsServiceConnectionSE
implements ServiceConnection {
    private HttpsURLConnection connection;

    public HttpsServiceConnectionSE(String host, int port, String file, int timeout) throws IOException {
        this(null, host, port, file, timeout);
    }

    public HttpsServiceConnectionSE(Proxy proxy, String host, int port, String file, int timeout) throws IOException {
        this.connection = proxy == null ? (HttpsURLConnection)new URL("https", host, port, file).openConnection() : (HttpsURLConnection)new URL("https", host, port, file).openConnection(proxy);
        this.connection = (HttpsURLConnection)new URL("https", host, port, file).openConnection();
        this.updateConnectionParameters(timeout);
    }

    private void updateConnectionParameters(int timeout) {
        this.connection.setConnectTimeout(timeout);
        this.connection.setReadTimeout(timeout);
        this.connection.setUseCaches(false);
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
    }

    public void connect() throws IOException {
        this.connection.connect();
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public List getResponseProperties() {
        Map<String, List<String>> properties = this.connection.getHeaderFields();
        Set<String> keys = properties.keySet();
        LinkedList<HeaderProperty> retList = new LinkedList<HeaderProperty>();
        Iterator<String> i = keys.iterator();
        while (i.hasNext()) {
            String key = i.next();
            List<String> values = properties.get(key);
            for (int j = 0; j < values.size(); ++j) {
                retList.add(new HeaderProperty(key, values.get(j)));
            }
        }
        return retList;
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public void setRequestProperty(String key, String value) {
        this.connection.setRequestProperty(key, value);
    }

    public void setRequestMethod(String requestMethod) throws IOException {
        this.connection.setRequestMethod(requestMethod);
    }

    public void setFixedLengthStreamingMode(int contentLength) {
        this.connection.setFixedLengthStreamingMode(contentLength);
    }

    public OutputStream openOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public InputStream openInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.connection.getErrorStream();
    }

    public String getHost() {
        return this.connection.getURL().getHost();
    }

    public int getPort() {
        return this.connection.getURL().getPort();
    }

    public String getPath() {
        return this.connection.getURL().getPath();
    }

    public void setSSLSocketFactory(SSLSocketFactory sf) {
        this.connection.setSSLSocketFactory(sf);
    }
}

