/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.Entry;

public class BarEntry
extends Entry {
    private float[] mVals;

    public BarEntry(float[] vals, int xIndex) {
        super(BarEntry.calcSum(vals), xIndex);
        this.mVals = vals;
    }

    public BarEntry(float val, int xIndex) {
        super(val, xIndex);
    }

    public BarEntry(float[] vals, int xIndex, String label) {
        super(BarEntry.calcSum(vals), xIndex, label);
        this.mVals = vals;
    }

    public BarEntry(float val, int xIndex, Object data) {
        super(val, xIndex, data);
    }

    @Override
    public BarEntry copy() {
        BarEntry copied = new BarEntry(this.getVal(), this.getXIndex(), this.getData());
        copied.mVals = this.mVals;
        return copied;
    }

    public float[] getVals() {
        return this.mVals;
    }

    public void setVals(float[] vals) {
        this.mVals = vals;
    }

    public int getClosestIndexAbove(float val) {
        if (this.mVals == null) {
            return 0;
        }
        float dist = 0.0f;
        int closestIndex = 0;
        int i = 0;
        while (i < this.mVals.length) {
            float newDist = Math.abs(this.getVal() - this.mVals[i] - val);
            if (newDist < dist && this.mVals[i] > val) {
                dist = newDist;
                closestIndex = i;
            }
            ++i;
        }
        return closestIndex;
    }

    private static float calcSum(float[] vals) {
        float sum = 0.0f;
        float[] fArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            sum += f;
            ++n2;
        }
        return sum;
    }
}

