/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.Highlight;
import java.util.ArrayList;

public abstract class ChartData {
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;
    private float mYValueSum = 0.0f;
    private int mYValCount = 0;
    private float mXValAverageLength = 0.0f;
    protected ArrayList<String> mXVals;
    protected ArrayList<? extends DataSet> mDataSets;

    public ChartData(ArrayList<String> xVals, ArrayList<? extends DataSet> sets) {
        this.mXVals = xVals;
        this.mDataSets = sets;
        this.init();
    }

    public ChartData(String[] xVals, ArrayList<? extends DataSet> sets) {
        ArrayList<String> newXVals = new ArrayList<String>();
        int i = 0;
        while (i < xVals.length) {
            newXVals.add(xVals[i]);
            ++i;
        }
        this.mXVals = newXVals;
        this.mDataSets = sets;
        this.init();
    }

    private void init() {
        this.isLegal(this.mDataSets);
        this.calcMinMax(this.mDataSets);
        this.calcYValueSum(this.mDataSets);
        this.calcYValueCount(this.mDataSets);
        this.calcXValAverageLength();
    }

    private void calcXValAverageLength() {
        if (this.mXVals.size() == 0) {
            this.mXValAverageLength = 1.0f;
            return;
        }
        float sum = 0.0f;
        int i = 0;
        while (i < this.mXVals.size()) {
            sum += (float)this.mXVals.get(i).length();
            ++i;
        }
        this.mXValAverageLength = sum / (float)this.mXVals.size();
    }

    protected static ArrayList<? extends DataSet> toArrayList(DataSet dataSet) {
        ArrayList<DataSet> sets = new ArrayList<DataSet>();
        sets.add(dataSet);
        return sets;
    }

    private void isLegal(ArrayList<? extends DataSet> dataSets) {
        int i = 0;
        while (i < dataSets.size()) {
            if (dataSets.get(i).getYVals().size() > this.mXVals.size()) {
                throw new IllegalArgumentException("One or more of the DataSet Entry arrays are longer than the x-values array of this ChartData object.");
            }
            ++i;
        }
    }

    public void notifyDataChanged() {
        this.init();
    }

    protected void calcMinMax(ArrayList<? extends DataSet> dataSets) {
        this.mYMin = dataSets.get(0).getYMin();
        this.mYMax = dataSets.get(0).getYMax();
        int i = 0;
        while (i < dataSets.size()) {
            if (dataSets.get(i).getYMin() < this.mYMin) {
                this.mYMin = dataSets.get(i).getYMin();
            }
            if (dataSets.get(i).getYMax() > this.mYMax) {
                this.mYMax = dataSets.get(i).getYMax();
            }
            ++i;
        }
    }

    protected void calcYValueSum(ArrayList<? extends DataSet> dataSets) {
        this.mYValueSum = 0.0f;
        int i = 0;
        while (i < dataSets.size()) {
            this.mYValueSum += Math.abs(dataSets.get(i).getYValueSum());
            ++i;
        }
    }

    protected void calcYValueCount(ArrayList<? extends DataSet> dataSets) {
        int count = 0;
        int i = 0;
        while (i < dataSets.size()) {
            count += dataSets.get(i).getEntryCount();
            ++i;
        }
        this.mYValCount = count;
    }

    public void notifyDataForNewEntry(Entry entry) {
        this.mYValueSum += Math.abs(entry.getVal());
        if (this.mYMin > entry.getVal()) {
            this.mYMin = entry.getVal();
        }
        if (this.mYMax < entry.getVal()) {
            this.mYMax = entry.getVal();
        }
    }

    public int getDataSetCount() {
        return this.mDataSets.size();
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public float getXValAverageLength() {
        return this.mXValAverageLength;
    }

    public float getYValueSum() {
        return this.mYValueSum;
    }

    public int getYValCount() {
        return this.mYValCount;
    }

    public boolean isValid() {
        if (this.mXVals == null || this.mXVals.size() < 1) {
            return false;
        }
        return this.mDataSets != null && this.mDataSets.size() >= 1;
    }

    public ArrayList<String> getXVals() {
        return this.mXVals;
    }

    public ArrayList<? extends DataSet> getDataSets() {
        return this.mDataSets;
    }

    protected int getDataSetIndexByLabel(ArrayList<? extends DataSet> dataSets, String label, boolean ignorecase) {
        if (ignorecase) {
            int i = 0;
            while (i < dataSets.size()) {
                if (label.equalsIgnoreCase(dataSets.get(i).getLabel())) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dataSets.size()) {
                if (label.equals(dataSets.get(i).getLabel())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getXValCount() {
        return this.mXVals.size();
    }

    protected String[] getDataSetLabels() {
        String[] types = new String[this.mDataSets.size()];
        int i = 0;
        while (i < this.mDataSets.size()) {
            types[i] = this.mDataSets.get(i).getLabel();
            ++i;
        }
        return types;
    }

    public Entry getEntryForHighlight(Highlight highlight) {
        return this.mDataSets.get(highlight.getDataSetIndex()).getEntryForXIndex(highlight.getXIndex());
    }

    public DataSet getDataSetByLabel(String label, boolean ignorecase) {
        int index = this.getDataSetIndexByLabel(this.mDataSets, label, ignorecase);
        if (index <= 0 || index >= this.mDataSets.size()) {
            return null;
        }
        return this.mDataSets.get(index);
    }

    public DataSet getDataSetByIndex(int index) {
        return this.mDataSets.get(index);
    }

    public void addDataSet(DataSet d) {
        if (this.mDataSets == null) {
            this.mDataSets = new ArrayList();
        }
        this.mDataSets.add(d);
        this.mYValCount += d.getEntryCount();
        this.mYValueSum += d.getYValueSum();
        if (this.mYMax < d.getYMax()) {
            this.mYMax = d.getYMax();
        }
        if (this.mYMin > d.getYMin()) {
            this.mYMin = d.getYMin();
        }
    }

    public int[] getColors() {
        int clrcnt = 0;
        int i = 0;
        while (i < this.mDataSets.size()) {
            clrcnt += this.mDataSets.get(i).getColors().size();
            ++i;
        }
        int[] colors = new int[clrcnt];
        int cnt = 0;
        int i2 = 0;
        while (i2 < this.mDataSets.size()) {
            ArrayList<Integer> clrs = this.mDataSets.get(i2).getColors();
            for (Integer clr : clrs) {
                colors[cnt] = clr;
                ++cnt;
            }
            ++i2;
        }
        return colors;
    }

    public static ArrayList<String> generateXVals(int from, int to) {
        ArrayList<String> xvals = new ArrayList<String>();
        int i = from;
        while (i < to) {
            xvals.add("" + i);
            ++i;
        }
        return xvals;
    }
}

