/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.utils.Highlight;

public class PieChartTouchListener
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    Matrix mMatrix = new Matrix();
    Matrix mSavedMatrix = new Matrix();
    PointF mMid = new PointF();
    private PieChart mChart;
    private GestureDetector mGestureDetector;
    private Highlight mLastHighlight = null;

    public PieChartTouchListener(PieChart ctx) {
        this.mChart = ctx;
        this.mGestureDetector = new GestureDetector(ctx.getContext(), (GestureDetector.OnGestureListener)this);
    }

    public boolean onTouch(View v, MotionEvent e) {
        if (this.mGestureDetector.onTouchEvent(e)) {
            return true;
        }
        if (this.mChart.isRotationEnabled()) {
            float x = e.getX();
            float y = e.getY();
            switch (e.getAction()) {
                case 0: {
                    this.mChart.setStartAngle(x, y);
                    break;
                }
                case 2: {
                    this.mChart.updateRotation(x, y);
                    this.mChart.invalidate();
                    break;
                }
            }
        }
        return true;
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public void onLongPress(MotionEvent me) {
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        float distance = this.mChart.distanceToCenter(e.getX(), e.getY());
        if (distance < this.mChart.getRadius() / 2.0f || distance > this.mChart.getRadius()) {
            this.mChart.highlightValues(null);
            this.mLastHighlight = null;
        } else {
            int dataSetIndex;
            int index = this.mChart.getIndexForAngle(this.mChart.getAngleForPoint(e.getX(), e.getY()));
            Highlight h = new Highlight(index, dataSetIndex = this.mChart.getDataSetIndexForIndex(index));
            if (h.equalTo(this.mLastHighlight)) {
                this.mChart.highlightTouch(null);
                this.mLastHighlight = null;
            } else {
                this.mChart.highlightTouch(h);
                this.mLastHighlight = h;
            }
        }
        return true;
    }
}

