/*
 * Decompiled with CFR 0.152.
 */
package com.slidingmenu.lib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.slidingmenu.lib.CustomViewBehind;
import com.slidingmenu.lib.SlidingMenu;
import java.util.ArrayList;
import java.util.List;

public class CustomViewAbove
extends ViewGroup {
    private static final String TAG = "CustomViewAbove";
    private static final boolean DEBUG = false;
    private static final boolean USE_CACHE = false;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };
    private View mContent;
    private int mCurItem;
    private Scroller mScroller;
    private boolean mScrollingCacheEnabled;
    private boolean mScrolling;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private int mTouchSlop;
    private float mInitialMotionX;
    private float mLastMotionX;
    private float mLastMotionY;
    protected int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    protected VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    protected int mMaximumVelocity;
    private int mFlingDistance;
    private CustomViewBehind mViewBehind;
    private boolean mEnabled = true;
    private OnPageChangeListener mOnPageChangeListener;
    private OnPageChangeListener mInternalPageChangeListener;
    private SlidingMenu.OnClosedListener mClosedListener;
    private SlidingMenu.OnOpenedListener mOpenedListener;
    private List<View> mIgnoredViews = new ArrayList<View>();
    protected int mTouchMode = 0;
    private boolean mQuickReturn = false;
    private float mScrollX = 0.0f;

    public CustomViewAbove(Context context) {
        this(context, null);
    }

    public CustomViewAbove(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initCustomViewAbove();
    }

    void initCustomViewAbove() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.setInternalPageChangeListener(new SimpleOnPageChangeListener(){

            @Override
            public void onPageSelected(int position) {
                if (CustomViewAbove.this.mViewBehind != null) {
                    switch (position) {
                        case 0: 
                        case 2: {
                            CustomViewAbove.this.mViewBehind.setChildrenEnabled(true);
                            break;
                        }
                        case 1: {
                            CustomViewAbove.this.mViewBehind.setChildrenEnabled(false);
                        }
                    }
                }
            }
        });
        float density = context.getResources().getDisplayMetrics().density;
        this.mFlingDistance = (int)(25.0f * density);
    }

    public void setCurrentItem(int item) {
        this.setCurrentItemInternal(item, true, false);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.setCurrentItemInternal(item, smoothScroll, false);
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always) {
        this.setCurrentItemInternal(item, smoothScroll, always, 0);
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always, int velocity) {
        if (!always && this.mCurItem == item) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        boolean dispatchSelected = this.mCurItem != (item = this.mViewBehind.getMenuPage(item));
        this.mCurItem = item;
        int destX = this.getDestScrollX(this.mCurItem);
        if (dispatchSelected && this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(item);
        }
        if (dispatchSelected && this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageSelected(item);
        }
        if (smoothScroll) {
            this.smoothScrollTo(destX, 0, velocity);
        } else {
            this.completeScroll();
            this.scrollTo(destX, 0);
        }
    }

    public void setOnPageChangeListener(OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public void setOnOpenedListener(SlidingMenu.OnOpenedListener l) {
        this.mOpenedListener = l;
    }

    public void setOnClosedListener(SlidingMenu.OnClosedListener l) {
        this.mClosedListener = l;
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener listener) {
        OnPageChangeListener oldListener = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = listener;
        return oldListener;
    }

    public void addIgnoredView(View v) {
        if (!this.mIgnoredViews.contains(v)) {
            this.mIgnoredViews.add(v);
        }
    }

    public void removeIgnoredView(View v) {
        this.mIgnoredViews.remove(v);
    }

    public void clearIgnoredViews() {
        this.mIgnoredViews.clear();
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return FloatMath.sin((float)f);
    }

    public int getDestScrollX(int page) {
        switch (page) {
            case 0: 
            case 2: {
                return this.mViewBehind.getMenuLeft(this.mContent, page);
            }
            case 1: {
                return this.mContent.getLeft();
            }
        }
        return 0;
    }

    private int getLeftBound() {
        return this.mViewBehind.getAbsLeftBound(this.mContent);
    }

    private int getRightBound() {
        return this.mViewBehind.getAbsRightBound(this.mContent);
    }

    public int getContentLeft() {
        return this.mContent.getLeft() + this.mContent.getPaddingLeft();
    }

    public boolean isMenuOpen() {
        return this.mCurItem == 0 || this.mCurItem == 2;
    }

    private boolean isInIgnoredView(MotionEvent ev) {
        Rect rect = new Rect();
        for (View v : this.mIgnoredViews) {
            v.getHitRect(rect);
            if (!rect.contains((int)ev.getX(), (int)ev.getY())) continue;
            return true;
        }
        return false;
    }

    public int getBehindWidth() {
        if (this.mViewBehind == null) {
            return 0;
        }
        return this.mViewBehind.getBehindWidth();
    }

    public int getChildWidth(int i) {
        switch (i) {
            case 0: {
                return this.getBehindWidth();
            }
            case 1: {
                return this.mContent.getWidth();
            }
        }
        return 0;
    }

    public boolean isSlidingEnabled() {
        return this.mEnabled;
    }

    public void setSlidingEnabled(boolean b) {
        this.mEnabled = b;
    }

    void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 0);
    }

    void smoothScrollTo(int x, int y, int velocity) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll();
            if (this.isMenuOpen()) {
                if (this.mOpenedListener != null) {
                    this.mOpenedListener.onOpened();
                }
            } else if (this.mClosedListener != null) {
                this.mClosedListener.onClosed();
            }
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.mScrolling = true;
        int width = this.getBehindWidth();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        int duration = 0;
        velocity = Math.abs(velocity);
        if (velocity > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageDelta = (float)Math.abs(dx) / (float)width;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
            duration = 600;
        }
        duration = Math.min(duration, 600);
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        this.invalidate();
    }

    public void setContent(View v) {
        if (this.mContent != null) {
            this.removeView(this.mContent);
        }
        this.mContent = v;
        this.addView(this.mContent);
    }

    public View getContent() {
        return this.mContent;
    }

    public void setCustomViewBehind(CustomViewBehind cvb) {
        this.mViewBehind = cvb;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = CustomViewAbove.getDefaultSize((int)0, (int)widthMeasureSpec);
        int height = CustomViewAbove.getDefaultSize((int)0, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        int contentWidth = CustomViewAbove.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width);
        int contentHeight = CustomViewAbove.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)height);
        this.mContent.measure(contentWidth, contentHeight);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.completeScroll();
            this.scrollTo(this.getDestScrollX(this.mCurItem), this.getScrollY());
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        this.mContent.layout(0, 0, width, height);
    }

    public void setAboveOffset(int i) {
        this.mContent.setPadding(i, this.mContent.getPaddingTop(), this.mContent.getPaddingRight(), this.mContent.getPaddingBottom());
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
                this.pageScrolled(x);
            }
            this.invalidate();
            return;
        }
        this.completeScroll();
    }

    private void pageScrolled(int xpos) {
        int widthWithMargin = this.getWidth();
        int position = xpos / widthWithMargin;
        int offsetPixels = xpos % widthWithMargin;
        float offset = (float)offsetPixels / (float)widthWithMargin;
        this.onPageScrolled(position, offset, offsetPixels);
    }

    protected void onPageScrolled(int position, float offset, int offsetPixels) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, offset, offsetPixels);
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrolled(position, offset, offsetPixels);
        }
    }

    private void completeScroll() {
        boolean needPopulate = this.mScrolling;
        if (needPopulate) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
            if (this.isMenuOpen()) {
                if (this.mOpenedListener != null) {
                    this.mOpenedListener.onOpened();
                }
            } else if (this.mClosedListener != null) {
                this.mClosedListener.onClosed();
            }
        }
        this.mScrolling = false;
    }

    public void setTouchMode(int i) {
        this.mTouchMode = i;
    }

    public int getTouchMode() {
        return this.mTouchMode;
    }

    private boolean thisTouchAllowed(MotionEvent ev) {
        int x = (int)(ev.getX() + this.mScrollX);
        if (this.isMenuOpen()) {
            return this.mViewBehind.menuOpenTouchAllowed(this.mContent, this.mCurItem, x);
        }
        switch (this.mTouchMode) {
            case 1: {
                return !this.isInIgnoredView(ev);
            }
            case 2: {
                return false;
            }
            case 0: {
                return this.mViewBehind.marginTouchAllowed(this.mContent, x);
            }
        }
        return false;
    }

    private boolean thisSlideAllowed(float dx) {
        boolean allowed = false;
        allowed = this.isMenuOpen() ? this.mViewBehind.menuOpenSlideAllowed(dx) : this.mViewBehind.menuClosedSlideAllowed(dx);
        return allowed;
    }

    private int getPointerIndex(MotionEvent ev, int id2) {
        int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)id2);
        if (activePointerIndex == -1) {
            this.mActivePointerId = -1;
        }
        return activePointerIndex;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mEnabled) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        if (action == 3 || action == 1 || action != 0 && this.mIsUnableToDrag) {
            this.endDrag();
            return false;
        }
        switch (action) {
            case 2: {
                this.determineDrag(ev);
                break;
            }
            case 0: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                if (this.mActivePointerId == -1) break;
                this.mLastMotionX = this.mInitialMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                this.mLastMotionY = MotionEventCompat.getY((MotionEvent)ev, (int)index);
                if (this.thisTouchAllowed(ev)) {
                    this.mIsBeingDragged = false;
                    this.mIsUnableToDrag = false;
                    if (!this.isMenuOpen() || !this.mViewBehind.menuTouchInQuickReturn(this.mContent, this.mCurItem, ev.getX() + this.mScrollX)) break;
                    this.mQuickReturn = true;
                    break;
                }
                this.mIsUnableToDrag = true;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        if (!this.mIsBeingDragged) {
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(ev);
        }
        return this.mIsBeingDragged || this.mQuickReturn;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mEnabled) {
            return false;
        }
        if (!this.mIsBeingDragged && !this.thisTouchAllowed(ev)) {
            return false;
        }
        int action = ev.getAction();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action & 0xFF) {
            case 0: {
                this.completeScroll();
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                break;
            }
            case 2: {
                if (!this.mIsBeingDragged) {
                    this.determineDrag(ev);
                    if (this.mIsUnableToDrag) {
                        return false;
                    }
                }
                if (!this.mIsBeingDragged) break;
                int activePointerIndex = this.getPointerIndex(ev, this.mActivePointerId);
                if (this.mActivePointerId == -1) break;
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                float deltaX = this.mLastMotionX - x;
                this.mLastMotionX = x;
                float oldScrollX = this.getScrollX();
                float scrollX = oldScrollX + deltaX;
                float leftBound = this.getLeftBound();
                float rightBound = this.getRightBound();
                if (scrollX < leftBound) {
                    scrollX = leftBound;
                } else if (scrollX > rightBound) {
                    scrollX = rightBound;
                }
                this.mLastMotionX += scrollX - (float)((int)scrollX);
                this.scrollTo((int)scrollX, this.getScrollY());
                this.pageScrolled((int)scrollX);
                break;
            }
            case 1: {
                if (this.mIsBeingDragged) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    int initialVelocity = (int)VelocityTrackerCompat.getXVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                    int scrollX = this.getScrollX();
                    float pageOffset = (float)(scrollX - this.getDestScrollX(this.mCurItem)) / (float)this.getBehindWidth();
                    int activePointerIndex = this.getPointerIndex(ev, this.mActivePointerId);
                    if (this.mActivePointerId != -1) {
                        float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                        int totalDelta = (int)(x - this.mInitialMotionX);
                        int nextPage = this.determineTargetPage(pageOffset, initialVelocity, totalDelta);
                        this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
                    } else {
                        this.setCurrentItemInternal(this.mCurItem, true, true, initialVelocity);
                    }
                    this.mActivePointerId = -1;
                    this.endDrag();
                    break;
                }
                if (!this.mQuickReturn || !this.mViewBehind.menuTouchInQuickReturn(this.mContent, this.mCurItem, ev.getX() + this.mScrollX)) break;
                this.setCurrentItem(1);
                this.endDrag();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.setCurrentItemInternal(this.mCurItem, true, true);
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int indexx = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)indexx);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)indexx);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int pointerIndex = this.getPointerIndex(ev, this.mActivePointerId);
                if (this.mActivePointerId == -1) break;
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
            }
        }
        return true;
    }

    private void determineDrag(MotionEvent ev) {
        int activePointerId = this.mActivePointerId;
        int pointerIndex = this.getPointerIndex(ev, activePointerId);
        if (activePointerId == -1) {
            return;
        }
        float x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
        float dx = x - this.mLastMotionX;
        float xDiff = Math.abs(dx);
        float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
        float dy = y - this.mLastMotionY;
        float yDiff = Math.abs(dy);
        int n = this.isMenuOpen() ? this.mTouchSlop / 2 : this.mTouchSlop;
        if (xDiff > (float)n && xDiff > yDiff && this.thisSlideAllowed(dx)) {
            this.startDrag();
            this.mLastMotionX = x;
            this.mLastMotionY = y;
            this.setScrollingCacheEnabled(true);
        } else if (xDiff > (float)this.mTouchSlop) {
            this.mIsUnableToDrag = true;
        }
    }

    public void scrollTo(int x, int y) {
        super.scrollTo(x, y);
        this.mScrollX = x;
        if (this.mEnabled) {
            this.mViewBehind.scrollBehindTo(this.mContent, x, y);
        }
        ((SlidingMenu)this.getParent()).manageLayers(this.getPercentOpen());
    }

    private int determineTargetPage(float pageOffset, int velocity, int deltaX) {
        int targetPage = this.mCurItem;
        if (Math.abs(deltaX) > this.mFlingDistance && Math.abs(velocity) > this.mMinimumVelocity) {
            if (velocity > 0 && deltaX > 0) {
                --targetPage;
            } else if (velocity < 0 && deltaX < 0) {
                ++targetPage;
            }
        } else {
            targetPage = Math.round((float)this.mCurItem + pageOffset);
        }
        return targetPage;
    }

    protected float getPercentOpen() {
        return Math.abs(this.mScrollX - (float)this.mContent.getLeft()) / (float)this.getBehindWidth();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.mViewBehind.drawShadow(this.mContent, canvas);
        this.mViewBehind.drawFade(this.mContent, canvas, this.getPercentOpen());
        this.mViewBehind.drawSelector(this.mContent, canvas, this.getPercentOpen());
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void startDrag() {
        this.mIsBeingDragged = true;
        this.mQuickReturn = false;
    }

    private void endDrag() {
        this.mQuickReturn = false;
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        this.mActivePointerId = -1;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled != enabled) {
            this.mScrollingCacheEnabled = enabled;
        }
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            int i = count - 1;
            while (i >= 0) {
                View child = group.getChildAt(i);
                if (x + scrollX >= child.getLeft() && x + scrollX < child.getRight() && y + scrollY >= child.getTop() && y + scrollY < child.getBottom() && this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) {
                    return true;
                }
                --i;
            }
        }
        return checkV && ViewCompat.canScrollHorizontally((View)v, (int)(-dx));
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 21: {
                    handled = this.arrowScroll(17);
                    break;
                }
                case 22: {
                    handled = this.arrowScroll(66);
                    break;
                }
                case 61: {
                    if (Build.VERSION.SDK_INT < 11) break;
                    if (KeyEventCompat.hasNoModifiers((KeyEvent)event)) {
                        handled = this.arrowScroll(2);
                        break;
                    }
                    if (!KeyEventCompat.hasModifiers((KeyEvent)event, (int)1)) break;
                    handled = this.arrowScroll(1);
                }
            }
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        boolean handled = false;
        View nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, direction);
        if (nextFocused != null && nextFocused != currentFocused) {
            if (direction == 17) {
                handled = nextFocused.requestFocus();
            } else if (direction == 66) {
                handled = currentFocused != null && nextFocused.getLeft() <= currentFocused.getLeft() ? this.pageRight() : nextFocused.requestFocus();
            }
        } else if (direction == 17 || direction == 1) {
            handled = this.pageLeft();
        } else if (direction == 66 || direction == 2) {
            handled = this.pageRight();
        }
        if (handled) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)direction));
        }
        return handled;
    }

    boolean pageLeft() {
        if (this.mCurItem > 0) {
            this.setCurrentItem(this.mCurItem - 1, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        if (this.mCurItem < 1) {
            this.setCurrentItem(this.mCurItem + 1, true);
            return true;
        }
        return false;
    }

    public static interface OnPageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        @Override
        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    }
}

