package com.weatherdemo.DB;
import com.weatherdemo.SMS.SimpleSms;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.widget.Toast;

public class DBAdapter {

	private static final String DB_NAME = "weather_app.db";
	private static final String DB_TABLE_CONFIG = "setup_config";
	private static final String DB_CONFIG_ID = "1";
	private static final int DB_VERSION	= 1;


	public static final String KEY_ID = "_id";
	public static final String KEY_CITY_NAME = "city_name";
	public static final String KEY_REFRESH_SPEED = "refresh_speed";
	public static final String KEY_SMS_SERVICE = "sms_service";
	public static final String KEY_SMS_INFO = "sms_info";
	public static final String KEY_KEY_WORD = "key_word";


	private static final String DB_TABLE_SMS = "sms_data";
	public static final String KEY_SENDER = "sms_sender";
	public static final String KEY_BODY = "sms_body";
	public static final String KEY_RECEIVE_TIME = "sms_receive_time";
	public static final String KEY_RETURN_RESULT = "return_result";
	
	private SQLiteDatabase db;
	private final Context context;
	private DBOpenHelper dbOpenHelper;
	
	
	public DBAdapter(Context _context){
		context = _context;
	}

	public void close(){
		if(db != null){
			db.close();
			db = null;
		}
	}
	
	public void open() throws SQLiteException{
		dbOpenHelper = new DBOpenHelper(context, DB_NAME, null, DB_VERSION);
		try{
			db = dbOpenHelper.getWritableDatabase();
		}
		catch(SQLiteException e){
			db = dbOpenHelper.getReadableDatabase();
		}
	}
	
	private static class DBOpenHelper extends SQLiteOpenHelper{

		public DBOpenHelper(Context context, String name,
				CursorFactory factory, int version) {
			super(context, name, factory, version);
			// TODO Auto-generated constructor stub
		}

		private static final String DB_CREATE_CONFIG = "create table " + 
				DB_TABLE_CONFIG + "(" + KEY_ID + " integer primary key autoincrement, "+
				KEY_CITY_NAME+ " text not null, " +
				KEY_REFRESH_SPEED + " text, " + 
				KEY_SMS_SERVICE + " text, " +
				KEY_SMS_INFO + " text, " +
				KEY_KEY_WORD + " text);";
		
		private static final String DB_CREATE_SMS = "create table " + 
				DB_TABLE_SMS + "(" + KEY_ID + " integer primary key autoincrement, "+
				KEY_SENDER + " text not null, " +
				KEY_BODY + " text, " + 
				KEY_RECEIVE_TIME + " text, " +
				KEY_RETURN_RESULT + " text);" ;
		
		
		@Override
		public void onCreate(SQLiteDatabase arg0) {
			// TODO Auto-generated method stub

			arg0.execSQL(DB_CREATE_CONFIG);
			arg0.execSQL(DB_CREATE_SMS);
			
			
			//初始化系统配置的数据表
			Config.LoadDefaultConfig();
			ContentValues newValues = new ContentValues();
			newValues.put(KEY_CITY_NAME, Config.CityName);
			newValues.put(KEY_REFRESH_SPEED, Config.RefreshSpeed);
			newValues.put(KEY_SMS_SERVICE, Config.ProvideSmsService);
			newValues.put(KEY_SMS_INFO, Config.SaveSmsInfo);
			newValues.put(KEY_KEY_WORD, Config.KeyWord);
			arg0.insert(DB_TABLE_CONFIG, null, newValues);
		}

		@Override
		public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {
			// TODO Auto-generated method stub
			arg0.execSQL("DROP TABLE IF EXISTS " + DB_TABLE_CONFIG);
			arg0.execSQL("DROP TABLE IF EXISTS " + DB_TABLE_SMS);
			onCreate(arg0);
		}

	}
	
	//保存设置
	public void SaveConfig(){
		ContentValues updateValues = new ContentValues();
		updateValues.put(KEY_CITY_NAME, Config.CityName);
		updateValues.put(KEY_REFRESH_SPEED, Config.RefreshSpeed);
		updateValues.put(KEY_SMS_SERVICE, Config.ProvideSmsService);
		updateValues.put(KEY_SMS_INFO, Config.SaveSmsInfo);
		updateValues.put(KEY_KEY_WORD, Config.KeyWord);
		db.update(DB_TABLE_CONFIG, updateValues, KEY_ID+"="+DB_CONFIG_ID, null);
		Toast.makeText(context, "系统设置保存成功！", Toast.LENGTH_SHORT).show();
		
	}
	
	//读取设置
	public void LoadConfig(){
		String[] columns = {KEY_ID, KEY_CITY_NAME, KEY_REFRESH_SPEED, KEY_SMS_SERVICE, KEY_SMS_INFO, KEY_KEY_WORD};
		
		Cursor result = db.query(DB_TABLE_CONFIG, columns, KEY_ID+"="+DB_CONFIG_ID, null, null, null, null);
		if(result.getCount()==0 || !result.moveToFirst()){
			return;
		}
		
		Config.CityName = result.getString(result.getColumnIndex(KEY_CITY_NAME));
		Config.RefreshSpeed = result.getString(result.getColumnIndex(KEY_REFRESH_SPEED));
		Config.ProvideSmsService = result.getString(result.getColumnIndex(KEY_SMS_SERVICE));
		Config.SaveSmsInfo = result.getString(result.getColumnIndex(KEY_SMS_INFO));
		Config.KeyWord = result.getString(result.getColumnIndex(KEY_KEY_WORD));
		Toast.makeText(context, "系统设置读取成功！", Toast.LENGTH_SHORT).show();
	}
	
	//插入一条短信
	public void SaveOneSms(SimpleSms sms){
		ContentValues newValues = new ContentValues();
		newValues.put(KEY_SENDER, sms.Sender);
		newValues.put(KEY_BODY, sms.Body);
		newValues.put(KEY_RECEIVE_TIME, sms.ReceiveTime);
		newValues.put(KEY_RETURN_RESULT, sms.ReturnResult);
		db.insert(DB_TABLE_SMS, null, newValues);
	}
	
	//删除所有短信
	public long DeleteAllSms(){
		return db.delete(DB_TABLE_SMS, null, null);
	}
	
	//获取所有短信
	public SimpleSms[] GetAllSms(){
		String[] columns = {KEY_ID, KEY_SENDER, KEY_BODY, KEY_RECEIVE_TIME, KEY_RETURN_RESULT};
		Cursor result = db.query(DB_TABLE_SMS, columns, null, null, null, null, null);
		return ToSimpleSms(result);
	}
	
	private SimpleSms[] ToSimpleSms(Cursor cursor){
		int resultCounts = cursor.getCount();
		if(resultCounts==0 || !cursor.moveToFirst()){
			return null;
		}
		
		SimpleSms[] sms = new SimpleSms[resultCounts];
		for(int i=0; i<resultCounts; i++){
			sms[i] = new SimpleSms();
			sms[i].Sender = cursor.getString(cursor.getColumnIndex(KEY_SENDER));
			sms[i].Body = cursor.getString(cursor.getColumnIndex(KEY_BODY));
			sms[i].ReceiveTime = cursor.getString(cursor.getColumnIndex(KEY_RECEIVE_TIME));
			sms[i].ReturnResult = cursor.getString(cursor.getColumnIndex(KEY_RETURN_RESULT));
			cursor.moveToNext();
		}
		return sms;
	}
}
