package com.weatherdemo.Service;


import java.util.ArrayList;



import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.telephony.gsm.SmsManager;
import android.util.Log;
import android.widget.Toast;

import com.weatherdemo.DB.Config;
import com.weatherdemo.DB.DBAdapter;
import com.weatherdemo.SMS.SimpleSms;
import com.weatherdemo.Weather.Weather;

public class WeatherService extends Service{

	private DBAdapter dbAdapter;
	private Thread workThread;
	private static ArrayList<SimpleSms> smsList = new ArrayList<SimpleSms>();
	private static int timeCounter = 1;
	
	
	
	public static void RequerSMSService(SimpleSms sms){
		if(Config.ProvideSmsService.equals("true")){
			smsList.add(sms);
		}
	}
	
	private void SaveSmsData(SimpleSms sms){
		if(Config.SaveSmsInfo.equals("true")){
			dbAdapter.SaveOneSms(sms);
		}
	}
	
	
	@Override
	public void onCreate(){
		super.onCreate();
		dbAdapter = new DBAdapter(this);
		dbAdapter.open();
		
		Toast.makeText(this, "天气服务启动", Toast.LENGTH_LONG).show();
		workThread = new Thread(null, backgroudWork, "WorkThread");
	}
	
	@Override
	public void onStart(Intent intent, int startId){
		super.onStart(intent, startId);
		if(!workThread.isAlive()){
			workThread.start();
		}
	}
	
	
	@Override
	public void onDestroy(){
		super.onDestroy();
		Toast.makeText(this, "天气服务停止", Toast.LENGTH_LONG).show();
		workThread.interrupt();
	}
	
	@Override
	public IBinder onBind(Intent arg0) {
		// TODO Auto-generated method stub
		return null;
	}
	
	
	private Runnable backgroudWork = new Runnable() {
		
		@Override
		public void run() {
			// TODO Auto-generated method stub
			try{
				while(!Thread.interrupted()){
					ProcessSmsList();
					GetBaiduWeatherData();
					Thread.sleep(1000);
				}
			}catch(InterruptedException e){
				e.printStackTrace();
			}
		}
	};
	
	
	private void ProcessSmsList(){
		if(smsList.size() ==0){
			return;
		}
		
		SmsManager smsManager = SmsManager.getDefault();
		PendingIntent mPi = PendingIntent.getBroadcast(this, 0, new Intent(), 0);
		
		while(smsList.size() > 0){
			SimpleSms sms = smsList.get(0);
			smsList.remove(0);
			smsManager.sendTextMessage(sms.Sender, null, Weather.GetSmsMsg(), mPi, null);
			sms.ReturnResult = Weather.GetSmsMsg();
			SaveSmsData(sms);
		}
	}


	private void GetBaiduWeatherData(){
		Log.i("TIMER", String.valueOf(timeCounter));
		if(timeCounter --< 0){
			timeCounter = Integer.parseInt(Config.RefreshSpeed);
			Log.i("TIMER", "NOW");
			try{
				WeatherAdapter.GetWeatherData();
			}catch (Throwable e) {
				// TODO: handle exception
				e.printStackTrace();
			}
		}
		
	}
	
}
