/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.compatible;

import com.kinkaid.acs.compatible.Message;
import com.kinkaid.acs.compatible.MessageQueue;
import java.util.Timer;
import java.util.TimerTask;

public class Handler {
    public static byte[] lock = new byte[0];
    private static Thread handlerThread;
    private static MessageQueue messageQueue;
    Callback mCallback;

    static {
        if (messageQueue == null) {
            messageQueue = new MessageQueue();
        }
        if (handlerThread == null) {
            handlerThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    while (true) {
                        byte[] byArray = lock;
                        // MONITORENTER : lock
                        Message tmpMessage = messageQueue.deQueue();
                        if (tmpMessage == null) {
                            try {
                                lock.wait();
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                        } else {
                            Handler targetHandler = tmpMessage.getTarget();
                            if (targetHandler != null) {
                                targetHandler.dispatchMessage(tmpMessage);
                            }
                        }
                        // MONITOREXIT : byArray
                    }
                }
            };
            handlerThread.start();
        }
    }

    public Handler() {
    }

    public Handler(Callback mCallback) {
        this.mCallback = mCallback;
    }

    public void handleMessage(Message msg) {
    }

    public void dispatchMessage(Message msg) {
        if (messageQueue.match(msg.callback)) {
            return;
        }
        if (msg.callback != null) {
            this.handleCallback(msg);
        } else {
            if (this.mCallback != null && this.mCallback.handleMessage(msg)) {
                return;
            }
            this.handleMessage(msg);
        }
    }

    private void handleCallback(Message msg) {
        msg.callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message msg) {
        if (msg == null) {
            return;
        }
        if (msg.getTarget() == null) {
            msg.setTarget(this);
        }
        byte[] byArray = lock;
        synchronized (lock) {
            messageQueue.enQueue(msg);
            lock.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removeCallbacks(Runnable callback) {
        messageQueue.removeRunnable(callback);
    }

    public void postDelayed(Runnable callback, long time) {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new DelayTask(callback), time);
    }

    public Message obtainMessage() {
        Message msg = new Message();
        msg.setTarget(this);
        return msg;
    }

    public static interface Callback {
        public boolean handleMessage(Message var1);
    }

    private class DelayTask
    extends TimerTask {
        private Runnable r;

        public DelayTask(Runnable runnable) {
            this.r = runnable;
        }

        @Override
        public void run() {
            this.r.run();
        }
    }
}

