/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.protocol.common.share.dataset;

import com.kinkaid.acs.protocol.common.share.dataset.CommonMetadata;
import com.kinkaid.acs.protocol.common.share.dataset.DatasetAttribute;
import com.kinkaid.acs.protocol.common.share.event.field.Field;
import com.kinkaid.acs.protocol.common.share.event.field.FieldCreator;
import com.kinkaid.acs.protocol.common.share.event.field.FieldValue;
import com.kinkaid.acs.protocol.interfaces.share.dataset.IDataset;
import com.kinkaid.acs.protocol.interfaces.share.dataset.IDatasetAttribute;
import com.kinkaid.acs.protocol.interfaces.share.exception.DatasetRuntimeException;
import com.kinkaid.acs.protocol.interfaces.share.exception.EventRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CommonDataset
implements IDataset {
    protected CommonMetadata metadata = new CommonMetadata();
    protected List<List<FieldValue>> lines = new ArrayList<List<FieldValue>>();
    protected int currentLineIndex = 1;
    protected List<FieldValue> currentLine = null;
    protected String datasetName = null;
    protected IDatasetAttribute dssa = new DatasetAttribute();
    protected int totalCount = -1;
    protected final FieldCreator fc;
    protected int workMode = 1;

    protected CommonDataset(IDatasetAttribute dssa) {
        this.dssa = dssa;
        this.fc = FieldCreator.getNewInstance(dssa);
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public byte[] getByteArray(String columnName) {
        return this.getByteArray(columnName, this.dssa.getDefBytes());
    }

    @Override
    public double getDouble(String columnName) {
        return this.getDouble(columnName, this.dssa.getDefDouble());
    }

    @Override
    public int getInt(String columnName) {
        return this.getInt(columnName, this.dssa.getDefInt());
    }

    @Override
    public long getLong(String columnName) {
        return this.getLong(columnName, this.dssa.getDefLong());
    }

    @Override
    public String getString(String columnName) {
        return this.getString(columnName, this.dssa.getDefString());
    }

    @Override
    public String[] getStringArray(String columnName) {
        return this.getStringArray(columnName, this.dssa.getDefStrings());
    }

    @Override
    public byte[] getByteArray(int columnIndex) {
        return this.getByteArray(columnIndex, this.dssa.getDefBytes());
    }

    @Override
    public double getDouble(int columnIndex) {
        return this.getDouble(columnIndex, this.dssa.getDefDouble());
    }

    @Override
    public int getInt(int columnIndex) {
        return this.getInt(columnIndex, this.dssa.getDefInt());
    }

    @Override
    public long getLong(int columnIndex) {
        return this.getLong(columnIndex, this.dssa.getDefLong());
    }

    @Override
    public String getString(int columnIndex) {
        return this.getString(columnIndex, this.dssa.getDefString());
    }

    @Override
    public String[] getStringArray(int columnIndex) {
        return this.getStringArray(columnIndex, this.dssa.getDefStrings());
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public void beforeFirst() {
        this.currentLineIndex = 0;
        this.currentLine = this.lines.size() != 0 ? this.lines.get(this.currentLineIndex) : null;
    }

    @Override
    public boolean hasNext() {
        return this.currentLineIndex < this.lines.size();
    }

    @Override
    public void next() {
        ++this.currentLineIndex;
        this.currentLine = this.lines.get(this.currentLineIndex - 1);
    }

    @Override
    public void setIndex(int index) {
        this.currentLineIndex = index >= 0 && index < this.lines.size() - 1 ? index + 1 : this.lines.size();
        this.currentLine = this.lines.get(this.currentLineIndex - 1);
    }

    @Override
    public int getIndex() {
        return this.currentLineIndex - 1;
    }

    @Override
    public int findColumn(String columnName) {
        return this.metadata.findColumn(columnName);
    }

    @Override
    public int getColumnCount() {
        return this.metadata.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.metadata.getColumnName(column);
    }

    @Override
    public char getColumnType(int column) {
        return this.metadata.getColumnType(column);
    }

    @Override
    public boolean appendRow() {
        boolean result = false;
        this.currentLine = new Vector<FieldValue>();
        this.lines.add(this.currentLine);
        int size = this.metadata.getColumnCount();
        int i2 = 1;
        while (i2 <= size) {
            this.currentLine.add(this.fc.getFieldValue((Object)null));
            ++i2;
        }
        return result;
    }

    @Override
    public void addRow(List<FieldValue> row) {
        if (row != null) {
            this.lines.add(row);
        }
    }

    @Override
    public boolean deleteRow(int index) {
        boolean ret = false;
        if (index >= 0 && index < this.lines.size()) {
            try {
                this.lines.remove(index);
                ret = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public void modifyColumnType(String colName, int type) {
        Integer t2 = FieldCreator.getTypeMap().get(type);
        if (t2 == null) {
            throw new EventRuntimeException("69", type);
        }
        int index = this.checkColumnName(colName, true);
        Field field = this.metadata.getField(index);
        field.setType((char)t2.intValue());
    }

    @Override
    public void modifyColumnType(int colIndex, int type) {
        Integer t2 = FieldCreator.getTypeMap().get(type);
        if (t2 == null) {
            throw new EventRuntimeException("69", type);
        }
        this.checkColumnIndex(colIndex);
        Field field = this.metadata.getField(colIndex);
        field.setType((char)t2.intValue());
    }

    @Override
    public void updateByteArray(int columnIndex, byte[] v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    @Override
    public void updateByteArray(String columnName, byte[] v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this.updateByteArray(columnIndex, v);
    }

    @Override
    public void updateDouble(int columnIndex, double v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    @Override
    public void updateDouble(String columnName, double v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this.updateDouble(columnIndex, v);
    }

    @Override
    public void updateInt(int columnIndex, int v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    @Override
    public void updateInt(String columnName, int v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this.updateInt(columnIndex, v);
    }

    @Override
    public void updateLong(int columnIndex, long v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    @Override
    public void updateLong(String columnName, long v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this.updateLong(columnIndex, v);
    }

    @Override
    public void updateString(int columnIndex, String v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    @Override
    public void updateString(String columnName, String v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this.updateString(columnIndex, v);
    }

    @Override
    public void updateStringArray(int columnIndex, String[] v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    @Override
    public void updateStringArray(String columnName, String[] v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this.updateStringArray(columnIndex, v);
    }

    @Override
    public void updateValue(int columnIndex, Object v) {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    @Override
    public void updateValue(String columnName, Object v) {
        int columnIndex = this.checkColumnName(columnName, true);
        this.updateValue(columnIndex, v);
    }

    @Override
    public byte[] getByteArray(String columnName, byte[] def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this.getByteArray(index, def);
    }

    @Override
    public byte[] getByteArray(int columnIndex, byte[] def) {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getByteArray(def);
        }
        catch (DatasetRuntimeException e2) {
            if (this.isExceptionMode()) {
                throw e2;
            }
            return def;
        }
    }

    @Override
    public double getDouble(String columnName, double def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this.getDouble(index, def);
    }

    @Override
    public double getDouble(int columnIndex, double def) {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getDouble(def);
        }
        catch (DatasetRuntimeException e2) {
            if (this.isExceptionMode()) {
                throw e2;
            }
            return def;
        }
    }

    @Override
    public int getInt(String columnName, int def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this.getInt(index, def);
    }

    @Override
    public int getInt(int columnIndex, int def) {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getInt(def);
        }
        catch (DatasetRuntimeException e2) {
            if (this.isExceptionMode()) {
                throw e2;
            }
            return def;
        }
    }

    @Override
    public long getLong(String columnName, long def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this.getLong(index, def);
    }

    @Override
    public long getLong(int columnIndex, long def) {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getLong(def);
        }
        catch (DatasetRuntimeException e2) {
            if (this.isExceptionMode()) {
                throw e2;
            }
            return def;
        }
    }

    @Override
    public String getString(String columnName, String def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this.getString(index, def);
    }

    @Override
    public String getString(int columnIndex, String def) {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getString(def);
        }
        catch (DatasetRuntimeException e2) {
            if (this.isExceptionMode()) {
                throw e2;
            }
            return def;
        }
    }

    @Override
    public String[] getStringArray(String columnName, String[] def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this.getStringArray(index, def);
    }

    @Override
    public String[] getStringArray(int columnIndex, String[] def) {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getStringArray(def);
        }
        catch (DatasetRuntimeException e2) {
            if (this.isExceptionMode()) {
                throw e2;
            }
            return def;
        }
    }

    @Override
    public Object getValue(String columnName) {
        return this.getValue(columnName, null);
    }

    @Override
    public Object getValue(int columnIndex) {
        return this.getValue(columnIndex, null);
    }

    @Override
    public Object getValue(String columnName, Object def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return this.dssa.getDefLong();
        }
        return this.getValue(index, def);
    }

    @Override
    public Object getValue(int columnIndex, Object def) {
        this.checkColumnIndex(columnIndex);
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getValue();
        }
        catch (DatasetRuntimeException e2) {
            if (this.isExceptionMode()) {
                throw e2;
            }
            return def;
        }
    }

    @Override
    public void addColumn(String colName, int type) {
        List<FieldValue> vs;
        Field field = this.fc.getField(colName, type);
        int realIndex = this.metadata.addField(field);
        int size = this.lines.size();
        if (size > 0 && realIndex > (vs = this.lines.get(0)).size()) {
            int i2 = 0;
            while (i2 < size) {
                vs = this.lines.get(i2);
                FieldValue fv = this.fc.getDefaultValue(field.getType());
                vs.add(fv);
                ++i2;
            }
        }
    }

    @Override
    public void addColumn(String colName) {
        this.addColumn(colName, 83);
    }

    @Override
    public int getMode() {
        return this.workMode;
    }

    @Override
    public void setMode(int mode) {
        this.workMode = mode == 0 ? mode : 1;
    }

    @Override
    public void setDatasetName(String name) {
        this.datasetName = name;
    }

    public IDatasetAttribute getDatasetAttribute() {
        return this.dssa;
    }

    public IDatasetAttribute setDatasetAttribute(IDatasetAttribute dssa) {
        if (dssa == null) {
            return null;
        }
        IDatasetAttribute pre = dssa;
        this.dssa.copyFrom(dssa);
        return pre;
    }

    @Override
    public void clear() {
        this.lines.clear();
        this.currentLineIndex = 1;
        this.currentLine = null;
    }

    @Override
    public void clearAll() {
        this.metadata.clear();
        this.lines.clear();
        this.currentLineIndex = 1;
        this.currentLine = null;
    }

    @Override
    public void locateLine(int lineIndex) {
        if (!this.locateRow(lineIndex)) {
            throw new DatasetRuntimeException("65", lineIndex, 1, this.lines.size());
        }
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    protected boolean isExceptionMode() {
        return this.getMode() == 0;
    }

    protected boolean locateRow(int rowIndex) {
        if (rowIndex >= 1 && rowIndex <= this.getRowCount()) {
            this.currentLineIndex = rowIndex;
            this.currentLine = this.lines.get(this.currentLineIndex - 1);
            return true;
        }
        return false;
    }

    protected int checkColumnName(String columnName, boolean bException) {
        int index = this.metadata.findColumn(columnName);
        if (index == 0 && bException) {
            throw new DatasetRuntimeException("68", new Object[]{columnName});
        }
        return index;
    }

    protected void checkColumnIndex(int columnIndex) {
        if (!this.metadata.isValidColumnIndex(columnIndex)) {
            throw new DatasetRuntimeException("66", columnIndex, 1, this.metadata.getColumnCount());
        }
    }

    @Override
    public void insertParam(String columnName, int type, Object v) {
        int index = this.metadata.findColumn(columnName);
        if (index != 0) {
            this.updateValue(index, v);
        } else {
            Field field = this.fc.getField(columnName, type);
            this.metadata.addField(field);
            int size = this.lines.size();
            if (size == 0) {
                this.currentLine = new Vector<FieldValue>();
                this.lines.add(this.currentLine);
            }
            FieldValue fv = this.fc.getFieldValue(v);
            this.currentLine.add(fv);
        }
    }

    @Override
    public void insertString(String columnName, String v) {
        this.insertParam(columnName, 83, v);
    }

    @Override
    public void insertInteger(String columnName, int v) {
        this.insertParam(columnName, 73, v);
    }

    public List<FieldValue> getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public String getString(int rowIndex, int columnIndex) {
        List<FieldValue> ret = this.lines.get(rowIndex - 1);
        return ret.get(columnIndex - 1).getString();
    }
}

