/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.protocol.common.share.dataset;

import com.kinkaid.acs.protocol.common.share.event.field.Field;
import com.kinkaid.acs.protocol.interfaces.share.dataset.IDatasetMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CommonMetadata
implements IDatasetMetaData {
    private Vector<Field> fields = new Vector();
    private Map<String, Integer> mapping = new HashMap<String, Integer>();

    public int addField(Field field) {
        int index = this.findColumn(field.getName());
        if (index != 0) {
            this.fields.set(index - 1, field);
            this.mapping.put(field.getName(), index - 1);
            return index;
        }
        this.fields.add(field);
        index = this.fields.size();
        this.mapping.put(field.getName(), index - 1);
        return index;
    }

    @Override
    public int findColumn(String columnName) {
        int index = 0;
        if (columnName == null || columnName.trim().length() == 0) {
            return index;
        }
        Integer it = this.mapping.get(columnName);
        index = it == null ? 0 : it + 1;
        return index;
    }

    @Override
    public int getColumnCount() {
        return this.fields.size();
    }

    @Override
    public String getColumnName(int column) {
        if (!this.isValidColumnIndex(column)) {
            return null;
        }
        return this.fields.get(column - 1).getName();
    }

    @Override
    public char getColumnType(int column) {
        if (!this.isValidColumnIndex(column)) {
            return 'N';
        }
        return this.fields.get(column - 1).getType();
    }

    public boolean isValidColumnIndex(int column) {
        return column > 0 && column <= this.fields.size();
    }

    public Field getField(int column) {
        if (this.isValidColumnIndex(column)) {
            return this.fields.get(column - 1);
        }
        return null;
    }

    protected void clear() {
        this.fields.clear();
        this.mapping.clear();
    }
}

