/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.protocol.common.share.dataset;

import com.kinkaid.acs.protocol.common.share.dataset.CommonDataset;
import com.kinkaid.acs.protocol.common.share.dataset.DatasetAttribute;
import com.kinkaid.acs.protocol.common.share.event.field.FieldCreator;
import com.kinkaid.acs.protocol.common.share.event.field.FieldValue;
import com.kinkaid.acs.protocol.interfaces.share.dataset.IDataset;
import com.kinkaid.acs.protocol.interfaces.share.dataset.IDatasetAttribute;
import com.kinkaid.acs.protocol.interfaces.share.exception.DatasetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class DatasetService {
    protected static DatasetService staticInstance;
    protected static IDatasetAttribute staticdssa;
    protected IDatasetAttribute dssa;
    protected FieldCreator fc;

    static {
        staticdssa = new DatasetAttribute();
        staticInstance = new DatasetService(staticdssa);
    }

    protected DatasetService(IDatasetAttribute dssa) {
        this.dssa = dssa == null ? new DatasetAttribute() : dssa;
        this.fc = FieldCreator.getNewInstance(this.dssa);
    }

    public static DatasetService getDefaultInstance() {
        return staticInstance;
    }

    public static DatasetService getInstace() {
        return new DatasetService(new DatasetAttribute());
    }

    public static DatasetService getInstace(IDatasetAttribute attr) {
        return new DatasetService(attr);
    }

    public static IDatasetAttribute getDefaultDatasetAttribute() {
        return staticdssa;
    }

    public static IDatasetAttribute getDatasetAttribute(IDataset dataset) {
        if (dataset == null) {
            return null;
        }
        CommonDataset ds = (CommonDataset)dataset;
        return ds.getDatasetAttribute();
    }

    public static void setDatasetAttribute(IDataset dataset, IDatasetAttribute dssa) {
        if (dataset != null && dssa != null) {
            CommonDataset ds = (CommonDataset)dataset;
            IDatasetAttribute attribute = ds.getDatasetAttribute();
            attribute.copyFrom(dssa);
        }
    }

    public IDataset getDataset() {
        return this.getDataset(staticdssa);
    }

    public IDataset getDataset(IDatasetAttribute attr) {
        return new CommonDataset(attr);
    }

    public IDataset getDataset(ResultSet rs) {
        return this.getDataset(rs, staticdssa);
    }

    public IDataset getDataset(ResultSet rs, IDatasetAttribute attr) {
        IDataset cds = this.getDataset(attr);
        try {
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCount = rsmeta.getColumnCount();
            int i2 = 1;
            while (i2 <= colCount) {
                cds.addColumn(rsmeta.getColumnName(i2), rsmeta.getColumnType(i2));
                ++i2;
            }
            while (rs.next()) {
                cds.appendRow();
                i2 = 1;
                while (i2 <= colCount) {
                    cds.updateValue(i2, rs.getObject(i2));
                    ++i2;
                }
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return cds;
    }

    public IDataset getErrorDataset(int returnCode, String errorNo, String errorInfo) {
        IDataset errorDataset = this.getDataset(staticdssa);
        errorDataset.setDatasetName("error");
        errorDataset.addColumn("returnCode", 73);
        errorDataset.addColumn("errorNo", 76);
        errorDataset.addColumn("errorInfo", 83);
        errorDataset.appendRow();
        errorDataset.updateInt("returnCode", returnCode);
        errorDataset.updateString("errorNo", errorNo);
        errorDataset.updateString("errorInfo", errorInfo);
        return errorDataset;
    }

    public IDataset getDataset(Map oneRow) {
        return this.getDataset(oneRow, staticdssa);
    }

    public IDataset getDataset(Map oneRow, IDatasetAttribute attr) {
        if (oneRow == null) {
            return this.getDataset(attr);
        }
        ArrayList<Map> l2 = new ArrayList<Map>();
        l2.add(oneRow);
        return this.getDataset(l2, attr);
    }

    public IDataset getDataset(Collection<Map> mutiRows) {
        return this.getDataset(mutiRows, staticdssa);
    }

    public IDataset getDataset(Collection<Map> mutiRows, IDatasetAttribute attr) {
        Object value;
        String key;
        if (mutiRows == null || mutiRows.size() == 0) {
            return this.getDataset();
        }
        Iterator<Map> it = mutiRows.iterator();
        IDataset ds = this.getDataset(attr);
        Map oneRow = it.next();
        if (oneRow.size() == 0) {
            return this.getDataset(attr);
        }
        for (Map.Entry e2 : oneRow.entrySet()) {
            key = (String)e2.getKey();
            value = e2.getValue();
            this.addColumnWithValue(ds, key, value);
        }
        it = mutiRows.iterator();
        while (it.hasNext()) {
            ds.appendRow();
            oneRow = it.next();
            for (Map.Entry e2 : oneRow.entrySet()) {
                key = (String)e2.getKey();
                value = e2.getValue();
                try {
                    this.updateRowValue(ds, key, value);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return ds;
    }

    public IDataset getDataset(Object oneRow, Class<?> clz) {
        return this.getDataset(oneRow, clz, staticdssa);
    }

    public IDataset getDataset(Object oneRow, Class<?> clz, IDatasetAttribute attr) {
        if (oneRow == null) {
            Object l2 = null;
            return this.getDataset(l2, clz, attr);
        }
        ArrayList<Object> l3 = new ArrayList<Object>();
        l3.add(oneRow);
        return this.getDataset(l3, clz);
    }

    public IDataset getDataset(Collection<?> mutiRows, Class<?> clz) {
        return this.getDataset(mutiRows, clz, staticdssa);
    }

    private void addColumnWithValue(IDataset ds, String key, Object object) {
        int type = 83;
        if (object != null) {
            FieldValue fv = this.fc.getFieldValue(object);
            type = fv.getType();
        }
        ds.addColumn(key, type);
    }

    private void updateRowValue(IDataset ds, String key, Object object) throws DatasetException {
        ds.updateValue(key, object);
    }

    public IDatasetAttribute getDatasetAttribute() {
        return this.dssa;
    }

    public IDatasetAttribute setDatasetAttribute(IDatasetAttribute dssa) {
        IDatasetAttribute pre = this.dssa;
        this.dssa.copyFrom(dssa);
        this.fc = FieldCreator.getNewInstance(this.dssa);
        return pre;
    }

    public static void printDataset(IDataset ds) {
        StringBuilder sb = new StringBuilder();
        int columnCount = ds.getColumnCount();
        int j2 = 1;
        while (j2 <= columnCount) {
            sb.append("# " + j2 + "\t");
            sb.append(ds.getColumnName(j2));
            sb.append("\t");
            sb.append(String.valueOf(ds.getColumnType(j2)) + "\n");
            ++j2;
        }
        ds.beforeFirst();
        while (ds.hasNext()) {
            ds.next();
            j2 = 1;
            while (j2 <= columnCount) {
                sb.append("|" + ds.getString(ds.getColumnName(j2)) + "\t");
                ++j2;
            }
            sb.append("\n");
        }
        System.out.println(sb.toString());
    }

    private <T> T getObject(Class<T> clz) {
        T obj = null;
        try {
            obj = clz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }
}

