/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.protocol.common.share.event.pack;

import com.kinkaid.acs.protocol.common.share.dataset.DatasetService;
import com.kinkaid.acs.protocol.common.share.util.ByteArrayStream;
import com.kinkaid.acs.protocol.common.share.util.ByteArrayUtil;
import com.kinkaid.acs.protocol.interfaces.share.dataset.IDataset;
import com.kinkaid.acs.protocol.interfaces.share.event.IPack;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class PackDataset
implements IPack {
    private byte[] data = null;
    private boolean isPack = false;
    private boolean isUnpack = false;
    private static final String charset = "UTF-8";
    private IDataset dataset = null;

    public PackDataset() {
    }

    public PackDataset(byte[] data) {
        this.data = data;
        this.unPack(data);
    }

    @Override
    public byte[] Pack() {
        if (this.isPack) {
            return this.data;
        }
        ByteArrayStream tmpBuffer = new ByteArrayStream();
        tmpBuffer.write(33);
        byte[] result = this.packDataset(this.dataset);
        tmpBuffer.write(result);
        this.data = tmpBuffer.toByteArray();
        this.isPack = true;
        return this.data;
    }

    private byte[] packDataset(IDataset ds) {
        ByteArrayStream tmpBuffer = new ByteArrayStream();
        String datasetName = null;
        try {
            datasetName = ds.getDatasetName();
            if (datasetName == null || datasetName.equals("")) {
                tmpBuffer.write(0);
            } else {
                tmpBuffer.write(datasetName.getBytes(charset));
                tmpBuffer.write(0);
            }
            int col = ds.getColumnCount();
            tmpBuffer.write(ByteArrayUtil.intToByteArray_C(col));
            int row = ds.getRowCount();
            tmpBuffer.write(ByteArrayUtil.intToByteArray_C(row));
            tmpBuffer.write(ByteArrayUtil.intToByteArray_C(0));
            tmpBuffer.write(ByteArrayUtil.intToByteArray_C(0));
            int i2 = 1;
            while (i2 <= col) {
                tmpBuffer.write(ds.getColumnName(i2).getBytes(charset));
                tmpBuffer.write(0);
                tmpBuffer.write(ds.getColumnType(i2));
                tmpBuffer.write(ByteArrayUtil.intToByteArray_C(Integer.MAX_VALUE));
                tmpBuffer.write(100);
                ++i2;
            }
            ds.beforeFirst();
            while (ds.hasNext()) {
                ds.next();
                int j2 = 1;
                while (j2 <= col) {
                    String colName = ds.getColumnName(j2);
                    if (ds.getColumnType(j2) == 'R') {
                        byte[] bytes = ds.getByteArray(colName);
                        if (bytes == null) {
                            bytes = new byte[]{};
                        }
                        tmpBuffer.write(ByteArrayUtil.intToByteArray_C(bytes.length));
                        tmpBuffer.write(bytes);
                        tmpBuffer.write(0);
                    } else {
                        String value = ds.getString(colName);
                        if (value != null) {
                            tmpBuffer.write(value.getBytes(charset));
                        }
                        tmpBuffer.write(0);
                    }
                    ++j2;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
        byte[] tmp = tmpBuffer.toByteArray();
        int datasetLen = 0;
        if (datasetName == null) {
            datasetLen = tmp.length - 17;
            ByteArrayUtil.intToByteArray_C(datasetLen, tmp, 9);
        } else {
            datasetLen = tmp.length - datasetName.getBytes().length - 17;
            ByteArrayUtil.intToByteArray_C(datasetLen, tmp, datasetName.getBytes().length + 9);
        }
        return tmp;
    }

    @Override
    public void setDataset(IDataset result) {
        this.dataset = result;
        this.isPack = false;
    }

    @Override
    public void clear() {
        this.data = null;
        this.isPack = false;
        this.dataset = null;
        this.isUnpack = false;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public boolean unPack(byte[] data) {
        block17: {
            this.isUnpack = false;
            this.data = data;
            if (data == null) {
                return false;
            }
            byte version = data[0];
            if (version == 33) break block17;
            return false;
        }
        try {
            int i2 = 1;
            while (i2 < data.length) {
                IDataset ds = DatasetService.getDefaultInstance().getDataset();
                int nameLen = this.findDatasetName(ds, i2);
                int col = ByteArrayUtil.byteArrayToInt_C(data, i2 += nameLen);
                int row = ByteArrayUtil.byteArrayToInt_C(data, i2 += 4);
                int dataSetLen = ByteArrayUtil.byteArrayToInt_C(data, i2 += 4);
                int returnCode = ByteArrayUtil.byteArrayToInt_C(data, i2 += 4);
                i2 += 4;
                int strLen = 0;
                ArrayList<Character> types = new ArrayList<Character>();
                int j2 = 0;
                while (j2 < col) {
                    strLen = this.findStringLen(i2);
                    String colName = null;
                    try {
                        colName = new String(data, i2, strLen - 1, charset);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        colName = new String(data, i2, strLen - 1);
                    }
                    int colType = data[i2 += strLen];
                    int colWidth = ByteArrayUtil.byteArrayToInt_C(data, ++i2);
                    int colScale = ByteArrayUtil.byteToInt(data[i2 += 4]);
                    ++i2;
                    types.add(Character.valueOf((char)colType));
                    if (colType == 67) {
                        colType = 83;
                    } else if (colType == 73) {
                        colType = 76;
                    }
                    ds.addColumn(colName, colType);
                    ++j2;
                }
                int k2 = 1;
                while (k2 <= row) {
                    byte[] temp = null;
                    ds.appendRow();
                    int j3 = 1;
                    while (j3 <= col) {
                        int binLength;
                        char type = ((Character)types.get(j3 - 1)).charValue();
                        if ('R' == type) {
                            binLength = ByteArrayUtil.byteArrayToInt_C(data, i2) + 1;
                            temp = new byte[binLength - 1];
                            System.arraycopy(data, i2 += 4, temp, 0, binLength - 1);
                            i2 += binLength;
                            ds.updateByteArray(j3, temp);
                        } else if ('C' == type) {
                            binLength = 1;
                            temp = new byte[1];
                            System.arraycopy(data, i2, temp, 0, binLength);
                            i2 += 2;
                            ds.updateString(j3, String.valueOf((char)temp[0]));
                        } else {
                            binLength = this.findStringLen(i2);
                            temp = new byte[binLength - 1];
                            System.arraycopy(data, i2, temp, 0, binLength - 1);
                            i2 += binLength;
                            ds.updateString(j3, new String(temp, charset));
                        }
                        ++j3;
                    }
                    ++k2;
                }
                this.dataset = ds;
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return false;
        }
        this.isUnpack = true;
        return this.isUnpack;
    }

    private int findDatasetName(IDataset dataset, int offset) {
        int length = this.findStringLen(offset);
        try {
            dataset.setDatasetName(new String(this.data, offset, length - 1, charset));
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            dataset.setDatasetName(new String(this.data, offset, length - 1));
        }
        return length;
    }

    private int findStringLen(int offset) {
        int length = 0;
        while (this.data[offset + length] != 0) {
            ++length;
        }
        return ++length;
    }

    @Override
    public IDataset getDataset() {
        return this.dataset;
    }
}

