/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.protocol.common.share.util;

import java.util.Date;

public final class ByteArrayUtil {
    public static byte[] intToByteArray_C(int value) {
        byte[] bt = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return bt;
    }

    public static void intToByteArray_C(int value, byte[] bt, int offset) {
        bt[offset] = (byte)(value >> 24 & 0xFF);
        bt[offset + 1] = (byte)(value >> 16 & 0xFF);
        bt[offset + 2] = (byte)(value >> 8 & 0xFF);
        bt[offset + 3] = (byte)(value & 0xFF);
    }

    public static int byteArrayToInt_C(byte[] bts) {
        int value1 = 255;
        int value2 = 255;
        int value3 = 255;
        int value4 = 255;
        value1 = (value1 & bts[0]) * 0x1000000;
        value2 = (value2 & bts[1]) * 65536;
        value3 = (value3 & bts[2]) * 256;
        return value1 + value2 + value3 + (value4 &= bts[3]);
    }

    public static int byteArrayToInt_C(byte[] bts, int offset) {
        int value1 = 255;
        int value2 = 255;
        int value3 = 255;
        int value4 = 255;
        value1 = (value1 & bts[offset]) * 0x1000000;
        value2 = (value2 & bts[offset + 1]) * 65536;
        value3 = (value3 & bts[offset + 2]) * 256;
        return value1 + value2 + value3 + (value4 &= bts[offset + 3]);
    }

    public static byte[] intToByteArray(int v) {
        byte[] b2 = new byte[4];
        int i2 = 0;
        while (i2 < 3) {
            b2[i2] = (byte)(v & 0xFF);
            v >>= 8;
            ++i2;
        }
        b2[3] = (byte)(v & 0xFF);
        return b2;
    }

    public static byte[] charToByteArray(char ch) {
        int temp = ch;
        byte[] b2 = new byte[2];
        int i2 = b2.length - 1;
        while (i2 > -1) {
            b2[i2] = new Integer(temp & 0xFF).byteValue();
            temp >>= 8;
            --i2;
        }
        return b2;
    }

    public static String bytesToString(byte[] b2, int offset, int len) {
        return new String(b2, offset, len);
    }

    public static void intToByteArray(int v, byte[] b2, int offset) {
        int i2 = 0;
        while (i2 < 3) {
            b2[offset + i2] = (byte)(v & 0xFF);
            v >>= 8;
            ++i2;
        }
        b2[offset + 3] = (byte)(v & 0xFF);
    }

    public static int byteArrayToInt(byte[] v, int offset) {
        int r2 = 0;
        int i2 = 3;
        while (i2 >= 1) {
            r2 += ByteArrayUtil.byteToInt(v[offset + i2]);
            r2 <<= 8;
            --i2;
        }
        return r2 += ByteArrayUtil.byteToInt(v[offset + 0]);
    }

    public static char byteArrayToChar(byte[] b2, int offset) {
        int s2 = 0;
        s2 = b2[offset + 0] > 0 ? (s2 += b2[offset + 0]) : (s2 += 256 + b2[offset + 0]);
        s2 *= 256;
        s2 = b2[offset + 1] > 0 ? (s2 += b2[offset + 1]) : (s2 += 256 + b2[offset + 1]);
        char ch = (char)s2;
        return ch;
    }

    public static long byteArrayToUnsignedInt(byte[] v, int offset) {
        long r2 = 0L;
        int i2 = 3;
        while (i2 >= 1) {
            r2 += (long)ByteArrayUtil.byteToInt(v[offset + i2]);
            r2 <<= 8;
            --i2;
        }
        return r2 += (long)ByteArrayUtil.byteToInt(v[offset]);
    }

    public static short byteArrayToUnsignedByte(byte[] v, int offset) {
        return (short)ByteArrayUtil.byteToInt(v[offset]);
    }

    public static int byteArrayToUnsignedShort(byte[] v, int offset) {
        int r2 = ByteArrayUtil.byteToInt(v[offset + 1]);
        r2 <<= 8;
        return r2 += ByteArrayUtil.byteToInt(v[offset]);
    }

    public static byte[] shortToByteArray(short v) {
        byte[] b2 = new byte[2];
        b2[0] = (byte)(v & 0xFF);
        v = (short)(v >> 8);
        b2[1] = (byte)(v & 0xFF);
        return b2;
    }

    public static void shortToByteArray(short v, byte[] b2, int offset) {
        b2[offset + 0] = (byte)(v & 0xFF);
        v = (short)(v >> 8);
        b2[offset + 1] = (byte)(v & 0xFF);
    }

    public static short byteArrayToShort(byte[] v, int offset) {
        short r2 = ByteArrayUtil.byteToShort(v[offset + 1]);
        r2 = (short)(r2 << 8);
        r2 = (short)(r2 + ByteArrayUtil.byteToShort(v[offset + 0]));
        if (v[offset + 1] >> 7 == -1) {
            r2 = (short)(r2 - 65536);
        }
        return r2;
    }

    public static byte[] longToByteArray(long v) {
        byte[] b2 = new byte[8];
        int i2 = 0;
        while (i2 < 7) {
            b2[i2] = (byte)(v & 0xFFL);
            v >>= 8;
            ++i2;
        }
        b2[7] = (byte)(v & 0xFFL);
        return b2;
    }

    public static void longToByteArray(long v, byte[] b2, int offset) {
        int i2 = 0;
        while (i2 < 7) {
            b2[offset + i2] = (byte)(v & 0xFFL);
            v >>= 8;
            ++i2;
        }
        b2[offset + 7] = (byte)(v & 0xFFL);
    }

    public static long byteArrayToLong(byte[] v, int offset) {
        long r2 = 0L;
        int i2 = 7;
        while (i2 >= 1) {
            r2 += (long)ByteArrayUtil.byteToInt(v[offset + i2]);
            r2 <<= 8;
            --i2;
        }
        return (r2 += (long)ByteArrayUtil.byteToInt(v[offset + 0])) & 0xFFFFFFFFL;
    }

    public static double byteArrayToDouble(byte[] v, int offset) {
        return Double.longBitsToDouble(ByteArrayUtil.byteArrayToLong(v, offset));
    }

    public static byte[] doubleToByteArray(double doubleValue) {
        return ByteArrayUtil.longToByteArray(Double.doubleToLongBits(doubleValue));
    }

    static void doubleToByteArray(double doubleValue, byte[] b2, int offset) {
        ByteArrayUtil.longToByteArray(Double.doubleToLongBits(doubleValue), b2, offset);
    }

    public static Date byteArrayToDate(byte[] v, int offset) {
        return new Date(ByteArrayUtil.byteArrayToLong(v, offset));
    }

    public static byte[] dateToByteArray(Date date) {
        return ByteArrayUtil.longToByteArray(date.getTime());
    }

    static void dateToByteArray(Date date, byte[] b2, int offset) {
        ByteArrayUtil.longToByteArray(date.getTime(), b2, offset);
    }

    public static float byteArrayToFloat(byte[] v, int offset) {
        return Float.intBitsToFloat(ByteArrayUtil.byteArrayToInt(v, offset));
    }

    public static byte[] floatToByteArray(float floatValue) {
        return ByteArrayUtil.intToByteArray(Float.floatToIntBits(floatValue));
    }

    static void floatToByteArray(float floatValue, byte[] b2, int offset) {
        ByteArrayUtil.intToByteArray(Float.floatToIntBits(floatValue), b2, offset);
    }

    public static short byteToShort(byte b2) {
        short r2 = b2;
        if (b2 < 0) {
            r2 = (short)(r2 + 256);
        }
        return r2;
    }

    public static int byteToInt(byte b2) {
        int r2 = b2;
        if (b2 < 0) {
            r2 += 256;
        }
        return r2;
    }
}

