/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.protocol.common.share.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexMap<T> {
    private List<T> values = new ArrayList<T>();
    private Map<String, Integer> mapping = new HashMap<String, Integer>();

    public void put(String name, T t2) {
        Integer index = this.mapping.get(name);
        if (index != null) {
            this.values.set(index, t2);
        } else {
            this.values.add(t2);
            this.mapping.put(name, this.values.size() - 1);
        }
    }

    public T remove(String name) {
        Integer index = this.mapping.remove(name);
        if (index != null) {
            T v = this.values.get(index);
            this.values.remove(index);
            return v;
        }
        return null;
    }

    public T get(String name) {
        Integer index = this.mapping.get(name);
        if (index != null) {
            return this.values.get(index);
        }
        return null;
    }

    public T get(int index) {
        return this.values.get(index);
    }

    public int getNameIndex(String name) {
        Integer index = this.mapping.get(name);
        if (index != null) {
            return index;
        }
        return -1;
    }

    public int size() {
        return this.mapping.size();
    }

    public void clear() {
        this.values.clear();
        this.mapping.clear();
    }

    public List<T> getValues() {
        return this.values;
    }

    public Map<String, Integer> getMapping() {
        return this.mapping;
    }
}

