/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.protocol.interfaces.exception;

import com.kinkaid.acs.protocol.interfaces.exception.ErrorFormatter;
import com.kinkaid.acs.protocol.interfaces.exception.ISDKBaseErrorMessage;

public class BaseRuntimeException
extends RuntimeException
implements ISDKBaseErrorMessage {
    private static final long serialVersionUID = 1L;
    protected String errorNo;
    protected String message;

    public BaseRuntimeException() {
    }

    public BaseRuntimeException(String message) {
        super(message);
        this.errorNo = "0";
        this.message = message;
    }

    public BaseRuntimeException(Throwable cause, String message) {
        super(cause);
        this.errorNo = "0";
        this.message = ErrorFormatter.format(this.errorNo, message);
    }

    public BaseRuntimeException(String errorNo, String message) {
        super(message);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, message);
    }

    public BaseRuntimeException(String errorNo, String message, Throwable cause) {
        super(cause);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, message);
    }

    public BaseRuntimeException(String errorNo, Throwable cause, Object ... messages) {
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, messages);
    }

    @Override
    public String getErrorNo() {
        return this.errorNo;
    }

    @Override
    public String getMessage() {
        return "[" + this.errorNo + "] " + this.message;
    }

    @Override
    public String getErrorMessage() {
        return this.message;
    }

    public void setErrorNo(String errorNo) {
        this.errorNo = errorNo;
    }

    public void setErrorMessage(String message) {
        this.message = message;
    }
}

