/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.protocol.interfaces.exception;

import com.kinkaid.acs.protocol.interfaces.exception.ErrorFormatter;
import com.kinkaid.acs.protocol.interfaces.exception.ISDKBaseErrorMessage;

public class SDKBaseException
extends Exception
implements ISDKBaseErrorMessage {
    private static final long serialVersionUID = 1L;
    protected String errorNo;
    protected String message;

    public SDKBaseException() {
    }

    public SDKBaseException(String message) {
        super(message);
        this.errorNo = "0";
        this.message = message;
    }

    public SDKBaseException(Throwable cause, String message) {
        super(cause);
        this.errorNo = "0";
        this.message = ErrorFormatter.format(this.errorNo, message);
    }

    public SDKBaseException(String errorNo, String message) {
        super(message);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, message);
    }

    public SDKBaseException(String errorNo, String message, Throwable cause) {
        super(cause);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, message);
    }

    public SDKBaseException(String errorNo, Throwable cause, Object ... messages) {
        super(cause);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, messages);
    }

    @Override
    public String getErrorNo() {
        return this.errorNo;
    }

    @Override
    public String getMessage() {
        return "[" + this.errorNo + "] " + this.message;
    }

    @Override
    public String getErrorMessage() {
        return this.getMessage();
    }

    public void setErrorNo(String errorNo) {
        this.errorNo = errorNo;
    }

    public void setErrorMessage(String message) {
        this.message = message;
    }
}

