/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.sdk.common.event;

import android.util.Log;
import com.kinkaid.acs.protocol.common.share.event.PackService;
import com.kinkaid.acs.protocol.common.share.util.ByteArrayStream;
import com.kinkaid.acs.protocol.common.share.util.DataGetter;
import com.kinkaid.acs.protocol.common.share.util.EventUtils;
import com.kinkaid.acs.protocol.interfaces.share.dataset.IDataset;
import com.kinkaid.acs.protocol.interfaces.share.event.IPack;
import com.kinkaid.acs.protocol.interfaces.share.exception.DatasetRuntimeException;
import com.kinkaid.acs.sdk.common.util.ZlibTool;
import com.kinkaid.acs.sdk.interfaces.event.INetworkEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonEvent
implements INetworkEvent {
    public static String DEFAULT_MSGBODY_CHARSET = "GBK";
    public static String EVENTCHARSET = "UTF-8";
    private static final char SPLIT = '\u0000';
    private static final char EQUAL = '=';
    protected Map<String, Object> allTags = new HashMap<String, Object>();
    protected Map<String, Character> map2Type = new HashMap<String, Character>();
    protected List<String> vecTags = new ArrayList<String>();
    private IDataset mDataset = null;
    private int mEventTimeOut = 0;

    public CommonEvent() {
        long eventId = EventUtils.getInstance().generateEventNo();
        this.setLongAttributeValue("11", eventId);
        this.setIntegerAttributeValue("13", 8);
    }

    @Override
    public int getEventType() {
        int eventType = this.getIntegerAttributeValue("3");
        return eventType;
    }

    @Override
    public byte[] getByteArrayAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null && type.charValue() == 'R') {
            return (byte[])this.allTags.get(tagName);
        }
        return null;
    }

    @Override
    public String getErrorInfo() {
        String errorInfo = this.getStringAttributeValue("20");
        return errorInfo;
    }

    @Override
    public int getIntegerAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null && (type.charValue() == 'I' || type.charValue() == 'S')) {
            try {
                return Integer.valueOf(this.allTags.get(tagName).toString());
            }
            catch (Exception e2) {
                throw new DatasetRuntimeException(e2.getMessage(), new Object[]{e2});
            }
        }
        return 0;
    }

    @Override
    public long getLongAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null && (type.charValue() == 'I' || type.charValue() == 'S')) {
            try {
                return Long.valueOf(this.allTags.get(tagName).toString());
            }
            catch (Exception e2) {
                throw new DatasetRuntimeException(e2.getMessage(), new Object[]{e2});
            }
        }
        return 0L;
    }

    @Override
    public int getReturnCode() {
        return this.getIntegerAttributeValue("7");
    }

    @Override
    public String[] getStringArrayAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null && type.charValue() == 'A') {
            try {
                return (String[])this.allTags.get(tagName);
            }
            catch (Exception e2) {
                throw new DatasetRuntimeException(e2.getMessage(), new Object[]{e2});
            }
        }
        return null;
    }

    @Override
    public String getStringAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null) {
            Object tag;
            block4: {
                try {
                    tag = this.allTags.get(tagName);
                    if (tag != null) break block4;
                    return null;
                }
                catch (Exception e2) {
                    throw new DatasetRuntimeException(e2.getMessage(), new Object[]{e2});
                }
            }
            return tag.toString();
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String tagName) {
        int index = this.vecTags.indexOf(tagName);
        return index != -1;
    }

    @Override
    public void setByteArrayAttributeValue(String tagName, byte[] value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'R') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('R'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void setIntegerAttributeValue(String tagName, int value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'I') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('I'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void setLongAttributeValue(String tagName, long value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'I') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('I'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void setStringArrayAttributeValue(String tagName, String[] value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'A') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('A'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void setStringAttributeValue(String tagName, String value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'S') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('S'));
        this.allTags.put(tagName, value);
    }

    @Override
    public <T> T getAttributeValue(String tagName) {
        return (T)this.allTags.get(tagName);
    }

    @Override
    public void setAttributeValue(String tagName, Object value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'U') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('U'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void removeAttribute(String name) {
        int index = this.vecTags.indexOf(name);
        if (index >= 0) {
            this.vecTags.remove(index);
            this.map2Type.remove(name);
            this.allTags.remove(name);
        }
    }

    @Override
    public void setReturnCode(int returnCode) {
        this.setIntegerAttributeValue("7", returnCode);
    }

    @Override
    public int getAttributeCount() {
        return this.vecTags.size();
    }

    @Override
    public String getAttributeName(int index) {
        return this.vecTags.get(index);
    }

    @Override
    public char getAttributeType(String name) {
        Character type = this.map2Type.get(name);
        if (type != null) {
            return type.charValue();
        }
        return '\u0000';
    }

    @Override
    public void setErrorCode(String errorNo, String errorInfo) {
        Integer returnCode;
        if (!this.hasAttribute("7") && (returnCode = (Integer)this.getAttributeValue("7")) != null && returnCode == 0) {
            this.setIntegerAttributeValue("7", -1);
        }
        this.setStringAttributeValue("19", errorNo);
        this.setStringAttributeValue("20", errorInfo);
    }

    @Override
    public String getErrorNo() {
        String errorNo;
        char type = this.getAttributeType("19");
        if ('I' == type) {
            return "" + this.getIntegerAttributeValue("19");
        }
        if ('S' == type && (errorNo = this.getStringAttributeValue("19")) != null) {
            return errorNo;
        }
        return "0";
    }

    @Override
    public void setEventType(int type) {
        this.setIntegerAttributeValue("3", type);
    }

    @Override
    public void addTimestamp(long time, String timestampInfo) {
        if (this.isTimestampOn()) {
            String[] stamps = this.getStringArrayAttributeValue("52");
            if (stamps == null) {
                stamps = new String[]{};
            }
            if (stamps != null) {
                int length = stamps.length;
                String[] newStamps = new String[length + 1];
                System.arraycopy(stamps, 0, newStamps, 0, length);
                StringBuffer sb = new StringBuffer(512);
                sb.append(time);
                sb.append('\u0000');
                sb.append(timestampInfo);
                newStamps[length] = sb.toString();
                this.setStringArrayAttributeValue("52", newStamps);
            }
        }
    }

    @Override
    public String[] getTimestamp() {
        if (this.isTimestampOn()) {
            return this.getStringArrayAttributeValue("52");
        }
        return new String[0];
    }

    @Override
    public boolean isTimestampOn() {
        return this.hasAttribute("52");
    }

    @Override
    public void markTimestamp(boolean on) {
        if (!this.isTimestampOn() && on) {
            this.setStringArrayAttributeValue("52", new String[0]);
        } else if (this.isTimestampOn() && !on) {
            this.removeAttribute("52");
        }
    }

    @Override
    public int getEventId() {
        return this.getIntegerAttributeValue("11");
    }

    @Override
    public int getFunctionId() {
        return this.getIntegerAttributeValue("5");
    }

    @Override
    public byte[] getMessageBody() {
        byte[] msgbody = this.getByteArrayAttributeValue("8");
        return msgbody;
    }

    @Override
    public int getSafeType() {
        return this.getIntegerAttributeValue("18");
    }

    @Override
    public int getSenderId() {
        return this.getIntegerAttributeValue("12");
    }

    @Override
    public int getSubSystemNo() {
        return this.getIntegerAttributeValue("4");
    }

    @Override
    public void setFunctionId(int funcId) {
        this.setIntegerAttributeValue("5", funcId);
    }

    @Override
    public void setSafeType(int safeType) {
        this.setIntegerAttributeValue("18", safeType);
    }

    @Override
    public void setSenderId(int senderId) {
        this.setIntegerAttributeValue("12", senderId);
    }

    @Override
    public void setSubSystemNo(int subNo) {
        this.setIntegerAttributeValue("4", subNo);
    }

    @Override
    public int changeToresponse() {
        int eventType = this.getIntegerAttributeValue("3");
        if (eventType == 2) {
            eventType = 3;
        } else if (eventType == 0) {
            eventType = 1;
        } else {
            return 1;
        }
        this.setIntegerAttributeValue("3", eventType);
        this.mDataset = null;
        return 0;
    }

    public static void main(String[] args) {
        String.format("", 22);
        System.out.println(System.nanoTime());
        StringBuffer sb = new StringBuffer(512);
        sb.append(123456789);
        sb.append('\u0000');
        sb.append("\u65f6\u95f4\u6233");
        System.out.println(sb.toString());
        CommonEvent event = new CommonEvent();
        event.addTimestamp(System.nanoTime(), "no effective");
        String[] ss = event.getTimestamp();
        long start = System.nanoTime();
        event.markTimestamp(true);
        event.addTimestamp(System.nanoTime(), "1");
        event.addTimestamp(System.nanoTime(), "2");
        event.addTimestamp(System.nanoTime(), "3");
        ss = event.getTimestamp();
        System.out.println(System.nanoTime() - start);
        event.markTimestamp(false);
        ss = event.getTimestamp();
        System.out.println("00" + ss);
        System.out.println();
        StackTraceElement[] dd = Thread.currentThread().getStackTrace();
        int i2 = 0;
        while (i2 < dd.length) {
            System.out.println(dd[i2].toString());
            ++i2;
        }
    }

    @Override
    public void setMsgBody(byte[] data) {
        this.setByteArrayAttributeValue("8", data);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean unpackAllTags(byte[] data, int index, String charset) throws UnsupportedEncodingException {
        if (data != null) ** GOTO lbl40
        return false;
lbl-1000:
        // 1 sources

        {
            tagName = this.findTagName(data, index = this.findEquIndex(data, index), charset);
            if ("1".equals(tagName)) {
                len = this.findStrLen(data, index);
                byteLength = Integer.parseInt(new String(this.findStrData(data, index, len)));
                index += len + 1;
                index = this.findEquIndex(data, index);
                byteTagName = this.findTagName(data, index, charset);
                tmp = new byte[byteLength];
                System.arraycopy(data, index + 1, tmp, 0, byteLength);
                this.setByteArrayAttributeValue(byteTagName, tmp);
                index += byteLength + 2;
                continue;
            }
            if ("2".equals(tagName)) {
                len = this.findStrLen(data, index);
                arrayLength = Integer.parseInt(new String(this.findStrData(data, index, len)));
                index += len + 1;
                index = this.findEquIndex(data, index);
                arrayTagName = this.findTagName(data, index, charset);
                tmp = this.getArrayByte(data, index, arrayLength);
                data1 = new String(tmp, charset);
                array = data1.split("\u0000");
                if (array.length != arrayLength) {
                    newArray = new String[array.length + 1];
                    i = 0;
                    while (i < array.length) {
                        newArray[i] = array[i];
                        ++i;
                    }
                    array = newArray;
                    newArray = null;
                }
                this.setStringArrayAttributeValue(arrayTagName, array);
                index += tmp.length + 1;
                continue;
            }
            len = this.findStrLen(data, index);
            value = new String(this.findStrData(data, index, len), charset);
            this.setStringAttributeValue(tagName, value);
            index += len + 1;
lbl40:
            // 4 sources

            ** while (index < data.length)
        }
lbl41:
        // 1 sources

        compress = this.getStringAttributeValue("43");
        if (compress != null && (bin = this.getByteArrayAttributeValue("8")) != null) {
            try {
                bin = ZlibTool.unzip(bin);
                this.setByteArrayAttributeValue("8", bin);
            }
            catch (Exception e) {
                Log.e((String)"Event unpack()", (String)"decompreess error");
            }
        }
        return true;
    }

    private int findEquIndex(byte[] data, int offset) {
        int index = offset;
        while (index < data.length) {
            if (data[index] == 61) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int findStrLen(byte[] data, int offset) {
        int index = offset + 1;
        while (index < data.length) {
            if (data[index] == 0) break;
            ++index;
        }
        return index - offset;
    }

    private byte[] findStrData(byte[] data, int offset, int length) {
        if (data[offset + length] == 0) {
            byte[] tmp = new byte[length - 1];
            System.arraycopy(data, offset + 1, tmp, 0, length - 1);
            return tmp;
        }
        byte[] tmp = new byte[length];
        System.arraycopy(data, offset + 1, tmp, 0, length);
        return tmp;
    }

    private String findTagName(byte[] data, int offset, String charset) {
        int index = offset - 1;
        while (index >= 0) {
            if (data[index] == 0) break;
            --index;
        }
        if (index != 0) {
            byte[] tmp = new byte[offset - index - 1];
            System.arraycopy(data, index + 1, tmp, 0, offset - index - 1);
            try {
                return new String(tmp, charset);
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
                return new String(tmp);
            }
        }
        byte[] tmp = new byte[offset];
        System.arraycopy(data, 0, tmp, 0, offset);
        try {
            return new String(tmp, charset);
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
            return new String(tmp);
        }
    }

    private byte[] getArrayByte(byte[] data, int offset, int count) {
        int length = 0;
        int tmpOffset = offset;
        int i2 = 0;
        while (i2 < count) {
            tmpOffset = offset + (length += this.findStrLen(data, tmpOffset));
            ++i2;
        }
        byte[] tmp = new byte[length];
        System.arraycopy(data, offset + 1, tmp, 0, length);
        return tmp;
    }

    public byte[] packAllAttributes(String charset) throws Exception {
        if (this.mDataset != null) {
            IPack pack = PackService.getPacker(1);
            pack.setDataset(this.mDataset);
            byte[] messagebody = pack.Pack();
            this.setByteArrayAttributeValue("8", messagebody);
        }
        ByteArrayStream tagBuffer = new ByteArrayStream(200);
        this.packStringTags(tagBuffer, charset);
        this.packStringArrayTags(tagBuffer, charset);
        this.packByteArrayTags(tagBuffer, charset);
        byte[] buff = tagBuffer.toByteArray();
        return buff;
    }

    protected void packStringTags(ByteArrayStream outStream, String charset) throws UnsupportedEncodingException, IOException {
        int inStart = 100;
        int inEnd = 199;
        int size = this.vecTags.size();
        int i2 = 0;
        while (i2 < size) {
            int tag;
            String tagName = this.vecTags.get(i2);
            Character c2 = this.map2Type.get(tagName);
            if (c2.charValue() != 'A' && c2.charValue() != 'R' && ((tag = DataGetter.getInt(tagName, -1)) <= inStart || tag >= inEnd) && tag >= 0) {
                String value = String.valueOf(this.allTags.get(tagName));
                outStream.write(tagName.getBytes(charset));
                outStream.write(61);
                if (value != null) {
                    outStream.write(value.getBytes(charset));
                }
                outStream.write(0);
            }
            ++i2;
        }
    }

    protected void packStringArrayTags(ByteArrayStream outStream, String charset) throws Exception {
        int inStart = 100;
        int inEnd = 199;
        int size = this.vecTags.size();
        int i2 = 0;
        while (i2 < size) {
            String[] value;
            Character c2;
            String tagName = this.vecTags.get(i2);
            int tag = DataGetter.getInt(tagName, -1);
            if ((tag <= inStart || tag >= inEnd) && tag >= 0 && (c2 = this.map2Type.get(tagName)).charValue() == 'A' && (value = (String[])this.allTags.get(tagName)) != null) {
                outStream.write("2".getBytes());
                outStream.write(61);
                outStream.write(String.valueOf(value.length).getBytes());
                outStream.write(0);
                outStream.write(tagName.getBytes(charset));
                outStream.write(61);
                int j2 = 0;
                while (j2 < value.length) {
                    if (value[j2] != null && !"".equals(value[j2])) {
                        outStream.write(value[j2].getBytes(charset));
                    }
                    outStream.write(0);
                    ++j2;
                }
            }
            ++i2;
        }
    }

    protected void packByteArrayTags(ByteArrayStream outStream, String charset) throws Exception {
        int inStart = 100;
        int inEnd = 199;
        int size = this.vecTags.size();
        int i2 = 0;
        while (i2 < size) {
            Character c2;
            String tagName = this.vecTags.get(i2);
            int tag = DataGetter.getInt(tagName, -1);
            if ((tag <= inStart || tag >= inEnd) && tag >= 0 && (c2 = this.map2Type.get(tagName)).charValue() == 'R') {
                byte[] value = (byte[])this.allTags.get(tagName);
                outStream.write("1".getBytes());
                outStream.write(61);
                outStream.write(String.valueOf(value.length).getBytes());
                outStream.write(0);
                outStream.write(tagName.getBytes(charset));
                outStream.write(61);
                outStream.write(value);
                outStream.write(0);
            }
            ++i2;
        }
    }

    @Override
    public byte[] pack() throws Exception {
        return this.packAllAttributes(EVENTCHARSET);
    }

    @Override
    public void unpack(byte[] data, int offset) throws UnsupportedEncodingException {
        this.unpackAllTags(data, offset, EVENTCHARSET);
    }

    @Override
    public void setPriority(int priority) {
        this.setIntegerAttributeValue("13", priority);
    }

    @Override
    public int getEventTimeOut() {
        return this.mEventTimeOut;
    }

    @Override
    public void setEventTimeOut(int time) {
        if (time > 0) {
            this.mEventTimeOut = time;
        }
    }

    @Override
    public void setDataset(IDataset dataset) {
        this.mDataset = dataset;
    }

    @Override
    public IDataset getDataset() {
        IPack pack = PackService.getPacker(1);
        byte[] bytes = this.getMessageBody();
        if (bytes == null) {
            return null;
        }
        pack.unPack(bytes);
        return pack.getDataset();
    }
}

