/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.sdk.common.net;

import android.os.Handler;
import android.util.Log;
import com.kinkaid.acs.protocol.interfaces.share.event.IEvent;
import com.kinkaid.acs.sdk.common.config.NetworkAddr;
import com.kinkaid.acs.sdk.common.config.SdkConfig;
import com.kinkaid.acs.sdk.common.event.EventFactory;
import com.kinkaid.acs.sdk.common.net.NetworkListenerImpl;
import com.kinkaid.acs.sdk.common.util.NetworkUtils;
import com.kinkaid.acs.sdk.impl.net.HttpChannel;
import com.kinkaid.acs.sdk.impl.net.HttpsChannel;
import com.kinkaid.acs.sdk.impl.net.NetChannel;
import com.kinkaid.acs.sdk.impl.net.SslChannel;
import com.kinkaid.acs.sdk.interfaces.error.ErrorUtils;
import com.kinkaid.acs.sdk.interfaces.event.INetworkEvent;
import com.kinkaid.acs.sdk.interfaces.exception.NetworkException;
import com.kinkaid.acs.sdk.interfaces.net.INetworkService;
import com.kinkaid.acs.sdk.interfaces.net.NetworkConnection;
import com.kinkaid.acs.sdk.interfaces.net.NetworkListener;
import com.kinkaid.acs.sdk.interfaces.net.NetworkStatusListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NetworkService
implements INetworkService {
    public static final String TAG = "NetworkService";
    private static final byte[] KEEPALIVE_PACKET;
    private static final byte[] KEEPALIVE_PACKET_ANSWER;
    public int reconnectCount = 10;
    private byte[] lock = new byte[0];
    private String mToken = null;
    private NetworkConnection mConnection = null;
    private int mConnType = 1;
    private LinkedList<NetworkListener> mAutoLsnList = null;
    private LinkedList<NetEventKey> mLsnKeyList = null;
    private List<NetworkAddr> mAddrs = new ArrayList<NetworkAddr>();
    private int mAddrIndex = 0;
    private int mCloseCount = 0;
    private int enable = -101;
    protected NetworkListener mCurListener = null;
    protected NetworkStatusListener mNetWorkStatusListener = null;
    private long mLastSendedTime = System.currentTimeMillis();
    private long mLastReceviedTime = System.currentTimeMillis();
    private long sendFlux;
    private long recieveFlux;
    private long totalFlux;

    static {
        byte[] byArray = new byte[13];
        byArray[0] = 9;
        byArray[3] = 9;
        byArray[4] = 53;
        byArray[5] = 61;
        byArray[6] = 51;
        byArray[7] = 51;
        byArray[9] = 51;
        byArray[10] = 61;
        byArray[11] = 50;
        KEEPALIVE_PACKET = byArray;
        byte[] byArray2 = new byte[13];
        byArray2[0] = 9;
        byArray2[3] = 9;
        byArray2[4] = 53;
        byArray2[5] = 61;
        byArray2[6] = 51;
        byArray2[7] = 51;
        byArray2[9] = 51;
        byArray2[10] = 61;
        byArray2[11] = 51;
        KEEPALIVE_PACKET_ANSWER = byArray2;
    }

    public NetworkService() {
        this.mAutoLsnList = new LinkedList();
        this.mLsnKeyList = new LinkedList();
        this.reconnectCount = SdkConfig.getInstance().getReconnectCount();
    }

    @Override
    public void onResponse(byte[] data, int offset) {
        if (data == null) {
            return;
        }
        try {
            INetworkEvent event = EventFactory.getEvent();
            IEvent ie = (IEvent)IEvent.class.cast(event);
            ie.unpack(data, 0);
            this.onEventRes(event);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void onEventRes(INetworkEvent event) {
        if (event.getFunctionId() == Integer.parseInt("33")) {
            this.mLastReceviedTime = System.currentTimeMillis();
            if (event.getEventType() == Integer.parseInt("2")) {
                this.mConnection.send(KEEPALIVE_PACKET_ANSWER);
            }
            return;
        }
        String token = event.getStringAttributeValue("31");
        if (token != null) {
            this.mToken = token;
        }
        NetEventKey key = this.getEventKey(event.getEventId());
        if (event.getReturnCode() == 0) {
            this.mLastReceviedTime = System.currentTimeMillis();
        }
        if (key == null) {
            if (event.getEventId() == 0 && event.getSenderId() == 0) {
                for (NetworkListener item : this.mAutoLsnList) {
                    item.onNetResponse(event);
                }
            } else {
                Log.e((String)TAG, (String)"not exists listener");
            }
        } else {
            key.mBack = true;
            key.mListener.onNetResponse(event);
        }
    }

    private NetEventKey getEventKey(int eventId) {
        NetEventKey ret = null;
        if (this.mLsnKeyList.size() != 0) {
            NetEventKey temp = this.mLsnKeyList.getFirst();
            int t2 = eventId - temp.mId;
            if (this.mLsnKeyList.size() > t2 && t2 > 0) {
                temp = this.mLsnKeyList.get(t2);
                if (temp.mId != eventId) {
                    for (NetEventKey key : this.mLsnKeyList) {
                        if (key.mId != eventId) continue;
                        ret = key;
                        break;
                    }
                } else {
                    ret = temp;
                }
            } else if (eventId != 0) {
                for (NetEventKey key : this.mLsnKeyList) {
                    if (key.mId != eventId) continue;
                    ret = key;
                    break;
                }
            }
        }
        if (ret != null) {
            this.mLsnKeyList.remove(ret);
        }
        return ret;
    }

    @Override
    public void establishConnection() throws NetworkException {
        this.setAddrIndex(0);
        this.establish();
    }

    private synchronized void establish() {
        if (this.enable()) {
            return;
        }
        switch (this.mConnType) {
            case 1: {
                this.mConnection = new NetChannel(this);
                break;
            }
            case 2: {
                this.mConnection = new HttpsChannel(this);
                break;
            }
            case 0: {
                this.mConnection = new HttpChannel(this);
                break;
            }
            case 3: {
                this.mConnection = new SslChannel(this);
            }
        }
        this.mConnection.openConnection(this.mAddrs.get(this.mAddrIndex));
        this.enable = 0;
    }

    public boolean enable() {
        return this.enable == 0;
    }

    @Override
    public void establishConnection(int type) throws NetworkException {
        this.setNetworkType(type);
        this.setAddrIndex(0);
        this.establish();
    }

    @Override
    public void establishConnection(int type, int index) throws NetworkException {
        this.setNetworkType(type);
        this.setAddrIndex(index);
        this.establish();
    }

    @Override
    public void setNetworkType(int type) throws NetworkException {
        if (type < 0 || type > 3) {
            throw new NetworkException("not support this Connection type: " + type);
        }
        this.mConnType = type;
    }

    @Override
    public void setAddrIndex(int dx) throws NetworkException {
        if (dx < 0 || dx >= this.mAddrs.size()) {
            throw new NetworkException("dx out of list size " + dx);
        }
        this.mAddrIndex = dx;
    }

    private void sendEvent(INetworkEvent event) {
        event.setStringAttributeValue("31", this.mToken);
        event.setStringAttributeValue("32", SdkConfig.getInstance().getClientType());
        if (this.mConnection != null) {
            if (!this.enable()) {
                INetworkEvent event2 = EventFactory.getEvent();
                event2.setSenderId(event.getSenderId());
                event2.setFunctionId(event.getFunctionId());
                event2.setSubSystemNo(event.getSubSystemNo());
                IEvent te = (IEvent)IEvent.class.cast(event2);
                te.changeToresponse();
                te.setIntegerAttributeValue("11", event.getEventId());
                te.setReturnCode(-1);
                te.setErrorCode(String.valueOf(this.enable), ErrorUtils.getErrorInfoByNo(this.enable));
                this.onEventRes(event2);
                return;
            }
            this.mCloseCount = 0;
            this.mConnection.send(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.enable = -101;
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.mConnection != null) {
                this.mConnection.closeConnection();
                this.mConnection = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClosed() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.mConnection != null) {
                if (!NetworkUtils.isNetworkAvailable()) {
                    this.mConnection.clearSendQueue();
                    this.onError(-104, ErrorUtils.getErrorInfoByNo(-104));
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (this.mNetWorkStatusListener != null) {
                    this.mNetWorkStatusListener.onClose(this);
                }
                if (this.enable()) {
                    this.mConnection.clearSendQueue();
                    this.onError(-103, ErrorUtils.getErrorInfoByNo(-103));
                    ++this.mCloseCount;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect(boolean success) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.mConnection != null) {
                if (!NetworkUtils.isNetworkAvailable()) {
                    if (this.mConnection != null) {
                        this.mConnection.clearSendQueue();
                    }
                    this.onError(-104, ErrorUtils.getErrorInfoByNo(-104));
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                if (this.mNetWorkStatusListener != null) {
                    this.mNetWorkStatusListener.onConnect(this, success);
                }
                if (success) {
                    this.mCloseCount = 0;
                } else {
                    ++this.mCloseCount;
                    this.mConnection.setNetworkAddr(this.getNextAddr());
                    if (this.mCloseCount <= this.reconnectCount) {
                        this.mConnection.reconnect();
                    } else {
                        this.mConnection.clearSendQueue();
                        this.onError(-105, ErrorUtils.getErrorInfoByNo(-105));
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void onError(int errorNo, String errorInfo) {
        int size = this.mLsnKeyList.size();
        if (size == 0) {
            return;
        }
        NetEventKey key = this.mLsnKeyList.get(0);
        INetworkEvent event = EventFactory.getEvent();
        IEvent e2 = (IEvent)IEvent.class.cast(event);
        e2.setReturnCode(1);
        e2.setErrorCode(String.valueOf(errorNo), errorInfo);
        key.mListener.onNetResponse(event);
        this.mLsnKeyList.clear();
    }

    private NetworkAddr getNextAddr() {
        NetworkAddr addr = null;
        int r2 = this.mAddrs.size() + 1;
        int i2 = 1;
        while (i2 < r2) {
            int n2 = i2 + this.mAddrIndex;
            if (n2 > this.mAddrs.size()) {
                n2 -= this.mAddrs.size();
            }
            addr = this.mAddrs.get(n2 - 1);
            ++i2;
        }
        return addr;
    }

    @Override
    public List<NetworkAddr> getNetworkList() {
        return this.mAddrs;
    }

    @Override
    public void postEvent(INetworkEvent event) {
        this.setNetworkListener(this.mCurListener, event);
        this.sendEvent(event);
    }

    @Override
    public void postEvent(INetworkEvent event, Handler handler) {
        NetworkListenerImpl listener = new NetworkListenerImpl();
        listener.setHandler(handler);
        this.setNetworkListener(listener, event);
        this.sendEvent(event);
    }

    @Override
    public void postEvent(INetworkEvent event, NetworkListener listener) {
        this.setNetworkListener(listener, event);
        this.sendEvent(event);
    }

    @Override
    public void setNetworkListener(NetworkListener listener, INetworkEvent event) {
        NetEventKey key = new NetEventKey();
        key.mEventTimeOut = event.getEventTimeOut();
        key.mId = event.getEventId();
        key.mListener = listener;
        this.mLsnKeyList.add(key);
    }

    @Override
    public void addNetworkAddr(NetworkAddr addr) {
        this.mAddrs.add(addr);
    }

    @Override
    public void setNetworkAddrList(List<NetworkAddr> list) {
        this.mAddrs = list;
    }

    @Override
    public void onError(int packetId, int responseCode, String responseMessage) {
        if (packetId == 0) {
            return;
        }
        INetworkEvent event = EventFactory.getEvent();
        IEvent e2 = (IEvent)IEvent.class.cast(event);
        e2.setReturnCode(responseCode);
        e2.setIntegerAttributeValue("11", packetId);
        e2.setErrorCode(String.valueOf(responseCode), responseMessage);
        NetEventKey key = this.getEventKey(packetId);
        if (key != null) {
            key.mBack = true;
            key.mListener.onNetResponse(event);
        }
    }

    @Override
    public void setNetworkListener(NetworkListener listener) {
        this.mCurListener = listener;
    }

    @Override
    public void removePushNetworkListener(NetworkListener listener) {
        this.mAutoLsnList.remove(listener);
    }

    @Override
    public void addPushNetworkListener(NetworkListener listener) {
        if (this.mAutoLsnList.size() == SdkConfig.getInstance().getPushListenerSize()) {
            this.mAutoLsnList.removeLast();
        }
        this.mAutoLsnList.addFirst(listener);
    }

    @Override
    public void clearPushNetworkListener() {
        if (this.mAutoLsnList != null) {
            this.mAutoLsnList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onTimeOut() {
        if (this.mConnection == null) return;
        long curTime = System.currentTimeMillis();
        int size = this.mLsnKeyList.size();
        int i2 = 0;
        while (i2 < size) {
            IEvent e2;
            INetworkEvent event;
            NetEventKey key = this.mLsnKeyList.get(i2);
            if (key == null) {
                return;
            }
            long t2 = curTime - key.regeistTime;
            if (key.mEventTimeOut != 0) {
                if (t2 > (long)key.mEventTimeOut) {
                    this.mLsnKeyList.remove(key);
                    --i2;
                    --size;
                    if (!key.mBack) {
                        event = EventFactory.getEvent();
                        e2 = (IEvent)IEvent.class.cast(event);
                        e2.setReturnCode(1);
                        e2.setIntegerAttributeValue("11", key.mId);
                        e2.setErrorCode("-102", ErrorUtils.getErrorInfoByNo(-102));
                        key.mListener.onNetResponse(event);
                    }
                }
            } else {
                if (t2 <= (long)SdkConfig.getInstance().getSoTimeOut()) break;
                this.mLsnKeyList.remove(key);
                --i2;
                --size;
                if (!key.mBack) {
                    event = EventFactory.getEvent();
                    e2 = (IEvent)IEvent.class.cast(event);
                    e2.setReturnCode(1);
                    e2.setIntegerAttributeValue("11", key.mId);
                    e2.setErrorCode("-102", ErrorUtils.getErrorInfoByNo(-102));
                    if (key.mListener != null) {
                        key.mListener.onNetResponse(event);
                    }
                }
            }
            ++i2;
        }
        long tmp = curTime - this.mLastReceviedTime;
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (tmp > SdkConfig.getInstance().getHeartBeatTime() && tmp < SdkConfig.getInstance().getHeartBeatTime() + (long)SdkConfig.getInstance().getSoTimeOut()) {
                if (this.mConnection == null || curTime - this.mLastSendedTime <= (long)SdkConfig.getInstance().getSoTimeOut()) return;
                this.mConnection.send(KEEPALIVE_PACKET);
                this.mLastSendedTime = System.currentTimeMillis();
            } else {
                if (tmp <= SdkConfig.getInstance().getHeartBeatTime() + (long)SdkConfig.getInstance().getSoTimeOut()) return;
                if (this.mConnection == null) {
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return;
                }
                this.mConnection.reconnect();
                this.mLastSendedTime = System.currentTimeMillis();
            }
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setNetworkStatusListener(NetworkStatusListener listener) {
        this.mNetWorkStatusListener = listener;
    }

    @Override
    public long getFlux() {
        return this.totalFlux;
    }

    @Override
    public void resetFlux() {
        this.totalFlux = 0L;
        this.sendFlux = 0L;
        this.recieveFlux = 0L;
    }

    public void addSendFlux(long flux) {
        this.sendFlux += flux;
        this.totalFlux += flux;
    }

    public void addRecieveFlux(long flux) {
        this.recieveFlux += flux;
        this.totalFlux += flux;
    }

    public void setReconnectCount(int reconnectCount) {
        this.reconnectCount = reconnectCount;
    }

    public boolean doLogin(NetChannel.RecvRunnable run) {
        return true;
    }

    public long getSendFlux() {
        return this.sendFlux;
    }

    public long getRecieveFlux() {
        return this.recieveFlux;
    }

    private final class NetEventKey {
        Integer mId;
        boolean mBack = false;
        long regeistTime = System.currentTimeMillis();
        NetworkListener mListener;
        int mEventTimeOut = 0;

        public int hashCode() {
            return this.mId;
        }

        public boolean equals(Object o2) {
            return o2.hashCode() == this.mId.intValue();
        }
    }
}

