/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.sdk.common.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.kinkaid.acs.protocol.common.share.dataset.DatasetService;
import com.kinkaid.acs.protocol.interfaces.share.dataset.IDataset;
import com.kinkaid.acs.sdk.common.config.NetworkAddr;
import com.kinkaid.acs.sdk.common.config.SdkConfig;
import com.kinkaid.acs.sdk.common.event.EventFactory;
import com.kinkaid.acs.sdk.common.net.NetworkService;
import com.kinkaid.acs.sdk.interfaces.event.INetworkEvent;
import com.kinkaid.acs.sdk.interfaces.exception.NetworkException;
import com.kinkaid.acs.sdk.interfaces.net.NetworkListener;
import com.kinkaid.acs.sdk.interfaces.net.NetworkMeasureListener;
import java.util.HashMap;
import java.util.List;

public class NetworkUtils {
    public static void calNetworkSpeed(List<NetworkAddr> addrs, final NetworkMeasureListener listenter) {
        if (addrs != null && listenter != null) {
            final HashMap<Integer, NetworkAddr> addrMap = new HashMap<Integer, NetworkAddr>();
            final HashMap<Integer, Long> timeMap = new HashMap<Integer, Long>();
            int i2 = 0;
            while (i2 < addrs.size()) {
                final NetworkService ns = new NetworkService();
                ns.setReconnectCount(1);
                ns.addNetworkAddr(addrs.get(i2));
                try {
                    ns.establishConnection(1);
                }
                catch (NetworkException e2) {
                    e2.printStackTrace();
                }
                INetworkEvent event = EventFactory.getEvent();
                addrMap.put(event.getEventId(), addrs.get(i2));
                timeMap.put(event.getEventId(), System.currentTimeMillis());
                INetworkEvent ne = EventFactory.getEvent();
                ne.setSubSystemNo(104);
                ne.setFunctionId(203);
                IDataset p2 = DatasetService.getDefaultInstance().getDataset();
                p2.addColumn("test");
                p2.appendRow();
                p2.updateString(1, "test");
                event.setDataset(p2);
                ns.postEvent(event, new NetworkListener(){

                    @Override
                    public void onNetResponse(INetworkEvent event) {
                        NetworkAddr addr = null;
                        long diffTime = 0L;
                        boolean error = false;
                        if (addrMap.containsKey(event.getEventId())) {
                            addr = (NetworkAddr)addrMap.get(event.getEventId());
                            diffTime = System.currentTimeMillis() - (Long)timeMap.get(event.getEventId());
                            error = event.getReturnCode() != 0;
                            listenter.onSpeed(addr, diffTime, error);
                        }
                        ns.terminate();
                    }
                });
                ++i2;
            }
        }
    }

    public static boolean isNetworkAvailable() {
        Context context = SdkConfig.getInstance().getApplicationContext();
        if (context != null) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return false;
            }
            NetworkInfo netinfo = cm.getActiveNetworkInfo();
            if (netinfo == null) {
                return false;
            }
            if (netinfo.isConnected()) {
                return true;
            }
        }
        return false;
    }
}

