/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.sdk.impl.net;

import com.kinkaid.acs.protocol.interfaces.share.event.IEvent;
import com.kinkaid.acs.sdk.common.config.NetworkAddr;
import com.kinkaid.acs.sdk.common.config.SdkConfig;
import com.kinkaid.acs.sdk.common.net.NetworkService;
import com.kinkaid.acs.sdk.common.protocol.HeadPack;
import com.kinkaid.acs.sdk.common.util.NetworkUtils;
import com.kinkaid.acs.sdk.interfaces.error.ErrorUtils;
import com.kinkaid.acs.sdk.interfaces.event.INetworkEvent;
import com.kinkaid.acs.sdk.interfaces.net.NetworkConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HttpChannel
extends NetworkConnection {
    URL url = null;
    ThreadPoolExecutor executor = null;

    public HttpChannel(NetworkService caller) {
        super(caller);
        HttpURLConnection.setDefaultRequestProperty("Content-Type", "application/x-www-form-urlencoded");
    }

    @Override
    public boolean closeConnection() {
        this.isRunning = false;
        this.shutdown();
        return true;
    }

    @Override
    public void reconnect() {
        this.openConnection(this.mAddress);
    }

    @Override
    public void openConnection(NetworkAddr addr) {
        try {
            this.url = new URL("http://" + addr.getIp() + ":" + addr.getWapPort() + "/macs");
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        super.openConnection(addr);
    }

    @Override
    public void send(byte[] data) {
        SendRunnable run = new SendRunnable(data);
        this.executor.execute(run);
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Override
    public void startRecvThread() {
        this.executor = new ThreadPoolExecutor(3, 6, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(20), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    @Override
    public void send(Object obj) {
        if (obj instanceof Object) {
            INetworkEvent ne = (INetworkEvent)INetworkEvent.class.cast(obj);
            byte[] data = null;
            byte[] tdata = null;
            try {
                data = ((IEvent)IEvent.class.cast(ne)).pack();
                tdata = new byte[data.length + 4];
                System.arraycopy(data, 0, tdata, 4, data.length);
                byte[] lenBin = HeadPack.encodeLength(data.length);
                System.arraycopy(lenBin, 0, tdata, 0, 4);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            SendRunnable run = new SendRunnable(tdata);
            run.setPacketId(ne.getEventId());
            this.executor.execute(run);
        }
    }

    @Override
    public boolean isPersistentConn() {
        return false;
    }

    class SendRunnable
    implements Runnable {
        private byte[] bin = null;
        private int packetId = 0;

        public SendRunnable() {
        }

        public SendRunnable(byte[] bt) {
            this.bin = bt;
        }

        public void setBin(byte[] bt) {
            this.bin = bt;
        }

        public void setPacketId(int id) {
            this.packetId = id;
        }

        @Override
        public void run() {
            block18: {
                if (!NetworkUtils.isNetworkAvailable()) {
                    HttpChannel.this.mCallback.onError(this.packetId, -104, ErrorUtils.getErrorInfoByNo(-104));
                    return;
                }
                try {
                    HttpURLConnection conn = (HttpURLConnection)HttpChannel.this.url.openConnection();
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Content-Length", String.valueOf(this.bin.length));
                    conn.setReadTimeout(SdkConfig.getInstance().getSoTimeOut());
                    conn.setConnectTimeout(5000);
                    OutputStream output = null;
                    try {
                        output = conn.getOutputStream();
                    }
                    catch (SocketTimeoutException e2) {
                        HttpChannel.this.mCallback.onConnect(false);
                        HttpChannel.this.mCallback.onError(this.packetId, -103, ErrorUtils.getErrorInfoByNo(-103));
                        return;
                    }
                    output.write(this.bin);
                    output.flush();
                    HttpChannel.this.mCallback.addSendFlux(this.bin.length);
                    int responseCode = -1;
                    try {
                        responseCode = conn.getResponseCode();
                    }
                    catch (SocketTimeoutException e3) {
                        HttpChannel.this.mCallback.onError(this.packetId, -102, ErrorUtils.getErrorInfoByNo(-102));
                        return;
                    }
                    if (responseCode == 200) {
                        ByteArrayOutputStream baos;
                        block17: {
                            baos = new ByteArrayOutputStream(65536);
                            InputStream input = conn.getInputStream();
                            try {
                                try {
                                    int n2;
                                    byte[] buf = new byte[65536];
                                    while ((n2 = input.read(buf)) > 0) {
                                        baos.write(buf, 0, n2);
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    input.close();
                                    break block17;
                                }
                            }
                            catch (Throwable throwable) {
                                input.close();
                                throw throwable;
                            }
                            input.close();
                        }
                        byte[] content = baos.toByteArray();
                        HttpChannel.this.mCallback.addRecieveFlux(content.length);
                        int length = HeadPack.checkT2Header(content, 0);
                        if (content.length == length + 4) {
                            HttpChannel.this.mCallback.onResponse(content, 4);
                        } else {
                            HttpChannel.this.mCallback.onError(this.packetId, -1, "\u6570\u636e\u5185\u5bb9\u975eT2\u4e1a\u52a1\u62a5\u6587");
                        }
                        break block18;
                    }
                    String responseMessage = conn.getResponseMessage();
                    HttpChannel.this.mCallback.onError(this.packetId, responseCode, responseMessage);
                }
                catch (SocketTimeoutException e4) {
                    HttpChannel.this.mCallback.onError(this.packetId, -102, ErrorUtils.getErrorInfoByNo(-102));
                }
                catch (IOException e5) {
                    HttpChannel.this.mCallback.onError(this.packetId, -105, ErrorUtils.getErrorInfoByNo(-105));
                }
            }
        }
    }
}

