/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.sdk.impl.net;

import android.util.Log;
import com.kinkaid.acs.protocol.interfaces.share.event.IEvent;
import com.kinkaid.acs.sdk.common.net.NetworkService;
import com.kinkaid.acs.sdk.common.protocol.HeadPack;
import com.kinkaid.acs.sdk.common.util.NetworkUtils;
import com.kinkaid.acs.sdk.interfaces.event.INetworkEvent;
import com.kinkaid.acs.sdk.interfaces.net.NetworkConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class NetChannel
extends NetworkConnection {
    private static final String RECIEVE_THREAD_NAME = "recieve_thread";
    private static final String SEND_THREAD_NAME = "send_thread";
    protected Socket mSocket = null;
    protected RecvRunnable mRecvRunnable = null;
    protected SendRunnable mSendRunnable = null;
    protected boolean mBroken = true;

    public NetChannel(NetworkService caller) {
        super(caller);
    }

    @Override
    public boolean closeConnection() {
        this.isRunning = false;
        if (this.mRecvRunnable != null) {
            this.mRecvRunnable.shutdown();
        }
        if (this.mSendRunnable != null) {
            this.mSendRunnable.shutdown();
        }
        this.shutdown();
        return true;
    }

    @Override
    public void shutdown() {
        if (this.mSocket != null && this.mSocket.isConnected()) {
            try {
                this.mSocket.close();
            }
            catch (IOException e2) {
                Log.e((String)TAG, (String)"\u5173\u95ed\u5931\u8d25\uff01");
            }
        }
    }

    @Override
    public void reconnect() {
        this.shutdown();
        if (RECIEVE_THREAD_NAME.equals(Thread.currentThread().getName())) {
            this.mRecvRunnable.connectAndSend();
        } else {
            this.mRecvRunnable.doConnect();
        }
    }

    protected boolean connect() {
        if (NetworkUtils.isNetworkAvailable()) {
            this.mSocket = new Socket();
            try {
                InetSocketAddress address = new InetSocketAddress(this.mAddress.getIp(), (int)this.mAddress.getNetPort());
                this.mSocket.connect(address, this.mAddress.getConnectTimeOut());
                this.mSocket.setSoTimeout(1000);
            }
            catch (IOException e2) {
                return false;
            }
            if (this.mSocket.isConnected()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void send(byte[] data) {
        if (data == null) {
            return;
        }
        if (this.mBroken) {
            this.resendQueue.add(data);
            this.reconnect();
        } else {
            this.mSendRunnable.send(data);
        }
    }

    public int recv(byte[] data, int offset, int length) throws IOException {
        if (this.mSocket == null) {
            return -1;
        }
        return this.mSocket.getInputStream().read(data, offset, length);
    }

    protected void recvDataForLength(byte[] data, int offset, int length) throws IOException {
        int ret;
        for (int read = 0; read != length; read += ret) {
            if (this.mSocket != null) {
                InputStream input = this.mSocket.getInputStream();
                ret = 0;
                try {
                    ret = input.read(data, offset, length - offset);
                }
                catch (SocketTimeoutException e2) {
                    this.mCallback.onTimeOut();
                }
                offset += ret;
                if (ret != -1) continue;
                throw new IOException("\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed\uff01");
            }
            throw new IOException("\u8fde\u63a5\u4e0d\u5b58\u5728\uff01");
        }
    }

    @Override
    public void startRecvThread() {
        if (this.mRecvRunnable == null) {
            this.mRecvRunnable = new RecvRunnable();
            this.mRecvRunnable.needConnect = true;
            Thread reciThread = new Thread(this.mRecvRunnable);
            reciThread.setName(RECIEVE_THREAD_NAME);
            reciThread.start();
        }
        if (this.mSendRunnable == null) {
            this.mSendRunnable = new SendRunnable();
            Thread sendThread = new Thread(this.mSendRunnable);
            sendThread.setName(SEND_THREAD_NAME);
            sendThread.start();
        }
    }

    @Override
    public void send(Object obj) {
        if (obj instanceof INetworkEvent) {
            INetworkEvent ne = (INetworkEvent)INetworkEvent.class.cast(obj);
            byte[] tdata = null;
            try {
                byte[] data = ((IEvent)IEvent.class.cast(ne)).pack();
                tdata = new byte[data.length + 4];
                System.arraycopy(data, 0, tdata, 4, data.length);
                byte[] lenBin = HeadPack.encodeLength(data.length);
                System.arraycopy(lenBin, 0, tdata, 0, 4);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                Log.e((String)TAG, (String)"\u53d1\u9001\u5931\u8d25\uff01\uff01");
            }
            this.send(tdata);
        }
    }

    public class RecvRunnable
    implements Runnable {
        private Object lock = new Object();
        private boolean needConnect = false;

        private void connectAndSend() {
            if (this.needConnect) {
                boolean bl = NetChannel.this.mBroken = !NetChannel.this.connect();
                if (!NetChannel.this.mBroken) {
                    NetChannel.this.mCallback.doLogin(this);
                }
                NetChannel.this.mCallback.onConnect(!NetChannel.this.mBroken);
            } else {
                NetChannel.this.mBroken = true;
                int i2 = 0;
                while (i2 < NetChannel.this.resendQueue.size()) {
                    NetChannel.this.resendQueue.remove(0);
                    ++i2;
                }
            }
            if (!NetChannel.this.mBroken) {
                int size = NetChannel.this.resendQueue.size();
                int i3 = 0;
                while (i3 < size) {
                    byte[] item = (byte[])NetChannel.this.resendQueue.remove(0);
                    NetChannel.this.send(item);
                    ++i3;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.connectAndSend();
            while (NetChannel.this.isRunning) {
                if (NetChannel.this.mBroken) {
                    try {
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    this.connectAndSend();
                    continue;
                }
                try {
                    this.receive();
                }
                catch (IOException e3) {
                    NetChannel.this.mBroken = true;
                    NetChannel.this.mCallback.onClosed();
                }
                catch (IllegalMonitorStateException e4) {
                    NetChannel.this.mBroken = true;
                    NetChannel.this.mCallback.onClosed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doConnect() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (IllegalThreadStateException e2) {
                e2.printStackTrace();
            }
            this.needConnect = false;
        }

        public void shutdownAndReconnect() {
            NetChannel.this.mBroken = true;
        }

        public byte[] receiveData() throws IOException {
            byte[] data = new byte[4];
            NetChannel.this.recvDataForLength(data, 0, 4);
            int length = HeadPack.checkT2Header(data);
            if (length > 51200) {
                this.shutdown();
            }
            if (length > 0) {
                data = new byte[length];
                NetChannel.this.recvDataForLength(data, 0, length);
                return data;
            }
            if (length < 0) {
                this.shutdownAndReconnect();
            }
            return null;
        }

        public void receive() throws IOException {
            byte[] data = this.receiveData();
            if (NetChannel.this.mCallback != null && data != null) {
                NetChannel.this.mCallback.addRecieveFlux(data.length + 4);
                NetChannel.this.mCallback.onResponse(data, 0);
            }
        }
    }

    protected class SendRunnable
    implements Runnable {
        private Object lock = new Object();
        private ConcurrentLinkedQueue<byte[]> sendQueue = new ConcurrentLinkedQueue();
        private boolean stop = false;

        protected SendRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (NetChannel.this.isRunning) {
                if (this.stop) continue;
                byte[] sendData = this.sendQueue.poll();
                if (sendData == null) {
                    try {
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                try {
                    NetChannel.this.mSocket.getOutputStream().write(sendData);
                    NetChannel.this.mCallback.addSendFlux(sendData.length);
                }
                catch (IOException e3) {
                    NetChannel.this.mBroken = true;
                    Log.e((String)TAG, (String)"\u53d1\u9001\u5931\u8d25\uff01");
                    e3.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(byte[] data) {
            if (data == null) {
                return;
            }
            this.sendQueue.add(data);
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (IllegalThreadStateException e2) {
                e2.printStackTrace();
            }
            this.stop = true;
        }
    }
}

