/*
 * Decompiled with CFR 0.152.
 */
package com.kinkaid.acs.sdk.interfaces.net;

import com.kinkaid.acs.sdk.common.config.NetworkAddr;
import com.kinkaid.acs.sdk.common.net.NetworkService;
import java.util.LinkedList;

public abstract class NetworkConnection {
    public static String TAG = "NetworkConnection";
    protected LinkedList<Object> mRequestQueue = new LinkedList();
    protected NetworkService mCallback = null;
    protected NetworkAddr mAddress = null;
    protected boolean isRunning = false;
    protected LinkedList<byte[]> resendQueue = new LinkedList();

    protected NetworkConnection(NetworkService caller) {
        this.mCallback = caller;
    }

    public void openConnection(NetworkAddr addr) {
        this.isRunning = true;
        this.mAddress = addr;
        this.startRecvThread();
    }

    public abstract boolean closeConnection();

    public abstract void send(byte[] var1);

    public abstract void send(Object var1);

    public abstract void reconnect();

    public abstract void startRecvThread();

    public abstract void shutdown();

    public void clearSendQueue() {
        if (this.resendQueue != null) {
            this.resendQueue.clear();
        }
    }

    public void setNetworkAddr(NetworkAddr addr) {
        this.mAddress = addr;
    }

    public boolean isPersistentConn() {
        return true;
    }
}

