/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.android.app.net;

import java.io.IOException;
import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public final class AndroidHttpClient
implements HttpClient {
    public static final String TAG = "AndroidHttpClient";
    private final DefaultHttpClient delegate;

    public static AndroidHttpClient newInstance(String userAgent) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)true);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)30000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)16384);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        HttpClientParams.setAuthenticating((HttpParams)params, (boolean)false);
        if (userAgent != null) {
            HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslsf = SSLSocketFactory.getSocketFactory();
        X509HostnameVerifier hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        sslsf.setHostnameVerifier(hostnameVerifier);
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)hostnameVerifier);
        schemeRegistry.register(new Scheme("https", (SocketFactory)sslsf, 443));
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        return new AndroidHttpClient((ClientConnectionManager)manager, (HttpParams)params);
    }

    private AndroidHttpClient(ClientConnectionManager ccm, HttpParams params) {
        this.delegate = new DelegateHttpClient(ccm, params);
        this.delegate.setRedirectHandler(new RedirectHandler(){

            public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode == 301 || statusCode == 302) {
                    return false;
                }
                return false;
            }

            public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
                return null;
            }
        });
    }

    public void close() {
        this.getConnectionManager().shutdown();
    }

    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return this.delegate.execute(request);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        return this.delegate.execute(request, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        HttpResponse httpResponse = this.delegate.execute(target, request);
        return httpResponse;
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return this.delegate.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.delegate.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        return (T)this.delegate.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.delegate.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        return (T)this.delegate.execute(target, request, responseHandler, context);
    }

    private static class DelegateHttpClient
    extends DefaultHttpClient {
        private DelegateHttpClient(ClientConnectionManager ccm, HttpParams params) {
            super(ccm, params);
        }

        protected HttpContext createHttpContext() {
            BasicHttpContext context = new BasicHttpContext();
            context.setAttribute("http.authscheme-registry", (Object)this.getAuthSchemes());
            context.setAttribute("http.cookiespec-registry", (Object)this.getCookieSpecs());
            context.setAttribute("http.auth.credentials-provider", (Object)this.getCredentialsProvider());
            return context;
        }
    }
}

