/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.android.app.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import com.alipay.android.app.net.AndroidHttpClient;
import com.alipay.android.app.net.WebResponseData;
import com.alipay.android.app.util.Utils;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    private Context mContext;
    private String mUrl;
    private AndroidHttpClient sAndroidHttpClient = null;

    public HttpClient(Context context) {
        this(context, null);
    }

    public HttpClient(Context context, String url) {
        this.mContext = context;
        this.mUrl = url;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public URL getURL() {
        URL url = null;
        try {
            url = new URL(this.mUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private String getStatus(String s) {
        int startIndex = s.indexOf(" ");
        int endIndex = s.indexOf(" ", ++startIndex);
        if (startIndex == -1 || endIndex == -1) {
            return null;
        }
        String status = s.substring(startIndex, endIndex);
        return status;
    }

    public String sendSynchronousRequest(String requestData, ArrayList<BasicHeader> headers) {
        String response = null;
        try {
            HttpResponse httpResponse = this.sendSynchronousRequestAsHttpResponse(requestData);
            HttpEntity entity = httpResponse.getEntity();
            response = EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception e) {
            return null;
        }
        return response;
    }

    public HttpResponse sendSynchronousRequestAsHttpResponse(String strReqData, ArrayList<BasicHeader> headers) {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("requestData", strReqData));
        try {
            return this.sendSynchronousRequestAsHttpResponse(pairs, headers);
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    public WebResponseData sendSynchronousRequest(ArrayList<BasicNameValuePair> pairs, ArrayList<BasicHeader> headers) {
        WebResponseData respData = null;
        try {
            HttpResponse httpResponse = this.sendSynchronousRequestAsHttpResponse(pairs, headers);
            HttpEntity entity = httpResponse.getEntity();
            String strResponse = EntityUtils.toString((HttpEntity)entity);
            String status = null;
            try {
                status = httpResponse.getStatusLine().toString();
                status = this.getStatus(status);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String contentType = entity.getContentType().getValue();
            String charset = Utils.getCharset(contentType);
            contentType = Utils.getContentType(contentType);
            respData = new WebResponseData(strResponse, contentType, charset, status);
        }
        catch (SSLPeerUnverifiedException e1) {
            respData = new WebResponseData("sslerror", "", "UTF-8", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return respData;
    }

    public HttpResponse sendSynchronousRequestAsHttpResponse(String request) {
        HttpResponse httpResponse = null;
        URL url = this.getURL();
        HttpPost httpRequest = null;
        HttpHost target = null;
        try {
            if (this.sAndroidHttpClient == null) {
                this.sAndroidHttpClient = AndroidHttpClient.newInstance("alipay_sdk");
            }
            HttpParams httpParams = this.sAndroidHttpClient.getParams();
            HttpHost proxy = this.getProxy();
            httpParams.setParameter("http.route.default-proxy", (Object)proxy);
            String protocol = url.getProtocol();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            target = new HttpHost(url.getHost(), port, protocol);
            httpRequest = new HttpPost(this.mUrl);
            ByteArrayEntity entity = new ByteArrayEntity(request.getBytes());
            httpRequest.setEntity((HttpEntity)entity);
            httpRequest.addHeader("Content-type", "application/octet-stream");
            httpResponse = this.sAndroidHttpClient.execute(target, (HttpRequest)httpRequest);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            try {
                httpResponse = this.sAndroidHttpClient.execute(target, (HttpRequest)httpRequest);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpResponse;
    }

    public HttpResponse sendSynchronousRequestAsHttpResponse(ArrayList<BasicNameValuePair> pairs, ArrayList<BasicHeader> headers) throws SSLPeerUnverifiedException {
        HttpResponse httpResponse = null;
        URL url = this.getURL();
        UrlEncodedFormEntity p_entity = null;
        HttpPost httpRequest = null;
        HttpHost target = null;
        try {
            if (this.sAndroidHttpClient == null) {
                this.sAndroidHttpClient = AndroidHttpClient.newInstance("alipay_sdk");
            }
            HttpParams httpParams = this.sAndroidHttpClient.getParams();
            HttpHost proxy = this.getProxy();
            httpParams.setParameter("http.route.default-proxy", (Object)proxy);
            String protocol = url.getProtocol();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            target = new HttpHost(url.getHost(), port, protocol);
            if (pairs != null) {
                httpRequest = new HttpPost(this.mUrl);
                p_entity = new UrlEncodedFormEntity(pairs, "utf-8");
                httpRequest.setEntity((HttpEntity)p_entity);
            } else {
                httpRequest = new HttpGet(this.mUrl);
            }
            httpRequest.addHeader("Content-type", "application/x-www-form-urlencoded;charset=utf-8");
            httpRequest.addHeader("Accept", "application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
            if (headers != null) {
                for (Header header : headers) {
                    httpRequest.addHeader(header);
                }
            }
            httpResponse = this.sAndroidHttpClient.execute(target, (HttpRequest)httpRequest);
        }
        catch (SSLPeerUnverifiedException e) {
            throw new SSLPeerUnverifiedException("SSL error");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            try {
                httpResponse = this.sAndroidHttpClient.execute(target, (HttpRequest)httpRequest);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpResponse;
    }

    private HttpHost getProxy() {
        HttpHost proxy = null;
        NetworkInfo ni = this.getActiveNetworkInfo();
        if (ni != null && ni.isAvailable() && ni.getType() == 0) {
            String proxyHost = Proxy.getDefaultHost();
            int port = Proxy.getDefaultPort();
            if (proxyHost != null) {
                proxy = new HttpHost(proxyHost, port);
            }
        }
        return proxy;
    }

    private NetworkInfo getActiveNetworkInfo() {
        NetworkInfo info = null;
        try {
            ConnectivityManager connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            info = connManager.getActiveNetworkInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }
}

