/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.android.app.sdk;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import com.alipay.android.app.lib.ResourceMap;
import com.alipay.android.app.net.HttpClient;
import com.alipay.android.app.net.RequestData;
import com.alipay.android.app.net.ResponseData;
import com.alipay.android.app.sdk.Result;
import com.alipay.android.app.sdk.ResultStatus;
import com.alipay.android.app.sdk.WapPayActivity;
import com.alipay.android.app.util.FileDownloader;
import com.alipay.android.app.util.LogUtils;
import com.alipay.android.app.util.PayHelper;
import com.alipay.android.app.util.StoreUtils;
import com.alipay.android.app.util.Utils;
import com.alipay.android.app.widget.CustomAlertDialog;
import com.alipay.android.app.widget.Loading;
import java.io.File;
import org.json.JSONObject;

public class AliPay {
    private static String URL = "https://mclient.alipay.com/gateway.do";
    private static final String MSP_APK_NAME = "alipay_msp.apk";
    private static final String ALIPAY_APK_NAME = "alipay.apk";
    private Activity mContext;
    private Handler mHandler;
    private CustomAlertDialog mInstallMessageAlert;
    private String mDownloadUrl;
    private String mDownloadType;
    private int mTimeout;
    private String mUrl;
    private boolean isInstall;
    protected static final Object sLock = new Object();
    private Runnable mDownloadFailRunnable = new Runnable(){

        @Override
        public void run() {
            CustomAlertDialog.Builder alertDialog = new CustomAlertDialog.Builder((Context)AliPay.this.mContext);
            alertDialog.setTitle(ResourceMap.getString_confirm_title());
            alertDialog.setMessage(ResourceMap.getString_download_fail());
            alertDialog.setNegativeButton(ResourceMap.getString_cancel(), new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClick(DialogInterface dialog, int which) {
                    Object object = sLock;
                    synchronized (object) {
                        ResultStatus status = ResultStatus.getResultState(6001);
                        Result.setPayResult(Result.parseResult(status.getStatus(), status.getMsg(), ""));
                        try {
                            sLock.notify();
                        }
                        catch (Exception e) {
                            LogUtils.printExceptionStackTrace(e);
                        }
                    }
                }
            });
            alertDialog.setPositiveButton(ResourceMap.getString_redo(), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    AliPay.this.downloadFile();
                }
            });
            alertDialog.show();
        }
    };
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.intent.action.PACKAGE_ADDED")) {
                if (AliPay.this.mInstallMessageAlert != null) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            AliPay.this.mInstallMessageAlert.dismiss();
                        }
                    };
                    AliPay.this.mHandler.post(r);
                }
                AliPay.this.isInstall = true;
                AliPay.this.mContext.unregisterReceiver(AliPay.this.mReceiver);
                Object object = sLock;
                synchronized (object) {
                    sLock.notify();
                }
            }
        }
    };

    public AliPay(Activity context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pay(String orderInfo) {
        ResponseData responseData;
        JSONObject jsonParams;
        Loading loading = new Loading(this.mContext);
        loading.show();
        String payResult = "";
        String clientKey = Utils.getClientKey((Context)this.mContext);
        String clientId = Utils.getClientId((Context)this.mContext);
        String alixTid = Utils.getAlixTid((Context)this.mContext);
        String network = Utils.getNetConnectionType((Context)this.mContext).getName();
        StringBuilder sb = new StringBuilder("");
        if (Utils.isExistMsp((Context)this.mContext)) {
            sb.append("safepay|");
        }
        if (Utils.isExistClient((Context)this.mContext)) {
            sb.append("alipay");
        } else if (sb.indexOf("|") != -1) {
            sb.deleteCharAt(sb.indexOf("|"));
        }
        PayHelper payHelper = new PayHelper(this.mContext);
        RequestData requestData = new RequestData(clientKey, clientId, alixTid, sb.toString(), network, orderInfo);
        HttpClient httpClient = new HttpClient((Context)this.mContext);
        httpClient.setUrl(URL);
        LogUtils.i("sdk request:" + requestData.toString());
        String response = httpClient.sendSynchronousRequest(requestData.toString(), null);
        loading.dismiss();
        LogUtils.i("sdk response:" + response);
        if (TextUtils.isEmpty((CharSequence)response)) {
            String payConfig = StoreUtils.getValue((Context)this.mContext, "config");
            if (TextUtils.equals((CharSequence)payConfig, (CharSequence)"safepay")) {
                if (Utils.isExistMsp((Context)this.mContext)) {
                    payResult = payHelper.pay4Msp(orderInfo);
                    return payResult;
                }
            } else if (TextUtils.equals((CharSequence)payConfig, (CharSequence)"alipay")) {
                if (Utils.isExistClient((Context)this.mContext)) {
                    payResult = payHelper.pay4Client(orderInfo);
                    return payResult;
                }
            } else if (TextUtils.isEmpty((CharSequence)payConfig)) {
                if (Utils.isExistMsp((Context)this.mContext)) {
                    payResult = payHelper.pay4Msp(orderInfo);
                    return payResult;
                }
                if (Utils.isExistClient((Context)this.mContext)) {
                    payResult = payHelper.pay4Client(orderInfo);
                    return payResult;
                }
                File cacheDir = this.mContext.getCacheDir();
                String cachePath = String.valueOf(cacheDir.getAbsolutePath()) + "/temp.apk";
                if (Utils.retrieveApkFromAssets((Context)this.mContext, MSP_APK_NAME, cachePath)) {
                    this.doInstall(false, cachePath, this.mContext.getResources().getString(ResourceMap.getString_install_msp()));
                    Object object = sLock;
                    synchronized (object) {
                        try {
                            sLock.wait();
                        }
                        catch (InterruptedException e) {
                            LogUtils.printExceptionStackTrace(e);
                        }
                    }
                    payResult = this.isInstall ? payHelper.pay4Msp(orderInfo) : Result.getPayResult();
                    return payResult;
                }
                if (Utils.retrieveApkFromAssets((Context)this.mContext, ALIPAY_APK_NAME, cachePath)) {
                    this.doInstall(false, cachePath, this.mContext.getResources().getString(ResourceMap.getString_install_alipay()));
                    Object object = sLock;
                    synchronized (object) {
                        try {
                            sLock.wait();
                        }
                        catch (InterruptedException e) {
                            LogUtils.printExceptionStackTrace(e);
                        }
                    }
                    payResult = this.isInstall ? payHelper.pay4Client(orderInfo) : Result.getPayResult();
                    return payResult;
                }
                ResultStatus status = ResultStatus.getResultState(6002);
                payResult = Result.parseResult(status.getStatus(), status.getMsg(), "");
                return payResult;
            }
        }
        if ((jsonParams = (responseData = new ResponseData(response)).getParams()) == null) {
            ResultStatus status = ResultStatus.getResultState(4000);
            payResult = Result.parseResult(status.getStatus(), status.getMsg(), "");
            return payResult;
        }
        String state = jsonParams.optString("state");
        if (TextUtils.equals((CharSequence)state, (CharSequence)"7001")) {
            String errorMsg = jsonParams.optString("errorMessage");
            payResult = Result.parseResult(Integer.parseInt(state), errorMsg, "");
            return payResult;
        }
        if (TextUtils.equals((CharSequence)state, (CharSequence)"9000")) {
            String payConfig;
            alixTid = jsonParams.optString("alixtid");
            if (!TextUtils.equals((CharSequence)alixTid, (CharSequence)Utils.getAlixTid((Context)this.mContext))) {
                StoreUtils.putValue((Context)this.mContext, "alix_tid", alixTid);
            }
            if (TextUtils.equals((CharSequence)(payConfig = jsonParams.optString("config")), (CharSequence)"safepay")) {
                StoreUtils.putValue((Context)this.mContext, payConfig, "safepay");
                payResult = payHelper.pay4Msp(orderInfo);
                return payResult;
            }
            if (TextUtils.equals((CharSequence)payConfig, (CharSequence)"alipay")) {
                StoreUtils.putValue((Context)this.mContext, payConfig, "alipay");
                payResult = payHelper.pay4Client(orderInfo);
                return payResult;
            }
            if (TextUtils.equals((CharSequence)payConfig, (CharSequence)"wap")) {
                int timeout = jsonParams.optInt("timeout", 15);
                String url = jsonParams.optString("url");
                Intent intent = new Intent((Context)this.mContext, WapPayActivity.class);
                Bundle extras = new Bundle();
                extras.putString("url", url);
                extras.putInt("timeout", timeout);
                intent.putExtras(extras);
                this.mContext.startActivity(intent);
                Object object = sLock;
                synchronized (object) {
                    try {
                        sLock.wait();
                    }
                    catch (InterruptedException e) {
                        LogUtils.printExceptionStackTrace(e);
                    }
                }
                payResult = Result.getPayResult();
                if (TextUtils.isEmpty((CharSequence)payResult)) {
                    ResultStatus status = ResultStatus.getResultState(6001);
                    payResult = Result.parseResult(status.getStatus(), status.getMsg(), "");
                }
                return payResult;
            }
            if (TextUtils.equals((CharSequence)payConfig, (CharSequence)"wap_sdk")) {
                this.mTimeout = jsonParams.optInt("timeout", 15);
                this.mDownloadUrl = jsonParams.optString("downloadUrl");
                String downloadMessage = jsonParams.optString("downloadMessage");
                this.mUrl = jsonParams.optString("url");
                this.mDownloadType = jsonParams.optString("downloadType");
                this.processInstall(true, downloadMessage, jsonParams);
                Object object = sLock;
                synchronized (object) {
                    try {
                        sLock.wait();
                    }
                    catch (InterruptedException e) {
                        LogUtils.printExceptionStackTrace(e);
                    }
                }
                if (this.isInstall) {
                    if (TextUtils.equals((CharSequence)this.mDownloadType, (CharSequence)"safepay")) {
                        payResult = payHelper.pay4Msp(orderInfo);
                        return payResult;
                    }
                    if (TextUtils.equals((CharSequence)this.mDownloadType, (CharSequence)"alipay")) {
                        payResult = payHelper.pay4Client(orderInfo);
                        return payResult;
                    }
                }
            } else if (TextUtils.equals((CharSequence)payConfig, (CharSequence)"download")) {
                this.mDownloadUrl = jsonParams.optString("downloadUrl");
                String downloadMessage = jsonParams.optString("downloadMessage");
                this.mDownloadType = jsonParams.optString("downloadType");
                this.processInstall(false, downloadMessage, jsonParams);
                Object object = sLock;
                synchronized (object) {
                    try {
                        sLock.wait();
                    }
                    catch (InterruptedException e) {
                        LogUtils.printExceptionStackTrace(e);
                    }
                }
                if (this.isInstall) {
                    if (TextUtils.equals((CharSequence)this.mDownloadType, (CharSequence)"safepay")) {
                        payResult = payHelper.pay4Msp(orderInfo);
                        return payResult;
                    }
                    if (TextUtils.equals((CharSequence)this.mDownloadType, (CharSequence)"alipay")) {
                        payResult = payHelper.pay4Client(orderInfo);
                        return payResult;
                    }
                }
            } else if (TextUtils.equals((CharSequence)payConfig, (CharSequence)"exit")) {
                ResultStatus status = ResultStatus.getResultState(4000);
                payResult = Result.parseResult(status.getStatus(), status.getMsg(), "");
                return payResult;
            }
        } else {
            if (TextUtils.equals((CharSequence)state, (CharSequence)"4001")) {
                ResultStatus status = ResultStatus.getResultState(Integer.parseInt(state));
                payResult = Result.parseResult(status.getStatus(), status.getMsg(), "");
                return payResult;
            }
            if (TextUtils.equals((CharSequence)state, (CharSequence)"5001")) {
                return this.pay(orderInfo);
            }
        }
        if (Result.getPayResult() != null) {
            payResult = Result.getPayResult();
        }
        LogUtils.i("sdk result:" + payResult);
        return payResult;
    }

    private void processInstall(boolean isWap, String downloadMessage, JSONObject jsonParams) {
        File cacheDir = this.mContext.getCacheDir();
        String cachePath = String.valueOf(cacheDir.getAbsolutePath()) + "/temp.apk";
        if (TextUtils.equals((CharSequence)this.mDownloadType, (CharSequence)"safepay")) {
            if (Utils.retrieveApkFromAssets((Context)this.mContext, MSP_APK_NAME, cachePath)) {
                if (Utils.is2G((Context)this.mContext)) {
                    this.doInstall(isWap, cachePath, downloadMessage);
                } else {
                    PackageInfo apkInfo = Utils.getApkInfo((Context)this.mContext, cachePath);
                    String apk_version = apkInfo.versionName;
                    String download_version = jsonParams.optString("downloadVersion", "3.5.4");
                    if (Utils.compareVersion(apk_version, download_version) < 0) {
                        this.doDownLoad(isWap, downloadMessage);
                    } else {
                        this.doInstall(isWap, cachePath, downloadMessage);
                    }
                }
            } else {
                this.doDownLoad(isWap, downloadMessage);
            }
        } else if (TextUtils.equals((CharSequence)this.mDownloadType, (CharSequence)"alipay")) {
            if (Utils.retrieveApkFromAssets((Context)this.mContext, ALIPAY_APK_NAME, cachePath)) {
                if (Utils.is2G((Context)this.mContext)) {
                    this.doInstall(isWap, cachePath, downloadMessage);
                } else {
                    PackageInfo apkInfo = Utils.getApkInfo((Context)this.mContext, cachePath);
                    String apk_version = apkInfo.versionName;
                    String download_version = jsonParams.optString("downloadVersion", "7.1.0.0701");
                    if (Utils.compareVersion(apk_version, download_version) < 0) {
                        this.doDownLoad(isWap, downloadMessage);
                    } else {
                        this.doInstall(isWap, cachePath, downloadMessage);
                    }
                }
            } else {
                this.doDownLoad(isWap, downloadMessage);
            }
        }
    }

    private void doInstall(final boolean isWap, final String cachePath, final String downloadMessage) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CustomAlertDialog.Builder alertDialog = new CustomAlertDialog.Builder((Context)AliPay.this.mContext);
                alertDialog.setTitle(ResourceMap.getString_confirm_title());
                alertDialog.setMessage(downloadMessage);
                alertDialog.setNegativeButton(ResourceMap.getString_cancel(), new DialogInterface.OnClickListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClick(DialogInterface dialog, int which) {
                        if (isWap) {
                            Intent intent = new Intent((Context)AliPay.this.mContext, WapPayActivity.class);
                            Bundle extras = new Bundle();
                            extras.putString("url", AliPay.this.mUrl);
                            extras.putInt("timeout", AliPay.this.mTimeout);
                            intent.putExtras(extras);
                            AliPay.this.mContext.startActivity(intent);
                        } else {
                            Object object = sLock;
                            synchronized (object) {
                                ResultStatus status = ResultStatus.getResultState(6001);
                                Result.setPayResult(Result.parseResult(status.getStatus(), status.getMsg(), ""));
                                try {
                                    sLock.notify();
                                }
                                catch (Exception e) {
                                    LogUtils.printExceptionStackTrace(e);
                                }
                            }
                        }
                    }
                });
                alertDialog.setPositiveButton(ResourceMap.getString_ensure(), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Utils.installApk(AliPay.this.mContext, cachePath);
                        IntentFilter filter = new IntentFilter();
                        filter.addAction("android.intent.action.PACKAGE_ADDED");
                        filter.addDataScheme("package");
                        AliPay.this.mContext.registerReceiver(AliPay.this.mReceiver, filter);
                        AliPay.this.showInstallMessage();
                    }
                });
                alertDialog.show();
            }
        };
        this.mHandler.post(runnable);
    }

    private void doDownLoad(final boolean isWap, final String downloadMessage) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CustomAlertDialog.Builder alertDialog = new CustomAlertDialog.Builder((Context)AliPay.this.mContext);
                alertDialog.setTitle(ResourceMap.getString_confirm_title());
                alertDialog.setMessage(downloadMessage);
                alertDialog.setNegativeButton(ResourceMap.getString_cancel(), new DialogInterface.OnClickListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClick(DialogInterface dialog, int which) {
                        if (isWap) {
                            Intent intent = new Intent((Context)AliPay.this.mContext, WapPayActivity.class);
                            Bundle extras = new Bundle();
                            extras.putString("url", AliPay.this.mUrl);
                            extras.putInt("timeout", AliPay.this.mTimeout);
                            intent.putExtras(extras);
                            AliPay.this.mContext.startActivity(intent);
                        } else {
                            Object object = sLock;
                            synchronized (object) {
                                ResultStatus status = ResultStatus.getResultState(6001);
                                Result.setPayResult(Result.parseResult(status.getStatus(), status.getMsg(), ""));
                                try {
                                    sLock.notify();
                                }
                                catch (Exception e) {
                                    LogUtils.printExceptionStackTrace(e);
                                }
                            }
                        }
                    }
                });
                alertDialog.setPositiveButton(ResourceMap.getString_ensure(), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        AliPay.this.downloadFile();
                    }
                });
                alertDialog.show();
            }
        };
        this.mHandler.post(runnable);
    }

    private void downloadFile() {
        final Loading loading = new Loading(this.mContext);
        loading.show();
        File cacheDir = this.mContext.getCacheDir();
        final String cachePath = String.valueOf(cacheDir.getAbsolutePath()) + "/temp.apk";
        FileDownloader fd = new FileDownloader();
        fd.setFileUrl(this.mDownloadUrl);
        fd.setSavePath(cachePath);
        fd.setProgressOutput(new FileDownloader.IDownloadProgress(){

            @Override
            public void downloadSucess() {
                loading.dismiss();
                AliPay.this.mHandler.removeCallbacks(AliPay.this.mDownloadFailRunnable);
                Utils.installApk(AliPay.this.mContext, cachePath);
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.PACKAGE_ADDED");
                filter.addDataScheme("package");
                AliPay.this.mContext.registerReceiver(AliPay.this.mReceiver, filter);
                AliPay.this.showInstallMessage();
            }

            @Override
            public void downloadProgress(float progress) {
            }

            @Override
            public void downloadFail() {
                AliPay.this.mHandler.removeCallbacks(AliPay.this.mDownloadFailRunnable);
                loading.dismiss();
                AliPay.this.mHandler.post(AliPay.this.mDownloadFailRunnable);
            }
        });
        fd.start();
        this.mHandler.postDelayed(this.mDownloadFailRunnable, 35000L);
    }

    private void showInstallMessage() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CustomAlertDialog.Builder dialog = new CustomAlertDialog.Builder((Context)AliPay.this.mContext);
                dialog.setTitle(ResourceMap.getString_confirm_title());
                if (TextUtils.equals((CharSequence)AliPay.this.mDownloadType, (CharSequence)"safepay")) {
                    dialog.setMessage(ResourceMap.getString_cancelInstallTips());
                } else if (TextUtils.equals((CharSequence)AliPay.this.mDownloadType, (CharSequence)"alipay")) {
                    dialog.setMessage(ResourceMap.getString_cancelInstallAlipayTips());
                }
                dialog.setPositiveButton(ResourceMap.getString_ensure(), new DialogInterface.OnClickListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClick(DialogInterface dialog, int which) {
                        AliPay.this.mContext.unregisterReceiver(AliPay.this.mReceiver);
                        AliPay.this.isInstall = false;
                        ResultStatus status = ResultStatus.getResultState(6001);
                        Result.setPayResult(Result.parseResult(status.getStatus(), status.getMsg(), ""));
                        Object object = sLock;
                        synchronized (object) {
                            try {
                                sLock.notify();
                            }
                            catch (Exception e) {
                                LogUtils.printExceptionStackTrace(e);
                            }
                        }
                    }
                });
                AliPay.this.mInstallMessageAlert = dialog.show();
            }
        };
        this.mHandler.post(r);
    }
}

