/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.android.app.util;

public enum NetConnectionType {
    WIFI(0, "WIFI"),
    NETWORK_TYPE_1(1, "unicom2G"),
    NETWORK_TYPE_2(2, "mobile2G"),
    NETWORK_TYPE_4(4, "telecom2G"),
    NETWORK_TYPE_5(5, "telecom3G"),
    NETWORK_TYPE_6(6, "telecom3G"),
    NETWORK_TYPE_12(12, "telecom3G"),
    NETWORK_TYPE_8(8, "unicom3G"),
    NETWORK_TYPE_3(3, "unicom3G"),
    NETWORK_TYPE_13(13, "LTE"),
    NETWORK_TYPE_11(11, "IDEN"),
    NETWORK_TYPE_9(9, "HSUPA"),
    NETWORK_TYPE_10(10, "HSPA"),
    NETWORK_TYPE_15(15, "HSPAP"),
    NONE(-1, "none");

    private int code;
    private String name;

    private NetConnectionType(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public static NetConnectionType getTypeByCode(int code) {
        NetConnectionType[] types;
        NetConnectionType[] netConnectionTypeArray = types = NetConnectionType.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            NetConnectionType type = netConnectionTypeArray[n2];
            if (type.getCode() == code) {
                return type;
            }
            ++n2;
        }
        return NONE;
    }
}

