/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.android.app.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.alipay.android.app.IAlixPay;
import com.alipay.android.app.IRemoteServiceCallback;

public class PayHelper {
    private Activity mContext;
    private IAlixPay mAlixPay;
    private Object mLock;
    private boolean mIsPaying = false;
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            PayHelper.this.mAlixPay = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = PayHelper.this.mLock;
            synchronized (object) {
                PayHelper.this.mAlixPay = IAlixPay.Stub.asInterface(service);
                PayHelper.this.mLock.notify();
            }
        }
    };
    private IRemoteServiceCallback mCallback = new IRemoteServiceCallback.Stub(){

        @Override
        public boolean isHideLoadingScreen() throws RemoteException {
            return false;
        }

        @Override
        public void payEnd(boolean arg0, String arg1) throws RemoteException {
        }

        @Override
        public void startActivity(String packageName, String className, int callingPid, Bundle bundle) throws RemoteException {
            Intent intent = new Intent("android.intent.action.MAIN", null);
            if (bundle == null) {
                bundle = new Bundle();
            }
            try {
                bundle.putInt("CallingPid", callingPid);
                intent.putExtras(bundle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            intent.setClassName(packageName, className);
            PayHelper.this.mContext.startActivity(intent);
        }
    };

    public PayHelper(Activity context) {
        this.mContext = context;
        this.mLock = new Object();
    }

    public String pay4Msp(String orderInfo) {
        Intent intent = new Intent(IAlixPay.class.getName());
        return this.pay(orderInfo, intent);
    }

    public String pay4Client(String orderInfo) {
        Intent intent = new Intent("com.eg.android.AlipayGphone.IAlixPay");
        return this.pay(orderInfo, intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pay(String orderInfo, Intent intent) {
        String result = null;
        if (this.mIsPaying) {
            return "";
        }
        this.mIsPaying = true;
        if (this.mAlixPay == null) {
            this.mContext.getApplicationContext().bindService(intent, this.mServiceConnection, 1);
        }
        try {
            try {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mAlixPay == null) {
                        this.mLock.wait();
                    }
                }
                this.mAlixPay.registerCallback(this.mCallback);
                result = this.mAlixPay.Pay(orderInfo);
                this.mAlixPay.unregisterCallback(this.mCallback);
                this.mContext.unbindService(this.mServiceConnection);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mIsPaying = false;
            }
        }
        finally {
            this.mIsPaying = false;
        }
        return result;
    }
}

