/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.android.app.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.alipay.android.app.util.NetConnectionType;
import com.alipay.android.app.util.StoreUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final String MSP_PACKAGE_NAME = "com.alipay.android.app";
    private static final String ALIPAY_PACKAGE_NAME = "com.eg.android.AlipayGphone";
    private static final String ALIPAY_VERSION = "7.0.0.0602";
    private static final String MSP_VERSION = "5.0.0";

    public static boolean isExistMsp(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo apkInfo = manager.getPackageInfo(MSP_PACKAGE_NAME, 128);
            return apkInfo != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean isExistClient(Context context) {
        PackageInfo apkInfo;
        block3: {
            try {
                PackageManager manager = context.getPackageManager();
                apkInfo = manager.getPackageInfo(ALIPAY_PACKAGE_NAME, 128);
                if (apkInfo != null) break block3;
                return false;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        String version = apkInfo.versionName;
        return version.compareTo(ALIPAY_VERSION) >= 0;
    }

    public static boolean isLatestMspVersion(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo apkInfo = manager.getPackageInfo(MSP_PACKAGE_NAME, 128);
            String version = apkInfo.versionName;
            return version.compareTo(MSP_VERSION) >= 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static NetConnectionType getNetConnectionType(Context context) {
        ConnectivityManager connec = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = connec.getActiveNetworkInfo();
        if (info != null && info.getType() == 0) {
            return NetConnectionType.getTypeByCode(info.getSubtype());
        }
        if (info != null && info.getType() == 1) {
            return NetConnectionType.WIFI;
        }
        return NetConnectionType.NONE;
    }

    public static boolean is2G(Context context) {
        int code = Utils.getNetConnectionType(context).getCode();
        switch (code) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static String getCharset(String contentType) {
        String charset = null;
        String charsetTag = "charset=";
        int start = contentType.indexOf(charsetTag);
        if (start != -1) {
            int end = contentType.indexOf(";", start += charsetTag.length());
            charset = end != -1 ? contentType.substring(start, end) : contentType.substring(start);
        }
        return charset;
    }

    public static String getContentType(String acontentType) {
        String contentType = null;
        String contentTypeTag = ";";
        int end = acontentType.indexOf(contentTypeTag);
        contentType = end > 0 ? acontentType.substring(0, end) : acontentType;
        return contentType;
    }

    public static void chmod(String permission, String path) {
        try {
            String command = "chmod " + permission + " " + path;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getClientKey(Context context) {
        String clientKey = StoreUtils.getValue(context, "client_key");
        if (TextUtils.isEmpty((CharSequence)clientKey)) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < 10) {
                sb.append((int)(10.0 * Math.random()));
                ++i;
            }
            clientKey = sb.toString();
            StoreUtils.putValue(context, "client_key", clientKey);
        }
        return clientKey;
    }

    @TargetApi(value=3)
    public static String getClientId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getAlixTid(Context context) {
        if (Utils.isEmpty4AlixTid(context)) {
            return "";
        }
        return StoreUtils.getValue(context, "alix_tid");
    }

    public static boolean isEmpty4AlixTid(Context context) {
        String alixTid = StoreUtils.getValue(context, "alix_tid");
        return TextUtils.isEmpty((CharSequence)alixTid);
    }

    public static String getUserAgent(Context context) {
        String fv = Utils.getOsInfo(context);
        String kv = Utils.getKernelVersion(context);
        String locale = Utils.getDefaultLocale(context);
        String resolution = Utils.getScreenResolution(context);
        StringBuilder sb = new StringBuilder();
        return sb.append(" (").append(fv).append(";").append(kv).append(";").append(locale).append(";").append(";").append(resolution).append(")").append("(sdk android)").toString();
    }

    private static String getOsInfo(Context context) {
        return "Android " + Build.VERSION.RELEASE;
    }

    public static String getKernelVersion(Context context) {
        String fkv = Utils.getFormattedKernelVersion();
        int i = fkv.indexOf("-");
        if (i != -1) {
            fkv = fkv.substring(0, i);
        }
        if ((i = fkv.indexOf("\n")) != -1) {
            fkv = fkv.substring(0, i);
        }
        return "Linux " + fkv;
    }

    public static String getFormattedKernelVersion() {
        Matcher m;
        block9: {
            block8: {
                try {
                    String procVersionStr;
                    BufferedReader reader = new BufferedReader(new FileReader("/proc/version"), 256);
                    try {
                        procVersionStr = reader.readLine();
                    }
                    finally {
                        reader.close();
                    }
                    String PROC_VERSION_REGEX = "\\w+\\s+\\w+\\s+([^\\s]+)\\s+\\(([^\\s@]+(?:@[^\\s.]+)?)[^)]*\\)\\s+\\((?:[^(]*\\([^)]*\\))?[^)]*\\)\\s+([^\\s]+)\\s+(?:PREEMPT\\s+)?(.+)";
                    Pattern p = Pattern.compile("\\w+\\s+\\w+\\s+([^\\s]+)\\s+\\(([^\\s@]+(?:@[^\\s.]+)?)[^)]*\\)\\s+\\((?:[^(]*\\([^)]*\\))?[^)]*\\)\\s+([^\\s]+)\\s+(?:PREEMPT\\s+)?(.+)");
                    m = p.matcher(procVersionStr);
                    if (m.matches()) break block8;
                    return "Unavailable";
                }
                catch (IOException e) {
                    return "Unavailable";
                }
            }
            if (m.groupCount() >= 4) break block9;
            return "Unavailable";
        }
        return m.group(1) + "\n" + m.group(2) + " " + m.group(3) + "\n" + m.group(4);
    }

    public static String getDefaultLocale(Context context) {
        Resources res = context.getResources();
        Configuration cfg = res.getConfiguration();
        Locale locale = cfg.locale;
        return locale.toString();
    }

    public static String getScreenResolution(Context context) {
        DisplayMetrics displayMetrics = Utils.getDisplayMetrics(context);
        StringBuilder resolution = new StringBuilder();
        resolution.append(displayMetrics.widthPixels);
        resolution.append("*");
        resolution.append(displayMetrics.heightPixels);
        return resolution.toString();
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics metrics = new DisplayMetrics();
        Display disp = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        disp.getMetrics(metrics);
        return metrics;
    }

    public static boolean retrieveApkFromAssets(Context context, String fileName, String path) {
        boolean bRet = false;
        try {
            InputStream is = context.getAssets().open(fileName);
            File file = new File(path);
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = is.read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            is.close();
            bRet = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return bRet;
    }

    public static PackageInfo getApkInfo(Context context, String archiveFilePath) {
        PackageManager pm = context.getPackageManager();
        PackageInfo apkInfo = pm.getPackageArchiveInfo(archiveFilePath, 128);
        return apkInfo;
    }

    public static void installApk(Activity context, String cachePath) {
        Utils.chmod("777", cachePath);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.setDataAndType(Uri.parse((String)("file://" + cachePath)), "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    public static int compareVersion(String srcVersion, String destVersion) {
        ArrayList<String> sv = new ArrayList<String>();
        ArrayList<String> dv = new ArrayList<String>();
        sv.addAll(Arrays.asList(srcVersion.split("\\.")));
        dv.addAll(Arrays.asList(destVersion.split("\\.")));
        int maxLen = Math.max(sv.size(), dv.size());
        while (sv.size() < maxLen) {
            sv.add("0");
        }
        while (dv.size() < maxLen) {
            dv.add("0");
        }
        int i = 0;
        while (i < maxLen) {
            if (Integer.parseInt((String)sv.get(i)) != Integer.parseInt((String)dv.get(i))) {
                return Integer.parseInt((String)sv.get(i)) - Integer.parseInt((String)dv.get(i));
            }
            ++i;
        }
        return 0;
    }
}

