/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.android.app.widget;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import com.alipay.android.app.lib.ResourceMap;

public class Loading {
    private Activity mContext;
    private ProgressDialog mProgress;

    public Loading(Activity context) {
        this.mContext = context;
    }

    public boolean isShowing() {
        return this.mProgress != null && this.mProgress.isShowing();
    }

    public void show() {
        this.show(ResourceMap.getString_processing());
    }

    public void show(int messageResId) {
        this.show(this.mContext.getText(messageResId));
    }

    private void show(final CharSequence message) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                if (Loading.this.mProgress == null || !Loading.this.mProgress.isShowing()) {
                    Loading.this.dismiss();
                    Loading.this.mProgress = new ProgressDialog((Context)Loading.this.mContext);
                    Loading.this.mProgress.setCancelable(false);
                    Loading.this.mProgress.setMessage(message);
                    Loading.this.mProgress.show();
                } else {
                    Loading.this.mProgress.setMessage(message);
                }
            }
        };
        this.mContext.runOnUiThread(action);
    }

    public void dismiss() {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                try {
                    if (Loading.this.isShowing()) {
                        Loading.this.mProgress.dismiss();
                        Loading.this.mProgress = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.mContext.runOnUiThread(action);
    }
}

