package com.fleaphpnet;

import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Html;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.view.BaseActivity;

import org.apache.http.NameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class ArticleDetailActivity extends BaseActivity {
    private MainFrameTask mMainFrameTask = null;
    private Loadingprogressdialog progressDialog = null;
    private TextView mtextviewtitle;
    private EditText mtextviewcontent;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.more_notice_list_news);

        mtextviewtitle = (TextView) findViewById(R.id.notice_title);
        mtextviewcontent = (EditText) findViewById(R.id.notice_containt);

        Intent intent = this.getIntent();
        if (intent != null) {
            String itemsid = intent.getStringExtra("listitems");
            mMainFrameTask = new MainFrameTask(mMainFrameTask, itemsid);
            mMainFrameTask.execute();
        }
    }

    public void onAction(View v) {
        // TODO Auto-generated method stub
        switch (v.getId()) {
            case R.id.more_news_backid:
                ArticleDetailActivity.this.finish();
                break;
            default:
                break;
        }
    }

    @Override
    protected void onDestroy() {

        stopProgressDialog();

        if (mMainFrameTask != null && !mMainFrameTask.isCancelled()) {

            mMainFrameTask.cancel(true);

        }

        super.onDestroy();

    }

    private void startProgressDialog() {

        if (progressDialog == null) {

            progressDialog = Loadingprogressdialog.createDialog(this);
            progressDialog.setCancelable(false);
            progressDialog.setMessage("正在加载数据...");

        }

        progressDialog.show();

    }

    private void stopProgressDialog() {

        if (progressDialog != null) {

            progressDialog.dismiss();

            progressDialog = null;

        }

    }

    //获取验证码
    public class MainFrameTask extends
            AsyncTask<JSONObject, String, JSONObject> {

        private MainFrameTask mainFrame = null;
        private String val1;

        public MainFrameTask(MainFrameTask mainFrame, String val1) {
            super();
            this.mainFrame = mainFrame;
            this.val1 = val1;
        }

        @Override
        protected void onCancelled() {

            stopProgressDialog();

            super.onCancelled();

        }

        @Override
        protected void onPreExecute() {

            startProgressDialog();

        }

        @Override
        protected void onPostExecute(JSONObject result) {// 可以与UI控件交互
            System.out.println("-----result--->" + result);
            try {
                String winpz = result.getString("Value");
                JSONObject jsoncontent = new JSONObject(winpz);
                mtextviewtitle.setText(Html.fromHtml(jsoncontent.getString("Category")));
                mtextviewcontent.setText(Html.fromHtml(jsoncontent.getString("Description")));
            } catch (JSONException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            stopProgressDialog();
        }

        @Override
        protected JSONObject doInBackground(JSONObject... params) {

            String msgid = "wenzhangxiangxi";
            String par1 = "ArticleId";
            List<NameValuePair> namevalue = XinTiJson.Oneparameter1(XinTiRequestcode.Select_article_detailed_Code, msgid, par1, val1);
            JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
            return jsonobj;
        }

        @Override
        protected void onProgressUpdate(String... values) {
            // 可以与UI控件交互
            super.onProgressUpdate(values);
        }
    }
}
