package com.fleaphpnet.Huiyuan;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.loopj.android.http.JsonHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.fleaphpnet.Application;
import com.fleaphpnet.XinTiRequestcode;
import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.caiyuntong.component.HttpUtils;
import com.fleaphpnet.dialog.xinTiDialogview;
import com.fleaphpnet.view.BaseActivity;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * 绑定银行卡
 *
 * @author Administrator
 */
public class UserBindBankCardActivity extends BaseActivity {
    //private MainFrameTask mMainFrameTask = null;
    private Loadingprogressdialog progressDialog = null;

    private String[] banckname = {"中国工商银行(ICBC)", "中国建设银行(CCB)",
            "中国农业银行(ABC)", "中国银行(BOC)", "招商银行(CMB)", "交通银行(BCM)", "广发银行(GDB)",
            "中信银行(CNCB)", "兴业银行(CIB)", "农村信用合作社(CUB)", "上海浦发银行(SPDB)",
            "邮政储蓄银行(CSBC)", "东亚银行(BEA)"};
    private String[] banckname_English = {
            "Industrial and Commercial Bank of China",
            "China Construction Bank", "Agriculture Bank of China",
            "Bank of China", "China Merchant Bank", "Bank of Communication",
            "Guangdong Development Bank", "China Citic Bank",
            "Industrial Bank", "Chinese Rural Credit Cooperatives",
            "Shanghai Pudong Development Bank", "Postal Savings Bank Of China",
            "The Bank of East Asia (China) Limited"};
    private String[] shengfenname = {"北京市", "上海市", "天津市", "重庆市", "河北省", "山西省",
            "内蒙古自治区", "辽宁省", "吉林省", "黑龙江省", "江苏省", "浙江省", "安徽省", "福建省", "江西省",
            "山东省", "河南省", "湖北省", "湖南省", "广东省", "广西壮族自治区", "海南省", "四川省", "云南省",
            "西藏在自治区", "陕西省", "甘肃省", "宁夏回族自治区", "新疆维吾尔族自治区", "香港特别行政区",
            "澳门特别行政区", "台湾省"};
    private String[] shengfenname_English = {"BeiJin", "ShangHai", "TianJing",
            "chongqing", "HeBei", "ShanXi", "NeiMengGu", "LiaoNing", "JiLing",
            "HeilongJiang", "JjiangShu", "ZheJiang", "AnHui", "FuJian",
            "JiangXi", "ShanDong", "HeNan", "HuBei", "HuNan", "GuangDong",
            "GuangXi", "HaiNan", "Sichuan", "YunNan", "XiZhang", "ShanXi",
            "GanShu", "LingXia", "XinJiang", "XiangGang", "AoMen", "TaiWan"};

    private Spinner mySpinner, mySpinner1;
    private ArrayAdapter<String> adapter;
    private String select_bank_name, bank_idname, city_idname, select_jiancheng;
    private String bankname1, shengfenname1;
    private EditText bankid;
    private TextView bangdingxinxi;
    private xinTiDialogview ada;
    //银行卡账号
    private EditText banknumber;

    // add by lizf
    private Context mContext;
    private SharedPreferences mSharedPreference;
    private Spinner mBankSpinner, mProvinceSpinner, mCitySpinner;
    private EditText mAccountNameInput;
    private ArrayList<String> mBankName, mProvinceName, mCityName;
    private ArrayList<Integer> mBankId, mProvinceId, mCityId;
    private JSONArray mBankArray, mProvinceArray;
    private ArrayAdapter<String> mBankAdapter, mProvinceAdapter, mCityAdapter;

    // 缓存用的key
    public static String CACHE_BANK_KEY = "cache_bank_key";
    public static String CACHE_PROVINCE_KEY = "cache_province_key";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.huiyuan_addbangding);
        mContext = getBaseContext();
        //shiTi();
        //cityname = (EditText) findViewById(R.id.city_name);
        bankid = (EditText) findViewById(R.id.bank_id);
        bangdingxinxi = (TextView) findViewById(R.id.bangdingyinhangka_tishi);

        mBankSpinner = (Spinner) findViewById(R.id.bank_name);
        mProvinceSpinner = (Spinner) findViewById(R.id.shengfen_name);
        mCitySpinner = (Spinner) findViewById(R.id.city_name);

        mBankName = new ArrayList<String>();
        mProvinceName = new ArrayList<String>();
        mCityName = new ArrayList<String>();

        mBankId = new ArrayList<Integer>();
        mProvinceId = new ArrayList<Integer>();
        mProvinceId = new ArrayList<Integer>();

        mBankAdapter = new ArrayAdapter<String>(mContext, android.R.layout.simple_spinner_item, mBankName);
        mBankAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mProvinceAdapter = new ArrayAdapter<String>(mContext, android.R.layout.simple_spinner_item, mProvinceName);
        mProvinceAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mCityAdapter = new ArrayAdapter<String>(mContext, android.R.layout.simple_spinner_item, mCityName);
        mCityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);

        // 先读取缓存, 如果有, 就不请求网络了
        mSharedPreference = getSharedPreferences("cache", Context.MODE_PRIVATE);
        String mBankList = mSharedPreference.getString(CACHE_BANK_KEY, "");
        String mProvinceList = mSharedPreference.getString(CACHE_PROVINCE_KEY, "");
        if (mBankList.equals("")) {
            cacheBankData();
        } else {
            try {
                mBankArray = new JSONArray(mBankList);
                for (int i = 0; i < mBankArray.length(); i++) {
                    JSONObject bank = mBankArray.getJSONObject(i);
                    mBankName.add(bank.getString("bankname"));
                    mBankId.add(bank.getInt("id"));
                }
                mBankAdapter.notifyDataSetChanged();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (mProvinceList.equals("")) {
            cacheProvinceData();
        } else {
            try {
                mProvinceArray = new JSONArray(mProvinceList);
                for (int i = 0; i < mProvinceArray.length(); i++) {
                    JSONObject bank = mProvinceArray.getJSONObject(i);
                    mProvinceName.add(bank.getString("province"));
                    mProvinceId.add(bank.getInt("provinceid"));
                }
                mProvinceAdapter.notifyDataSetChanged();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        ada = new xinTiDialogview(UserBindBankCardActivity.this);
        //spinner1();
        List<String> list = new ArrayList<String>();
        // 第一步：添加一个下拉列表项的list，这里添加的项就是下拉列表的菜单项
        for (int i = 0; i < banckname.length; i++) {
            list.add(banckname[i]);
        }
        mySpinner = (Spinner) findViewById(R.id.bank_name);
        // 第二步：为下拉列表定义一个适配器，这里就用到里前面定义的list。
        adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, list);
        // 第三步：为适配器设置下拉列表下拉时的菜单样式。
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        // 第四步：将适配器添加到下拉列表上
        mySpinner.setAdapter(mBankAdapter);
        // 第五步，给spinner添加一个标题
        mySpinner.setPrompt("选择银行");
        // 第六步：为下拉列表设置各种事件的响应，这个事响应菜单被选中
        mySpinner.setOnItemSelectedListener(new Spinner.OnItemSelectedListener() {
            //public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            //    /* 将mySpinner 显示 */
            //    arg0.setVisibility(View.VISIBLE);
            //    // 得到选中项的值
            //    select_bank_name = mySpinner.getSelectedItem().toString();
            //}

            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {

            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }

            //public void onNothingSelected(AdapterView<?> arg0) {
            //    arg0.setVisibility(View.VISIBLE);
            //}
        });
        /* 下拉菜单弹出的内容选项触屏事件处理 */
        mySpinner.setOnTouchListener(new Spinner.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return false;
            }
        });
        /* 下拉菜单弹出的内容选项焦点改变事件处理 */
        mySpinner.setOnFocusChangeListener(new Spinner.OnFocusChangeListener() {
            public void onFocusChange(View v, boolean hasFocus) {
                v.setVisibility(View.VISIBLE);
            }
        });

        //spinner2();
        List<String> list1 = new ArrayList<String>();
        // 第一步：添加一个下拉列表项的list，这里添加的项就是下拉列表的菜单项
        for (int i = 0; i < shengfenname.length; i++) {
            list1.add(shengfenname[i]);
        }
        mySpinner1 = (Spinner) findViewById(R.id.shengfen_name);
        // 第二步：为下拉列表定义一个适配器，这里就用到里前面定义的list。
        adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, list1);
        // 第三步：为适配器设置下拉列表下拉时的菜单样式。
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        // 第四步：将适配器添加到下拉列表上
        mySpinner1.setAdapter(mProvinceAdapter);
        // 第五步，给spinner添加一个标题
        mySpinner1.setPrompt("选择省份");
        // 第六步：为下拉列表设置各种事件的响应，这个事响应菜单被选中
        mySpinner1.setOnItemSelectedListener(new Spinner.OnItemSelectedListener() {
            public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                /* 将mySpinner 显示 */
                arg0.setVisibility(View.VISIBLE);
            }
            public void onNothingSelected(AdapterView<?> arg0) {
                arg0.setVisibility(View.VISIBLE);
            }
        });
        /* 下拉菜单弹出的内容选项触屏事件处理 */
        mySpinner1.setOnTouchListener(new Spinner.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return false;
            }
        });
        /* 下拉菜单弹出的内容选项焦点改变事件处理 */
        mySpinner.setOnFocusChangeListener(new Spinner.OnFocusChangeListener() {
            public void onFocusChange(View v, boolean hasFocus) {
                v.setVisibility(View.VISIBLE);
            }
        });
    }

    public void cacheProvinceData() {
        RequestParams params = Application.buildRequest("120", "");
        HttpUtils.post(XinTiRequestcode.Request_internet, params, new JsonHttpResponseHandler() {
            @Override
            public void onSuccess(JSONObject jsonObject) {
                super.onSuccess(jsonObject);
                try {
                    String value = jsonObject.getString("Value");
                    String code = jsonObject.getString("Code");
                    if (code.equals("101")) {
                        mProvinceArray = jsonObject.getJSONArray("Value");
                        for (int i = 0; i < mProvinceArray.length(); i++) {
                            JSONObject bank = mProvinceArray.getJSONObject(i);
                            mProvinceName.add(bank.getString("province"));
                            mProvinceId.add(bank.getInt("provinceid"));
                        }
                        mProvinceAdapter.notifyDataSetChanged();
                        mSharedPreference.edit().putString(CACHE_PROVINCE_KEY, value).commit();
                        System.out.println("---------->" + value);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(Throwable throwable, JSONObject jsonObject) {
                super.onFailure(throwable, jsonObject);
                throwable.printStackTrace();
            }

            @Override
            public void onFailure(Throwable error, String content) {
                error.printStackTrace();
            }
        });
    }

    public void cacheBankData() {
        RequestParams params = Application.buildRequest("130", "");
        HttpUtils.post(XinTiRequestcode.Request_internet, params, new JsonHttpResponseHandler() {
            @Override
            public void onSuccess(JSONObject jsonObject) {
                super.onSuccess(jsonObject);
                try {
                    String value = jsonObject.getString("Value");
                    String code = jsonObject.getString("Code");
                    if (code.equals("101")) {
                        mBankArray = jsonObject.getJSONArray("Value");
                        for (int i = 0; i < mBankArray.length(); i++) {
                            JSONObject bank = mBankArray.getJSONObject(i);
                            mBankName.add(bank.getString("bankname"));
                            mBankId.add(bank.getInt("id"));
                        }
                        mSharedPreference.edit().putString(CACHE_BANK_KEY, value).commit();
                        mBankAdapter.notifyDataSetChanged();
                        System.out.println("---------->" + value);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(Throwable throwable, JSONObject jsonObject) {
                super.onFailure(throwable, jsonObject);
                throwable.printStackTrace();
            }

            @Override
            public void onFailure(Throwable error, String content) {
                error.printStackTrace();
            }
        });
    }
    public static String PARAM_USERTOKEN = "UserToken";// 用户效验值（在投注等操作时用到）
    public static String PARAM_BANKCODE = "BankCode";// 银行编码 例如：ICBC
    public static String PARAM_SUBBANKNAME = "SubBankName";// 银行全称 例如：中国工商银行
    public static String PARAM_CARDNUMBER = "Cardnumber";// 银行卡号
    public static String PARAM_PROVINCE = "Province";// 省
    public static String PARAM_CITY = "City";// 城市

    public void bindCard() {
        startProgressDialog();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PARAM_USERTOKEN, Application.hashuser.get("UserToken").toString());
            jsonObject.put(PARAM_BANKCODE, select_jiancheng);
            jsonObject.put(PARAM_SUBBANKNAME, bankname1);
            jsonObject.put(PARAM_CARDNUMBER, bank_idname);
            jsonObject.put(PARAM_PROVINCE, shengfenname1);
            jsonObject.put(PARAM_CITY, city_idname);
        } catch (JSONException e) {
            e.printStackTrace();
            Toast.makeText(mContext, "选定的数据有错误", Toast.LENGTH_SHORT).show();
            return;
        }

        // 构建访问用的参数
        RequestParams params = Application.buildRequest(XinTiRequestcode.Binding_Bankcard_Code, jsonObject);
        HttpUtils.post(XinTiRequestcode.Request_internet, params, new JsonHttpResponseHandler() {
            @Override
            public void onSuccess(JSONObject jsonObject) {
                super.onSuccess(jsonObject);
                try {
                    String value = jsonObject.getString("Value");
                    String code = jsonObject.getString("Code");
                    if (code.equals("101")) {
                        System.out.println("---------->" + value.toString());
                        ada.AlertTishi(value);
                        bangdingxinxi.setText("银行卡绑定成功");
                        Application.hashuser.put("IdCardNumber", bank_idname);
                    } else {
                        bangdingxinxi.setText(value);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                stopProgressDialog();
            }

            @Override
            public void onFailure(Throwable throwable, JSONObject jsonObject) {
                super.onFailure(throwable, jsonObject);
                throwable.printStackTrace();
                stopProgressDialog();
            }

            @Override
            public void onFailure(Throwable error, String content) {
                error.printStackTrace();
                stopProgressDialog();
            }
        });
    }

    public void onAction(View v) {
        switch (v.getId()) {
            case R.id.bangdingyinhang_tijiao:
                select_jiancheng = select_bank_name.substring(select_bank_name.indexOf("(") + 1, select_bank_name.indexOf(")"));
                bankname1 = banckname_English[Integer.parseInt(mySpinner.getSelectedItemId() + "")];
                shengfenname1 = shengfenname_English[Integer.parseInt(mySpinner1.getSelectedItemId() + "")];
                bank_idname = bankid.getText().toString();
                city_idname = mCityId.get(mCitySpinner.getSelectedItemPosition()).toString();
                if (bank_idname.length() == 0 || city_idname.length() == 0) {
                    Toast.makeText(UserBindBankCardActivity.this, "录入不能为空！", Toast.LENGTH_SHORT).show();
                } else {
                    bindCard();
                    //mMainFrameTask = new MainFrameTask(mMainFrameTask);
                    //mMainFrameTask.execute();
                }
                break;
            case R.id.huiyuan_bindingcard_item_backid:
                this.finish();
                break;
            default:
                break;
        }

    }

    @Override
    protected void onDestroy() {
        stopProgressDialog();
        super.onDestroy();
    }

    private void startProgressDialog() {
        if (progressDialog == null) {
            progressDialog = Loadingprogressdialog.createDialog(this);
            progressDialog.setCancelable(false);
            progressDialog.setMessage("正在加载数据...");
        }
        progressDialog.show();

    }

    private void stopProgressDialog() {
        if (progressDialog != null) {
            progressDialog.dismiss();
            progressDialog = null;
        }
    }
}
