package com.fleaphpnet.Huiyuan;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

import com.fleaphpnet.XinTiJson;
import com.fleaphpnet.XinTiJsonjiexi;
import com.fleaphpnet.XinTiPostQuery;
import com.fleaphpnet.XinTiRequestcode;
import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.dialog.SJisNullorH;
import com.fleaphpnet.Application;
import com.fleaphpnet.msg.XinTiselectDate;
import com.fleaphpnet.view.BaseActivity;

import org.apache.http.NameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 账户明细
 *
 * @author Administrator
 */
public class UserCashDetailActivity extends BaseActivity {
    private Loadingprogressdialog progressDialog = null;
    private MainFrameTask mMainFrameTask = null;
    private List<String> list = new ArrayList<String>();
    private ArrayList<String> zhsgorys;
    private ArrayList<String> zhndates;
    private ArrayList<String> zhmoneys;
    private ArrayList<String> zhtypes;
    private ArrayList<String> zhcontents;

    // 计算支出金额
    private double zhichumoney = 0;
    // 计算收入金额
    private double shourumoney = 0;
    private String totalPay = "";
    private TextView tezhichumoney, teshourumoney;

    private ListView mlist;
    // private Spinner mySpinner;
    private ArrayAdapter<String> adapter;

    private LinearLayout mli;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.huiyuan_zhanghubuying_record);

        //shiTi();
        mlist = (ListView) findViewById(R.id.zhanghuRecord_choice_list);
        tezhichumoney = (TextView) findViewById(R.id.zhanghu_zhichumoney);
        teshourumoney = (TextView) findViewById(R.id.zhanghu_shourumoney);
        mli = (LinearLayout) findViewById(R.id.isnullshowid);

        mMainFrameTask = new MainFrameTask(progressDialog, UserCashDetailActivity.this, mMainFrameTask);
        mMainFrameTask.execute();
        tezhichumoney.setText(totalPay);
        // zhanghu_spinner();
    }

    // list
    public void ZhmxQuery() {
        zhanghu_listview myzhanghuAdapter = new zhanghu_listview(UserCashDetailActivity.this, zhsgorys, zhmoneys, zhtypes, zhndates, zhcontents);
        mlist.setAdapter(myzhanghuAdapter);
    }

    public void onAction(View v) {
        switch (v.getId()) {
            case R.id.zhanghuxiangxi_register_back:
                UserCashDetailActivity.this.finish();
                break;
            default:
                break;
        }
    }

    class zhanghu_listview extends BaseAdapter {
        Context conn;
        private ArrayList<String> zhsgorysad;
        private ArrayList<String> zhtypesad;
        private ArrayList<String> zhmoneysad;
        private ArrayList<String> zhndatesad;
        private ArrayList<String> zhcontentsad;

        public zhanghu_listview(Context conn, ArrayList<String> zhsgorysad,
                                ArrayList<String> zhtypesad, ArrayList<String> zhmoneysad,
                                ArrayList<String> zhndatesad, ArrayList<String> zhcontentsad) {
            super();
            this.conn = conn;
            this.zhsgorysad = zhsgorysad;
            this.zhtypesad = zhtypesad;
            this.zhmoneysad = zhmoneysad;
            this.zhndatesad = zhndatesad;
            this.zhcontentsad = zhcontentsad;
        }

        @Override
        public int getCount() {
            return zhsgorys.size();
        }

        @Override
        public Object getItem(int position) {
            return zhsgorys.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView mtextView, mtextView1, mtextView2, mtextView3, mtextView4;
            if (convertView == null) {
                convertView = LayoutInflater.from(UserCashDetailActivity.this).inflate(R.layout.huiyuan_zhanghubuying_record_list_item, null);
            }
            mtextView = (TextView) convertView.findViewById(R.id.zhanghu_record_item_text);
            mtextView.setText(zhsgorys.get(position));

            mtextView2 = (TextView) convertView.findViewById(R.id.zhmoneys_text);
            mtextView2.setText(zhmoneys.get(position));
            mtextView3 = (TextView) convertView.findViewById(R.id.zhtypes_text);
            mtextView3.setText(zhtypes.get(position) + ":");
            mtextView1 = (TextView) convertView.findViewById(R.id.zhndates_text);
            mtextView1.setText("日期：" + XinTiselectDate.JiezhiDate(zhndates.get(position)));
            mtextView4 = (TextView) convertView.findViewById(R.id.zhcontents_text);
            mtextView4.setText(zhcontents.get(position));
            totalPay += zhmoneysad.get(position);
            return convertView;
        }
    }

    // 查询账户明细
    public class MainFrameTask extends AsyncTask<JSONObject, String, JSONObject> {
        private Loadingprogressdialog progressDialog = null;
        Context mconn;
        private MainFrameTask mainFrame = null;

        public MainFrameTask(Loadingprogressdialog progressDialog, Context mconn, MainFrameTask mainFrame) {
            super();
            this.progressDialog = progressDialog;
            this.mconn = mconn;
            this.mainFrame = mainFrame;
        }

        private void startProgressDialog() {
            if (progressDialog == null) {
                progressDialog = Loadingprogressdialog.createDialog(mconn);
                progressDialog.setCancelable(false);
                progressDialog.setMessage("正在加载中...");
            }
            progressDialog.show();
        }

        private void stopProgressDialog() {
            if (progressDialog != null) {
                progressDialog.dismiss();
                progressDialog = null;
            }
        }

        @Override
        protected void onCancelled() {
            stopProgressDialog();
            super.onCancelled();
        }

        @Override
        protected void onPreExecute() {
            startProgressDialog();
        }

        @Override
        protected void onPostExecute(JSONObject result) {// 可以与UI控件交互
            try {
                String mixi = result.getString("Value");
                List<Map<String, String>> zhanghu = XinTiJsonjiexi.getJSONArrayzhanghu(mixi);
                zhsgorys = new ArrayList<String>();
                zhtypes = new ArrayList<String>();
                zhmoneys = new ArrayList<String>();
                zhndates = new ArrayList<String>();
                zhcontents = new ArrayList<String>();
                String type;
                for (int i = 0; i < zhanghu.size(); i++) {
                    zhsgorys.add(zhanghu.get(i).get("Category"));
                    System.out.println("---Category------>" + zhanghu.get(i).get("Category"));
                    System.out.println("---PayType------>" + zhanghu.get(i).get("PayType"));
                    System.out.println("---PayMoney------>" + zhanghu.get(i).get("PayMoney"));
                    System.out.println("---CreateTime------>" + zhanghu.get(i).get("CreateTime"));
                    System.out.println("---Summary------>" + zhanghu.get(i).get("Summary"));
                    String py = zhanghu.get(i).get("PayType");

                    zhichumoney += Double.parseDouble(zhanghu.get(i).get("PayMoney"));

                    if (py.equals("10")) {
                        type = "支出";
                    } else {
                        type = "收入";
                    }
                    zhtypes.add(type);
                    zhmoneys.add(zhanghu.get(i).get("PayMoney"));
                    zhndates.add(zhanghu.get(i).get("CreateTime"));
                    zhcontents.add(zhanghu.get(i).get("Summary"));
                }

                tezhichumoney.setText(zhichumoney + "");
                ZhmxQuery();
                HashMap<String, Object> hashmoney = new HashMap<String, Object>();
                for (int i = 0; i < zhtypes.size(); i++) {
                    if (zhtypes.equals("支出")) {
                        System.out.println("---zhmoneys------>" + zhmoneys.get(i));
                        zhichumoney += Double.parseDouble(zhmoneys.get(i));
                    }
                    // tezhichumoney.setText(zhichumoney);
                    if (zhtypes.equals("收入")) {
                        shourumoney += Double.parseDouble(zhmoneys.get(i));
                    }
                }
                SJisNullorH.ISNull(mli, zhtypes);
                teshourumoney.setText(shourumoney + "");
            } catch (JSONException e) {
                e.printStackTrace();
                System.out.println("----登陆失败----->");
                stopProgressDialog();
            } catch (NullPointerException n) {
                n.printStackTrace();
                System.out.println("----服务器连接超时----->");
                stopProgressDialog();
            } catch (Exception e) {
                e.printStackTrace();
            }
            stopProgressDialog();
        }

        @Override
        protected JSONObject doInBackground(JSONObject... params) {
            String msgid = "zhanghumixi";
            String parameters1 = "UserToken";
            String values1 = Application.hashuser.get("UserToken").toString();
            List<NameValuePair> namevalue = XinTiJson.Oneparameter1(XinTiRequestcode.Select_Bandroll_detail_Code, msgid, parameters1, values1);
            JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
            return jsonobj;
        }

        @Override
        protected void onProgressUpdate(String... values) {
            // 可以与UI控件交互
            super.onProgressUpdate(values);
        }
    }

    @Override
    protected void onDestroy() {
        if (mMainFrameTask != null && !mMainFrameTask.isCancelled()) {
            mMainFrameTask.cancel(true);
        }
        super.onDestroy();
    }

}
