package com.fleaphpnet.Huiyuan;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.alipay.android.app.sdk.AliPay;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.pay.Keys;
import com.fleaphpnet.pay.Result;
import com.fleaphpnet.pay.Rsa;
import com.fleaphpnet.view.BaseActivity;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 模拟商户应用的商品列表，交易步骤。
 * <p/>
 * 1. 将商户ID，收款帐号，外部订单号，商品名称，商品介绍，价格，通知地址封装成订单信息 2. 对订单信息进行签名 3.
 * 将订单信息，签名，签名方式封装成请求参数 4. 调用pay方法
 *
 * @version v4_0413 2012-03-02
 */
public class XinTiBuying_Pay extends BaseActivity {
    static String TAG = "XinTiBuying_Pay";

    private static final int RQF_PAY = 1;
    private EditText medtextshuru;
    private Button mbuttonsub;

    //
    // Called when the activity is first created.
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.v(TAG, "onCreate");
        setContentView(R.layout.huiyuan_pay);
        HQSBPRICE("", "充值");
        shiTi();

    }

    public void shiTi() {
        medtextshuru = (EditText) findViewById(R.id.payedtext);
        mbuttonsub = (Button) findViewById(R.id.paysubmit);
        mbuttonsub.setOnClickListener(new MysubButton());
    }

    public void onAction(View v) {
        switch (v.getId()) {
            case R.id.goucai_item_backid:
                this.finish();
                break;
            case R.id.pay10:
                medtextshuru.setText("10");
                break;
            case R.id.pay20:
                medtextshuru.setText("20");
                break;
            case R.id.pay30:
                medtextshuru.setText("30");
                break;
            case R.id.pay50:
                medtextshuru.setText("50");
                break;
            case R.id.pay100:
                medtextshuru.setText("100");
                break;
            case R.id.pay200:
                medtextshuru.setText("200");
                break;
            case R.id.pay500:
                medtextshuru.setText("500");
                break;
            default:
                break;
        }
    }

    class MysubButton implements OnClickListener {

        @Override
        public void onClick(View v) {
            String paymoney = medtextshuru.getText().toString();
            if (paymoney.length() == 0) {
                Animation shake1 = AnimationUtils.loadAnimation(
                        XinTiBuying_Pay.this, R.anim.shake);
                findViewById(R.id.payedtext).startAnimation(shake1);
                Toast.makeText(XinTiBuying_Pay.this, "输入不能为空",
                        Toast.LENGTH_SHORT).show();

            } else {
                /**
                 * 传如类型，订单信息，价格
                 */

                TJdanDan(paymoney);
            }
        }

    }


    /**
     * 构建订单信息表
     *
     * @param position
     * @return
     */
    private String getOutTradeNo() {
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss");
        Date date = new Date();
        String key = format.format(date);

        java.util.Random r = new java.util.Random();
        key += r.nextInt();
        key = key.substring(0, 15);
        Log.d(TAG, "outTradeNo: " + key);
        return key;
    }

    private String getNewOrderInfo(String money) {
        Product pro = new Product();
        StringBuilder sb = new StringBuilder();
        sb.append("partner=\"");
        sb.append(Keys.DEFAULT_PARTNER);
        sb.append("\"&out_trade_no=\"");
        sb.append(getOutTradeNo());
        sb.append("\"&subject=\"");
        sb.append(pro.subject);
        sb.append("\"&body=\"");
        sb.append(pro.body);
        sb.append("\"&total_fee=\"");
        sb.append(money);
        sb.append("\"&notify_url=\"");

        // 网址需要做URL编码
        sb.append(URLEncoder.encode("http://notify.java.jpxx.org/index.jsp"));
        sb.append("\"&service=\"mobile.securitypay.pay");
        sb.append("\"&_input_charset=\"UTF-8");
        sb.append("\"&return_url=\"");
        sb.append(URLEncoder.encode("http://m.alipay.com"));
        sb.append("\"&payment_type=\"1");
        sb.append("\"&seller_id=\"");
        sb.append(Keys.DEFAULT_SELLER);

        // 如果show_url值为空，可不传
        // sb.append("\"&show_url=\"");
        sb.append("\"&it_b_pay=\"1m");
        sb.append("\"");

        return new String(sb);
    }


    /**
     * 提交订单
     *
     * @param fileName
     * @return
     */
    public void TJdanDan(String money) {
        try {
            Log.i(TAG, "onItemClick");
            String info = getNewOrderInfo(money);
            String sign = Rsa.sign(info, GetFromAssetsAll("xinti.txt"));
            sign = URLEncoder.encode(sign);
            info += "&sign=\"" + sign + "\"&" + getSignType();
            Log.i("ExternalPartner", "start pay");
            // start the pay.
            Result.sResult = null;
            Log.i(TAG, "info = " + info);
            final String orderInfo = info;
            new Thread() {
                public void run() {
                    String result = new AliPay(XinTiBuying_Pay.this, mHandler)
                            .pay(orderInfo);

                    Log.i(TAG, "result = " + result);
                    Message msg = new Message();
                    msg.what = RQF_PAY;
                    msg.obj = result;
                    mHandler.sendMessage(msg);
                }
            }.start();

        } catch (Exception ex) {
            ex.printStackTrace();
            Toast.makeText(XinTiBuying_Pay.this, R.string.remote_call_failed,
                    Toast.LENGTH_SHORT).show();
        }
    }

    Handler mHandler = new Handler() {
        public void handleMessage(android.os.Message msg) {
            Result.sResult = (String) msg.obj;

            switch (msg.what) {
                case RQF_PAY: {
                    Toast.makeText(XinTiBuying_Pay.this, Result.getResult(),
                            Toast.LENGTH_SHORT).show();

                }
                break;
                default:
                    break;
            }
        }

        ;
    };

    private String getSignType() {
        return "sign_type=\"RSA\"";
    }

    /**
     * 订单类容
     */
    public static class Product {
        public String subject;
        public String body;
    }

    /**
     * 获取订单信息
     */
    public void HQSBPRICE(String subject, String body) {
        Product pro = new Product();
        pro.subject = subject;
        pro.body = body;
    }


    /**
     * 获取密钥
     *
     * @param fileName
     * @return
     */
    public String GetFromAssetsAll(String filename) {
        String str = null;
        try {
            InputStream is = getAssets().open(filename);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            str = new String(buffer);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return str;

    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            new AlertDialog.Builder(this).setTitle("提示").setMessage("您是否确定退出支付?").setNegativeButton("取消", new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton("确定", new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialog, int whichButton) {
                    finish();
                }

            }).show();

            return true;
        }

        return false;
    }

    public void showTipDialog(String title, String message, int titleIcon) {
        AlertDialog.Builder tDialog = new AlertDialog.Builder(this);
        tDialog.setTitle(title);
        tDialog.setMessage(message);
        tDialog.setIcon(titleIcon);
        tDialog.setPositiveButton("关闭", null);
        tDialog.show();
    }
}
