package com.fleaphpnet.Huiyuan;

import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

import com.fleaphpnet.XinTiJson;
import com.fleaphpnet.XinTiPostQuery;
import com.fleaphpnet.XinTiRequestcode;
import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.view.BaseActivity;

import org.apache.http.NameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * 查询银行信息
 *
 * @author Administrator
 */
public class XinTihuiyuan_selectbanknumber_name extends BaseActivity {
    private Button mbanknumber;
    private MainFrameTask mMainFrameTask = null;
    private Loadingprogressdialog progressDialog = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.selectbanknumber_bnd_bame);
        mbanknumber = (Button) findViewById(R.id.test);
        mbanknumber.setOnClickListener(new mybutton());
    }

    class mybutton implements OnClickListener {

        @Override
        public void onClick(View v) {
            mMainFrameTask = new MainFrameTask(mMainFrameTask);
            mMainFrameTask.execute();
        }
    }

    @Override
    protected void onDestroy() {
        stopProgressDialog();
        if (mMainFrameTask != null && !mMainFrameTask.isCancelled()) {
            mMainFrameTask.cancel(true);
        }
        super.onDestroy();

    }

    private void startProgressDialog() {
        if (progressDialog == null) {
            progressDialog = Loadingprogressdialog.createDialog(this);
            progressDialog.setCancelable(false);
            progressDialog.setMessage("正在加载数据...");
        }
        progressDialog.show();
    }

    private void stopProgressDialog() {
        if (progressDialog != null) {
            progressDialog.dismiss();
            progressDialog = null;
        }
    }

    //获取银行卡编码和名称
    public class MainFrameTask extends AsyncTask<JSONObject, String, JSONObject> {

        private MainFrameTask mainFrame = null;

        public MainFrameTask(MainFrameTask mainFrame) {
            super();
            this.mainFrame = mainFrame;
        }

        @Override
        protected void onCancelled() {
            stopProgressDialog();
            super.onCancelled();
        }

        @Override
        protected void onPreExecute() {
            startProgressDialog();
        }

        @Override
        protected void onPostExecute(JSONObject result) {// 可以与UI控件交互
            try {
                System.out.println("------bankresult------>" + result);
                String logincode = result.getString("Code");
                if (logincode.equals("101")) {
                    XinTihuiyuan_selectbanknumber_name.this.finish();
                }
            } catch (JSONException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                System.out.println("----登陆失败----->");
                stopProgressDialog();
            } catch (NullPointerException n) {
                n.printStackTrace();
                System.out.println("----服务器连接超时----->");
                stopProgressDialog();
            }
            stopProgressDialog();
        }

        @Override
        protected JSONObject doInBackground(JSONObject... params) {
            String msgid = "yinghangka";
            List<NameValuePair> namevalue = XinTiJson.Zeroparameter0(XinTiRequestcode.SET_UP_Bandroll_Code, msgid);
            JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
            return jsonobj;
        }

        @Override
        protected void onProgressUpdate(String... values) {
            // 可以与UI控件交互
            super.onProgressUpdate(values);
        }
    }
}
