package com.fleaphpnet;

import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.view.BaseActivity;

import org.apache.http.NameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NotifyActivity extends BaseActivity {
    private MainFrameTask mMainFrameTask = null;
    private Loadingprogressdialog progressDialog = null;
    private ListView mNotifyListView;
    private List<Map<String, String>> lstnotices;
    private ArrayList<String> arrtitles;
    private ArrayList<String> arrids;
    private ArrayList<String> CreateTime;
    private ArrayList<String> CreateBy;
    private TextView button;

    //判读是有无数据
    private LinearLayout mlishowtishi;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.more_notice_listview);

        mNotifyListView = (ListView) findViewById(R.id.heimai_choice_list);
        mlishowtishi = (LinearLayout) findViewById(R.id.isnullshowid);
        mlishowtishi.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                mMainFrameTask = new MainFrameTask(mMainFrameTask);
                mMainFrameTask.execute();
            }
        });

        mMainFrameTask = new MainFrameTask(mMainFrameTask);
        mMainFrameTask.execute();

        mNotifyListView.setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
                Intent intent = new Intent();
                intent.setClass(NotifyActivity.this, ArticleDetailActivity.class);
                intent.putExtra("listitems", arrids.get(position));
                startActivity(intent);
            }
        });
    }

    //绑定控件
    public void noticeListquery() {
        noticelist notice = new noticelist(arrtitles);
        mNotifyListView.setAdapter(notice);
        mNotifyListView.setDividerHeight(0);
    }

    //加载布局
    class noticelist extends BaseAdapter {
        private ArrayList<String> arrtitles;

        public noticelist(ArrayList<String> arrtitles) {
            super();
            this.arrtitles = arrtitles;
        }

        @Override
        public int getCount() {
            return arrtitles.size();
        }

        @Override
        public Object getItem(int position) {
            return arrtitles.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from(NotifyActivity.this).inflate(
                        R.layout.more_notice_list, null);
            }
            button = (TextView) convertView.findViewById(R.id.notice_btn);
            button.setText(arrtitles.get(position));
            return convertView;
        }
    }

    public void onAction(View v) {
        // TODO Auto-generated method stub
        switch (v.getId()) {
            case R.id.more_item_backid:
                NotifyActivity.this.finish();
                break;

            default:
                break;
        }
    }

    @Override
    protected void onDestroy() {
        stopProgressDialog();
        if (mMainFrameTask != null && !mMainFrameTask.isCancelled()) {
            mMainFrameTask.cancel(true);
        }
        super.onDestroy();

    }

    private void startProgressDialog() {
        if (progressDialog == null) {
            progressDialog = Loadingprogressdialog.createDialog(this);
            progressDialog.setCancelable(false);
            progressDialog.setMessage("正在加载数据...");
        }
        progressDialog.show();
    }

    private void stopProgressDialog() {
        if (progressDialog != null) {
            progressDialog.dismiss();
            progressDialog = null;
        }
    }

    //获取公告
    public class MainFrameTask extends AsyncTask<JSONObject, String, JSONObject> {
        private MainFrameTask mainFrame = null;
        public MainFrameTask(MainFrameTask mainFrame) {
            super();
            this.mainFrame = mainFrame;
        }

        @Override
        protected void onCancelled() {
            stopProgressDialog();
            super.onCancelled();
        }

        @Override
        protected void onPreExecute() {
            startProgressDialog();
        }

        @Override
        protected void onPostExecute(JSONObject result) {// 可以与UI控件交互
            System.out.println("-----result--->" + result);
            try {
                String noticetitle = result.getString("Value");
                lstnotices = XinTiJsonjiexi.getJSONArrayGonggao(noticetitle);
                arrtitles = new ArrayList<String>();
                arrids = new ArrayList<String>();
                CreateTime = new ArrayList<String>();
                CreateBy = new ArrayList<String>();
                System.out.println("------title----->" + lstnotices.get(1).get("Title"));
                for (int i = 0; i < lstnotices.size(); i++) {
                    System.out.println("------title----->" + lstnotices.get(i).get("Title"));
                    Application.gonggaolist.add(lstnotices.get(i).get("Title"));
                    arrtitles.add(lstnotices.get(i).get("Title"));
                    arrids.add(lstnotices.get(i).get("Id"));
                    CreateTime.add(lstnotices.get(i).get("CreateTime"));
                    CreateBy.add(lstnotices.get(i).get("CreateBy"));
                }
                if (arrtitles.size() == 0) {
                    mlishowtishi.setVisibility(View.VISIBLE);
                } else {
                    mlishowtishi.setVisibility(View.GONE);
                }
                noticeListquery();

            } catch (JSONException e) {
                e.printStackTrace();
                mlishowtishi.setVisibility(View.VISIBLE);
            } catch (Exception e) {
                e.printStackTrace();
                mlishowtishi.setVisibility(View.VISIBLE);
            }
            stopProgressDialog();
        }

        @Override
        protected JSONObject doInBackground(JSONObject... params) {

            String msgid = "chaxungonggao";
            List<NameValuePair> namevalue = XinTiJson.Zeroparameter0(XinTiRequestcode.Select_article_Code, msgid);
            JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
            return jsonobj;
        }

        @Override
        protected void onProgressUpdate(String... values) {
            // 可以与UI控件交互
            super.onProgressUpdate(values);
        }
    }
}
